/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.segmentation.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.segmentation.SegmentationResolver;

public class TcpSegmentationResolver
implements SegmentationResolver {
    private static final long serialVersionUID = -4401160065441207262L;
    public static final int DFLT_LOC_PORT = 0;
    public static final int DFLT_CONN_TIMEOUT = 1000;
    private InetSocketAddress addr;
    private String host;
    private int port = -1;
    private InetAddress locAddr;
    private int locPort = 0;
    private int connTimeout = 1000;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public boolean isValidSegment() throws IgniteCheckedException {
        this.init();
        Socket sock = null;
        try {
            sock = new Socket();
            sock.bind(new InetSocketAddress(this.locAddr, this.locPort));
            sock.connect(new InetSocketAddress(this.addr.getAddress(), this.addr.getPort()), this.connTimeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to check address reachability: " + this.addr, (Throwable)e);
        }
        finally {
            U.closeQuiet((Socket)sock);
        }
    }

    private void init() throws IgniteCheckedException {
        block9: {
            if (this.initGuard.compareAndSet(false, true)) {
                try {
                    if (this.addr == null) {
                        if (this.host == null || this.port < 0) {
                            throw new IgniteCheckedException("Failed to initialize address of the segmentation resolver (either address or host and port should be set): " + this);
                        }
                        this.addr = new InetSocketAddress(this.host, this.port);
                    }
                    if (this.locPort < 0) {
                        throw new IgniteCheckedException("Failed to initialize segmentation resolver (local port cannot be negative): " + this);
                    }
                    if (this.connTimeout < 0) {
                        throw new IgniteCheckedException("Failed to initialize segmentation resolver (connect timeout cannot be negative): " + this);
                    }
                    break block9;
                }
                finally {
                    this.initLatch.countDown();
                }
            }
            U.await((CountDownLatch)this.initLatch);
            if (this.addr == null) {
                throw new IgniteCheckedException("Segmentation resolver was not properly initialized.");
            }
        }
    }

    public TcpSegmentationResolver setAddress(InetSocketAddress addr) {
        this.addr = addr;
        return this;
    }

    public TcpSegmentationResolver setAddressAsString(String addr) throws IgniteCheckedException {
        A.notNull((Object)addr, (String)"addr");
        StringTokenizer st = new StringTokenizer(addr, ":");
        if (st.countTokens() != 2) {
            throw new IgniteCheckedException("Failed to parse address");
        }
        String addrStr = st.nextToken();
        String portStr = st.nextToken();
        try {
            int port = Integer.parseInt(portStr);
            this.addr = new InetSocketAddress(addrStr, port);
        }
        catch (IllegalArgumentException e) {
            throw new IgniteCheckedException("Failed to parse provided address: " + addr, (Throwable)e);
        }
        return this;
    }

    public TcpSegmentationResolver setHost(String host) {
        this.host = host;
        return this;
    }

    public TcpSegmentationResolver setPort(int port) {
        this.port = port;
        return this;
    }

    public TcpSegmentationResolver setLocalAddress(InetAddress locAddr) throws IgniteCheckedException {
        this.locAddr = locAddr;
        return this;
    }

    public TcpSegmentationResolver setLocalAddressAsString(String locAddr) throws IgniteCheckedException {
        try {
            this.locAddr = InetAddress.getByName(locAddr);
        }
        catch (UnknownHostException e) {
            throw new IgniteCheckedException("Failed to get address by name: " + this.addr, (Throwable)e);
        }
        return this;
    }

    public TcpSegmentationResolver setLocalPort(int locPort) {
        this.locPort = locPort;
        return this;
    }

    public int getConnectTimeout() {
        return this.connTimeout;
    }

    public TcpSegmentationResolver setConnectTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public String toString() {
        return S.toString(TcpSegmentationResolver.class, (Object)this);
    }
}

