/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.persistentstore.SnapshotChainMode;

public class SnapshotUpdateOperationParams {
    private SnapshotChainMode chainMode = SnapshotChainMode.DEFAULT;
    private boolean deleteSources;
    private boolean singleFileCopy;
    private Integer parallelismLevel;

    public SnapshotUpdateOperationParams() {
    }

    public SnapshotUpdateOperationParams(SnapshotChainMode chainMode) {
        this(chainMode, false, false, null);
    }

    public SnapshotUpdateOperationParams(SnapshotChainMode chainMode, boolean deleteSources, boolean singleFileCopy, Integer parallelismLevel) {
        this.chainMode = chainMode;
        this.deleteSources = deleteSources;
        this.singleFileCopy = singleFileCopy;
        this.parallelismLevel = parallelismLevel;
    }

    public SnapshotChainMode chainMode() {
        return this.chainMode;
    }

    public boolean removeSources() {
        return this.deleteSources;
    }

    public boolean singleFileCopy() {
        return this.singleFileCopy;
    }

    public Integer parallelismLevel() {
        return this.parallelismLevel;
    }

    public String toString() {
        return S.toString(SnapshotUpdateOperationParams.class, (Object)this);
    }

    public static class Builder {
        private SnapshotChainMode mode;
        private Boolean deleteSources;
        private Boolean singleFileCopy;
        private Integer parralelismLevel;

        public Builder withChainMode(SnapshotChainMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withDeleteSources(Boolean deleteSources) {
            this.deleteSources = deleteSources;
            return this;
        }

        public Builder withSingleFileCopy(Boolean singleFileCopy) {
            this.singleFileCopy = singleFileCopy;
            return this;
        }

        public Builder withParralelismLevel(Integer parralelismLevel) {
            this.parralelismLevel = parralelismLevel;
            return this;
        }

        public SnapshotUpdateOperationParams build() {
            return new SnapshotUpdateOperationParams(this.mode, Boolean.TRUE == this.deleteSources, Boolean.TRUE == this.singleFileCopy, this.parralelismLevel);
        }
    }
}

