/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskResult;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.gridgain.grid.internal.visor.dr.VisorDr;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheMetrics;
import org.gridgain.grid.internal.visor.license.VisorLicense;

public class VisorGridGainNodeDataCollectorTaskResult
extends VisorNodeDataCollectorTaskResult {
    private static final long serialVersionUID = 0L;
    private Map<UUID, VisorLicense> licenses = new HashMap<UUID, VisorLicense>();
    private Map<UUID, VisorExceptionWrapper> licensesEx = new HashMap<UUID, VisorExceptionWrapper>();
    private Map<UUID, VisorDr> drs = new HashMap<UUID, VisorDr>();
    private Map<UUID, Collection<VisorDrCacheMetrics>> drsCacheMetrics = new HashMap<UUID, Collection<VisorDrCacheMetrics>>();
    private Map<UUID, VisorExceptionWrapper> drsEx = new HashMap<UUID, VisorExceptionWrapper>();

    public boolean isEmpty() {
        return super.isEmpty() && this.licenses.isEmpty() && this.licensesEx.isEmpty() && this.drs.isEmpty() && this.drsCacheMetrics.isEmpty() && this.drsEx.isEmpty();
    }

    public Map<UUID, VisorLicense> getLicenses() {
        return this.licenses;
    }

    public Map<UUID, VisorExceptionWrapper> getLicensesEx() {
        return this.licensesEx;
    }

    public Map<UUID, VisorDr> getDrs() {
        return this.drs;
    }

    public Map<UUID, Collection<VisorDrCacheMetrics>> getDrsCacheMetrics() {
        return this.drsCacheMetrics;
    }

    public Map<UUID, VisorExceptionWrapper> getDrsEx() {
        return this.drsEx;
    }

    public byte getProtocolVersion() {
        return 1;
    }

    public void add(VisorNodeDataCollectorTaskResult res) {
        super.add(res);
        if (res instanceof VisorGridGainNodeDataCollectorTaskResult) {
            VisorGridGainNodeDataCollectorTaskResult ggRes = (VisorGridGainNodeDataCollectorTaskResult)res;
            this.licenses.putAll(ggRes.getLicenses());
            this.licensesEx.putAll(ggRes.getLicensesEx());
            this.drs.putAll(ggRes.getDrs());
            this.drsCacheMetrics.putAll(ggRes.getDrsCacheMetrics());
            this.drsEx.putAll(ggRes.getDrsEx());
        }
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte((int)super.getProtocolVersion());
            super.writeExternalData((ObjectOutput)dtout);
        }
        U.writeMap((ObjectOutput)out, this.licenses);
        U.writeMap((ObjectOutput)out, this.licensesEx);
        U.writeMap((ObjectOutput)out, this.drs);
        U.writeMap((ObjectOutput)out, this.drsCacheMetrics);
        U.writeMap((ObjectOutput)out, this.drsEx);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), (ObjectInput)dtin);
        }
        this.licenses = U.readMap((ObjectInput)in);
        this.licensesEx = U.readMap((ObjectInput)in);
        this.drs = U.readMap((ObjectInput)in);
        this.drsCacheMetrics = U.readMap((ObjectInput)in);
        this.drsEx = U.readMap((ObjectInput)in);
    }

    public String toString() {
        return S.toString(VisorGridGainNodeDataCollectorTaskResult.class, (Object)((Object)this));
    }
}

