/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheReplicationManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrStateTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrStateTaskResult;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.visor.dr.VisorDrCacheStatus;
import org.gridgain.grid.internal.visor.dr.console.VisorDrStateLocalTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorDrStateTask
extends VisorMultiNodeTask<VisorDrStateTaskArgs, VisorDrStateTaskResult, VisorDrStateLocalTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorDrStateTaskArgs, VisorDrStateLocalTaskResult> job(VisorDrStateTaskArgs arg) {
        return new VisorDrStateJob(arg, this.debug);
    }

    @Nullable
    protected VisorDrStateTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        String cacheName;
        VisorDrStateTaskResult res = new VisorDrStateTaskResult();
        TreeSet<String> sndNames = new TreeSet<String>();
        HashSet<String> existingSndNames = new HashSet<String>();
        TreeSet<String> rcvNames = new TreeSet<String>();
        Boolean verbose = null;
        boolean useCacheNames = false;
        TreeMap<String, List> missingConflictResolvers = new TreeMap<String, List>();
        for (ComputeJobResult result : results) {
            Object data = (VisorDrStateLocalTaskResult)((Object)result.getData());
            if (data == null) continue;
            sndNames.addAll(data.getSndNames());
            existingSndNames.addAll(data.getSndState().keySet());
            rcvNames.addAll(data.getRcvState().keySet());
        }
        HashMap<String, List> stoppedCaches = new HashMap<String, List>();
        HashMap<String, List> failedCaches = new HashMap<String, List>();
        for (ComputeJobResult result : results) {
            List rslvrMissingCaches;
            VisorDrStateLocalTaskResult data = (VisorDrStateLocalTaskResult)((Object)result.getData());
            if (data == null) continue;
            verbose = data.isVerbose();
            if (data.getDataCenterId() == 0) continue;
            useCacheNames = data.isUseCacheNames();
            res.setDataCenterId(data.getDataCenterId());
            UUID nodeId = result.getNode().id();
            for (List<T2<String, VisorDrCacheStatus>> list : data.getSndState().values()) {
                for (T2<String, VisorDrCacheStatus> t2 : list) {
                    String cacheName2 = (String)t2.get1();
                    VisorDrCacheStatus cacheStatus = (VisorDrCacheStatus)((Object)t2.get2());
                    if (cacheStatus.isPaused()) {
                        stoppedCaches.computeIfAbsent(cacheName2, k -> new ArrayList()).add(IgniteUtils.tuple((Object)nodeId, (Object)cacheStatus.getReason().toString()));
                    }
                    if (cacheStatus.getErrorMessage() == null) continue;
                    failedCaches.computeIfAbsent(cacheName2, k -> new ArrayList()).add(IgniteUtils.tuple((Object)nodeId, (Object)cacheStatus.getErrorMessage()));
                }
            }
            if (data.getSndState().isEmpty() || data.getRcvState().isEmpty() || (rslvrMissingCaches = data.getRcvState().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) continue;
            for (String cacheName3 : rslvrMissingCaches) {
                missingConflictResolvers.computeIfAbsent(cacheName3, k -> new ArrayList()).add(nodeId);
            }
        }
        if (verbose == null) {
            return res;
        }
        if (!existingSndNames.isEmpty() && !rcvNames.isEmpty()) {
            res.addResultMessage("Data Replication state: sending and receiving updates.");
        } else if (!existingSndNames.isEmpty()) {
            res.addResultMessage("Data Replication state: sending updates.");
        } else if (!rcvNames.isEmpty()) {
            res.addResultMessage("Data Replication state: receiving updates.");
        } else {
            res.addResultMessage("Data Replication state: not operational.");
        }
        if (!sndNames.isEmpty()) {
            if (verbose.booleanValue()) {
                res.addResultMessage("Configured" + (useCacheNames ? " sender cache names: " : " sender groups: ") + sndNames);
            }
            HashSet missingNames = new HashSet(sndNames);
            missingNames.removeAll(existingSndNames);
            if (!missingNames.isEmpty()) {
                res.addResultMessage(missingNames.size() + (useCacheNames ? " sender cache names " : " sender groups ") + "configured that have no corresponding caches" + (verbose != false ? ": " + ((Object)missingNames).toString() : "."));
            }
        }
        if (!existingSndNames.isEmpty()) {
            HashSet extraNames = new HashSet(existingSndNames);
            extraNames.removeAll(sndNames);
            if (!extraNames.isEmpty()) {
                res.addResultMessage(extraNames.size() + (useCacheNames ? " sender cache names " : " sender groups ") + "configured that have no corresponding sender hubs" + (verbose != false ? ": " + ((Object)extraNames).toString() : "."));
            }
        }
        if (!rcvNames.isEmpty()) {
            if (verbose.booleanValue()) {
                res.addResultMessage("Configured receiver caches: " + rcvNames);
            } else {
                res.addResultMessage("Configured " + rcvNames.size() + " receiver caches.");
            }
        }
        if (verbose.booleanValue()) {
            for (Map.Entry entry : missingConflictResolvers.entrySet()) {
                res.addResultMessage(String.format("Conflict resolver is not configured for cache \"%s\" on nodes %s", entry.getKey(), entry.getValue()));
            }
        } else if (!missingConflictResolvers.isEmpty()) {
            int nodesCnt = missingConflictResolvers.values().stream().mapToInt(List::size).max().getAsInt();
            res.addResultMessage(String.format("Conflict resolver is not configured for %d caches on %d nodes.", missingConflictResolvers.size(), nodesCnt));
        }
        if (verbose.booleanValue()) {
            for (Map.Entry entry : stoppedCaches.entrySet()) {
                cacheName = (String)entry.getKey();
                Map<String, List<T2>> stopMsgMap = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(IgniteBiTuple::get2));
                for (Map.Entry entry2 : stopMsgMap.entrySet()) {
                    res.addResultMessage(String.format("Cache %s is stopped with reason \"%s\" on nodes: %s", cacheName, entry2.getKey(), ((List)entry2.getValue()).stream().map(IgniteBiTuple::get1).collect(Collectors.toList()).toString()));
                }
            }
        } else if (!stoppedCaches.isEmpty()) {
            int cachesCnt = stoppedCaches.size();
            long nodesCnt = stoppedCaches.values().stream().flatMap(Collection::stream).map(IgniteBiTuple::get1).distinct().count();
            res.addResultMessage(String.format("%d cache replications are stopped on %d nodes.", cachesCnt, nodesCnt));
        }
        if (verbose.booleanValue()) {
            for (Map.Entry entry : failedCaches.entrySet()) {
                cacheName = (String)entry.getKey();
                Map<String, List<T2>> failMsgMap = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(IgniteBiTuple::get2));
                for (Map.Entry entry3 : failMsgMap.entrySet()) {
                    res.addResultMessage(String.format("Cache %s is failed with reason \"%s\" on nodes: %s", cacheName, entry3.getKey(), ((List)entry3.getValue()).stream().map(IgniteBiTuple::get1).collect(Collectors.toList()).toString()));
                }
            }
        } else if (!failedCaches.isEmpty()) {
            int cachesCnt = failedCaches.size();
            long nodesCnt = failedCaches.values().stream().flatMap(Collection::stream).map(IgniteBiTuple::get1).distinct().count();
            res.addResultMessage(String.format("%d caches have replication errors on %d nodes.", cachesCnt, nodesCnt));
        }
        return res;
    }

    private static class VisorDrStateJob
    extends VisorJob<VisorDrStateTaskArgs, VisorDrStateLocalTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrStateJob(VisorDrStateTaskArgs arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorDrStateLocalTaskResult run(@Nullable VisorDrStateTaskArgs arg) throws IgniteException {
            Objects.requireNonNull(arg, "arg");
            VisorDrStateLocalTaskResult res = new VisorDrStateLocalTaskResult();
            res.setVerbose(arg.isVerbose());
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridGainConfiguration pluginCfg = plugin.configuration();
            res.setDataCenterId(pluginCfg.getDataCenterId());
            DrSenderConfiguration sndHubCfg = pluginCfg.getDrSenderConfiguration();
            DrReceiverConfiguration rcvHubCfg = pluginCfg.getDrReceiverConfiguration();
            boolean useCacheNames = pluginCfg.isDrUseCacheNames();
            res.setUseCacheNames(useCacheNames);
            GridDr dr = plugin.dr();
            if (sndHubCfg != null) {
                HashSet<String> sndNames = new HashSet<String>(Arrays.asList(useCacheNames ? sndHubCfg.getCacheNames() : DrUtils.effectiveSenderGroups(sndHubCfg)));
                res.setSndNames(sndNames);
            } else {
                res.setSndNames(Collections.emptySet());
            }
            HashMap<String, List<T2<String, VisorDrCacheStatus>>> sndState = new HashMap<String, List<T2<String, VisorDrCacheStatus>>>();
            res.setSndState(sndState);
            for (String cacheName : this.ignite.cacheNames()) {
                CacheDrSenderConfiguration sndCfg;
                GridGainCacheConfiguration ggCcfg;
                IgniteInternalCache cachex = this.ignite.cachex(cacheName);
                if (cachex == null || (ggCcfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)cachex.configuration(), GridGainCacheConfiguration.class)) == null || (sndCfg = ggCcfg.getDrSenderConfiguration()) == null && !useCacheNames) continue;
                String name = useCacheNames ? cacheName : DrUtils.effectiveSenderGroup(sndCfg);
                try {
                    CacheDrSenderMetrics sndMetrics = dr.senderCacheMetrics(cacheName);
                    if (sndMetrics.status() == null) continue;
                    sndState.computeIfAbsent(name, k -> new ArrayList()).add(IgniteUtils.tuple((Object)cacheName, (Object)((Object)new VisorDrCacheStatus(sndMetrics.status()))));
                }
                catch (IllegalStateException sndMetrics) {}
            }
            HashMap<String, Boolean> rcvState = new HashMap<String, Boolean>();
            res.setRcvState(rcvState);
            if (rcvHubCfg != null) {
                for (String cacheName : this.ignite.cacheNames()) {
                    GridGainCacheConfiguration ggCcfg;
                    IgniteInternalCache cachex = this.ignite.cachex(cacheName);
                    if (cachex == null || (ggCcfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)cachex.configuration(), GridGainCacheConfiguration.class)) == null) continue;
                    GridCacheReplicationManager drMgr = cachex.context().dr();
                    boolean rslvrMissing = false;
                    if (drMgr.receiveEnabled() && ggCcfg.getConflictResolver() == null) {
                        rslvrMissing = true;
                    }
                    rcvState.put(cacheName, rslvrMissing);
                }
            }
            return res;
        }
    }
}

