/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataUpdatedListener;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.marshaller.GridMarshallerMappingProcessor;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.marshaller.MappingUpdatedListener;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCorruptedException;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.dr.store.fs.DrSenderFsStore;
import org.gridgain.grid.events.DrStoreEvent;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.store.DrMetadataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrMetadataAwareStore {
    private static final byte META_STORE_DC_ID = 1;
    private static final byte[] META_STORE_DC_ID_ARR = new byte[]{1};
    private static final String META_DIR = "meta";
    private static final String BINARY_META_DIR = "meta-binary";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final GridKernalContext kctx;
    protected final IgniteLogger log;
    private final DrSenderStore store;
    private final DrSenderFsStore metaStore;
    private final DrSenderFsStore binaryMetaStore;
    private final IgniteCacheObjectProcessor cacheObjProc;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final GridMarshallerMappingProcessor mappingProc;
    private DrSenderMetadataHolder meta = DrSenderMetadataHolder.INITIAL;
    private DrMetadataListener drMetadataListener;
    private final boolean isIncrementalDrEnabled = DrUtils.isIncrementalDrEnabled();

    DrMetadataAwareStore(GridKernalContext kctx, @NotNull DrSenderStore store) {
        this.kctx = kctx;
        this.store = store;
        this.log = kctx.log(DrMetadataAwareStore.class);
        this.cacheObjProc = kctx.cacheObjects();
        this.mappingProc = kctx.mapping();
        if (!this.isIncrementalDrEnabled && store instanceof DrSenderFsStore) {
            String path = ((DrSenderFsStore)store).getDirectoryPath();
            this.metaStore = new DrSenderFsStore();
            this.metaStore.setDirectoryPath(Paths.get(path, META_DIR).toString());
            this.metaStore.setOverflowMode(((DrSenderFsStore)store).getOverflowMode());
            this.binaryMetaStore = new DrSenderFsStore();
            this.binaryMetaStore.setDirectoryPath(Paths.get(path, BINARY_META_DIR).toString());
            this.binaryMetaStore.setOverflowMode(((DrSenderFsStore)store).getOverflowMode());
        } else {
            this.metaStore = null;
            this.binaryMetaStore = null;
        }
    }

    void start() throws IgniteCheckedException {
        this.kctx.resource().injectGeneric((Object)this.store);
        U.startLifecycleAware(Collections.singleton(this.store));
        if (this.metaStore != null && this.binaryMetaStore != null) {
            this.kctx.resource().injectGeneric((Object)this.metaStore);
            this.kctx.resource().injectGeneric((Object)this.binaryMetaStore);
            U.startLifecycleAware(Collections.singleton(this.metaStore));
            U.startLifecycleAware(Collections.singleton(this.binaryMetaStore));
        }
        IgniteCacheObjectProcessor cacheObjectProc = this.kctx.cacheObjects();
        assert (cacheObjectProc instanceof CacheObjectBinaryProcessorImpl);
        ((CacheObjectBinaryProcessorImpl)cacheObjectProc).addBinaryMetadataUpdateListener((BinaryMetadataUpdatedListener)new BinaryMetadataUpdatesListener());
        this.mappingProc.addMappingUpdatedListener((MappingUpdatedListener)new MarshallerUpdatesListener());
    }

    void onKernalStart() throws IgniteCheckedException {
        Map<String, IgniteBiTuple<Byte, Integer>> metadata = new HashMap<String, IgniteBiTuple<Byte, Integer>>();
        Map<String, BinaryMetadata> binaryMetadata = new HashMap<String, BinaryMetadata>();
        if (this.metaStore != null && this.binaryMetaStore != null) {
            this.lock.writeLock().lock();
            try {
                if (this.isDataStoreEmpty()) {
                    this.metaStore.clear();
                    this.binaryMetaStore.clear();
                } else {
                    metadata = this.readMetadataStore();
                    binaryMetadata = this.readBinaryMetadataStore();
                }
            }
            catch (DrSenderStoreCorruptedException e) {
                this.recordMetaStoreCorruptedEvt();
                throw e;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        for (BinaryType type : this.cacheObjProc.metadata()) {
            if (!(type instanceof BinaryTypeImpl)) continue;
            BinaryMetadata binMeta = ((BinaryTypeImpl)type).metadata();
            binaryMetadata.put(binMeta.typeName(), binMeta);
        }
        this.updateBinaryMetadata(binaryMetadata);
        this.updateMarshallerMappingsForKnownBinaryTypes(metadata);
    }

    private void recordMetaStoreCorruptedEvt() {
        ClusterNode node = this.kctx.discovery().localNode();
        if (this.kctx.event().isUserRecordable(1027)) {
            this.kctx.event().record((Event)new DrStoreEvent(node, "Meta store corrupted.", 1027, null));
        }
    }

    void stop() {
        if (this.metaStore != null) {
            U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.metaStore));
        }
        if (this.binaryMetaStore != null) {
            U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.binaryMetaStore));
        }
        U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.store));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DrSenderMetadataHolder getMetadata(long metaVer) {
        DrSenderMetadataHolder metaSnapshot = null;
        this.lock.readLock().lock();
        try {
            if (this.meta.version() > metaVer) {
                metaSnapshot = this.meta;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (metaSnapshot == null) {
            return null;
        }
        HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> commonMetadataDifference = new HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>>();
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : metaSnapshot.metadata().entrySet()) {
            if (entry.getValue().version() <= metaVer) continue;
            commonMetadataDifference.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> binaryMetadataDifference = new HashMap<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>>();
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> entry : metaSnapshot.binaryMetadata().entrySet()) {
            if (entry.getValue().version() <= metaVer) continue;
            binaryMetadataDifference.put(entry.getKey(), entry.getValue());
        }
        return new DrSenderMetadataHolder(metaSnapshot.version(), commonMetadataDifference, binaryMetadataDifference);
    }

    public void updateMarshallerMappingsForKnownBinaryTypes(String name, byte platformId, int id) throws IgniteCheckedException {
        assert (name != null);
        this.updateMarshallerMappingsForKnownBinaryTypes(Collections.singletonMap(name, F.t((Object)platformId, (Object)id)));
    }

    public void updateBinaryMetadata(BinaryMetadata binaryMetadata) throws IgniteCheckedException {
        this.updateBinaryMetadata(Collections.singletonMap(binaryMetadata.typeName(), binaryMetadata));
    }

    private boolean checkMappingsAndMetaConsistency(DrSenderMetadataHolder meta) {
        Set<String> mappings = meta.metadata().keySet();
        Set<String> binaryMeta = meta.binaryMetadata().keySet();
        return mappings.size() == binaryMeta.size() && mappings.containsAll(binaryMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarshallerMappingsForKnownBinaryTypes(Map<String, IgniteBiTuple<Byte, Integer>> newMapping) throws IgniteCheckedException {
        DrSenderMetadataHolder metadataUpdate;
        if (F.isEmpty(newMapping)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Submit marshaller data.");
        }
        this.lock.writeLock().lock();
        try {
            DrSenderMetadataHolder newMeta;
            long newVersion = this.meta.version() + 1L;
            Map currentMetadata = this.meta.metadata();
            Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> currentBinaryMeta = this.meta.binaryMetadata();
            IgnitePredicate[] ignitePredicateArray = new IgnitePredicate[1];
            ignitePredicateArray[0] = currentBinaryMeta::containsKey;
            Map filteredMapping = F.view(newMapping, (IgnitePredicate[])ignitePredicateArray);
            Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> newMetaDiff = this.createMetadataDiff(newVersion, filteredMapping, currentMetadata);
            if (newMetaDiff.isEmpty()) {
                return;
            }
            this.saveGeneralMetadataToStore(newMetaDiff);
            Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> merged = DrMetadataAwareStore.mergeMetadata(currentMetadata, newMetaDiff);
            this.meta = newMeta = new DrSenderMetadataHolder(newVersion, merged, this.meta.binaryMetadata());
            metadataUpdate = this.drMetadataListener != null && this.checkMappingsAndMetaConsistency(newMeta) ? new DrSenderMetadataHolder(newVersion, newMetaDiff, Collections.emptyMap()) : null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.drMetadataListener != null && metadataUpdate != null) {
            this.drMetadataListener.onMetadataUpdate(metadataUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBinaryMetadata(Map<String, BinaryMetadata> newBinaryMeta) throws IgniteCheckedException {
        DrSenderMetadataHolder metadataUpdate;
        if (F.isEmpty(newBinaryMeta)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Submit marshaller binary meta.");
        }
        this.lock.writeLock().lock();
        try {
            long newVersion = this.meta.version() + 1L;
            Map currentBinaryMeta = this.meta.binaryMetadata();
            Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> newBinaryMetaDiff = this.createMetadataDiff(newVersion, newBinaryMeta, currentBinaryMeta);
            if (newBinaryMetaDiff.isEmpty()) {
                return;
            }
            Collection typeIdView = F.transform((Collection)F.view(newBinaryMetaDiff.values(), (IgnitePredicate[])new IgnitePredicate[0]), (IgniteClosure & Serializable)v -> ((BinaryMetadata)v.value()).typeId());
            Map<String, IgniteBiTuple<Byte, Integer>> resolvedMapping = this.getMappingForTypeIds(typeIdView);
            Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> mappingForBinaryMeta = this.createMetadataDiff(newVersion, resolvedMapping, Collections.emptyMap());
            this.saveGeneralMetadataToStore(mappingForBinaryMeta);
            this.saveBinaryMetadataToStore(newBinaryMetaDiff);
            Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> mergedBinaryMeta = DrMetadataAwareStore.mergeMetadata(currentBinaryMeta, newBinaryMetaDiff);
            Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> mergedMapping = DrMetadataAwareStore.mergeMetadata(this.meta.metadata(), mappingForBinaryMeta);
            this.meta = new DrSenderMetadataHolder(newVersion, mergedMapping, mergedBinaryMeta);
            metadataUpdate = new DrSenderMetadataHolder(newVersion, mappingForBinaryMeta, newBinaryMetaDiff);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.drMetadataListener != null && this.checkMappingsAndMetaConsistency(metadataUpdate)) {
            this.drMetadataListener.onMetadataUpdate(metadataUpdate);
        }
    }

    private <T> Map<String, DrSenderMetadataHolder.Versioned<T>> createMetadataDiff(long newVersion, Map<String, T> newValues, Map<String, DrSenderMetadataHolder.Versioned<T>> oldValues) {
        HashMap result = U.newHashMap((int)newValues.size());
        newValues.entrySet().stream().filter(e -> !e.getValue().equals(oldValues.get(e.getKey()))).forEach(e -> result.put(e.getKey(), new DrSenderMetadataHolder.Versioned(newVersion, e.getValue())));
        return result;
    }

    private static <T> Map<String, DrSenderMetadataHolder.Versioned<T>> mergeMetadata(Map<String, DrSenderMetadataHolder.Versioned<T>> actualMetadata, Map<String, DrSenderMetadataHolder.Versioned<T>> metadataUpdate) {
        HashMap merged = U.newHashMap((int)(actualMetadata.size() + metadataUpdate.size()));
        merged.putAll(actualMetadata);
        merged.putAll(metadataUpdate);
        return merged;
    }

    private Map<String, IgniteBiTuple<Byte, Integer>> getMappingForTypeIds(Collection<Integer> typeIds) {
        HashMap mappingForNewMeta = U.newHashMap((int)typeIds.size());
        ArrayList mappings = this.kctx.marshallerContext().getCachedMappings();
        for (byte platformId = 0; platformId < mappings.size(); platformId = (byte)((byte)(platformId + 1))) {
            for (Integer typeId : typeIds) {
                MappedName mappedName = (MappedName)((Map)mappings.get(platformId)).get(typeId);
                if (mappedName == null) continue;
                mappingForNewMeta.put(mappedName.className(), new IgniteBiTuple((Object)platformId, (Object)typeId));
            }
        }
        return mappingForNewMeta;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, BinaryMetadata> readBinaryMetadataStore() throws IgniteCheckedException {
        try (DrSenderStoreCursor cursor = this.binaryMetaStore.cursor((byte)1);){
            DrSenderStoreEntry binaryMetaEntry;
            HashMap<String, BinaryMetadata> storeVals = new HashMap<String, BinaryMetadata>();
            while ((binaryMetaEntry = cursor.next()) != null) {
                BinaryMetadata binaryMetadata = this.unmarshalBinaryMetadata(binaryMetaEntry.data());
                storeVals.put(binaryMetadata.typeName(), binaryMetadata);
            }
            HashMap<String, BinaryMetadata> hashMap = storeVals;
            return hashMap;
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, IgniteBiTuple<Byte, Integer>> readMetadataStore() throws IgniteCheckedException {
        try (DrSenderStoreCursor cursor = this.metaStore.cursor((byte)1);){
            DrSenderStoreEntry metaEntry;
            HashMap<String, IgniteBiTuple<Byte, Integer>> storeVals = new HashMap<String, IgniteBiTuple<Byte, Integer>>();
            while ((metaEntry = cursor.next()) != null) {
                IgniteBiTuple<String, IgniteBiTuple<Byte, Integer>> tuple = this.unmarshal(metaEntry.data());
                storeVals.put((String)tuple.get1(), (IgniteBiTuple<Byte, Integer>)tuple.get2());
            }
            HashMap<String, IgniteBiTuple<Byte, Integer>> hashMap = storeVals;
            return hashMap;
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private void saveGeneralMetadataToStore(Map<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> values) throws IgniteCheckedException {
        if (this.metaStore == null) {
            return;
        }
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : values.entrySet()) {
            this.metaStore.store(META_STORE_DC_ID_ARR, this.marshal(entry.getKey(), entry.getValue().value()), 1, null);
        }
    }

    private void saveBinaryMetadataToStore(Map<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> values) throws IgniteCheckedException {
        if (this.binaryMetaStore == null) {
            return;
        }
        for (Map.Entry<String, DrSenderMetadataHolder.Versioned<BinaryMetadata>> entry : values.entrySet()) {
            this.binaryMetaStore.store(META_STORE_DC_ID_ARR, this.marshal(entry.getValue().value()), 1, null);
        }
    }

    private boolean isDataStoreEmpty() {
        return this.store.sizeBytes() == 0L;
    }

    private byte[] marshal(String name, IgniteBiTuple<Byte, Integer> idTuple) {
        byte[] nameBytes = name.getBytes(UTF8);
        BinaryHeapOutputStream stream = new BinaryHeapOutputStream(nameBytes.length + 8);
        stream.writeByte(((Byte)idTuple.get1()).byteValue());
        stream.writeInt(((Integer)idTuple.get2()).intValue());
        stream.writeInt(nameBytes.length);
        stream.writeByteArray(nameBytes);
        return stream.array();
    }

    private byte[] marshal(BinaryMetadata binaryMetadata) throws IgniteCheckedException {
        try {
            GridUnsafeDataOutput out = new GridUnsafeDataOutput(128);
            binaryMetadata.writeTo((DataOutput)out);
            return out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not marshal binary metadata.", (Throwable)e);
        }
    }

    private IgniteBiTuple<String, IgniteBiTuple<Byte, Integer>> unmarshal(byte[] data) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(data);
        byte platformId = stream.readByte();
        int typeId = stream.readInt();
        int nameLen = stream.readInt();
        byte[] nameBytes = stream.readByteArray(nameLen);
        String name = new String(nameBytes, UTF8);
        return F.t((Object)name, (Object)F.t((Object)platformId, (Object)typeId));
    }

    private BinaryMetadata unmarshalBinaryMetadata(byte[] data) throws IgniteCheckedException {
        try {
            GridUnsafeDataInput in = new GridUnsafeDataInput();
            in.bytes(data, data.length);
            BinaryMetadata binaryMetadata = new BinaryMetadata();
            binaryMetadata.readFrom((DataInput)in);
            return binaryMetadata;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not unmarshal binary metadata.", (Throwable)e);
        }
    }

    DrSenderStoreCursor createCursor(byte dataCenterId) throws IgniteCheckedException {
        return this.store.cursor(dataCenterId);
    }

    public void store(byte[] dataCenterIds, byte[] data, int cnt) throws IgniteCheckedException {
        this.store.store(dataCenterIds, data, cnt, null);
    }

    public void clear() throws IgniteCheckedException {
        this.store.clear();
    }

    public boolean isOverflow() {
        return this.store.isOverflow();
    }

    public void setDrMetadataListener(DrMetadataListener drMetadataListener) {
        this.drMetadataListener = drMetadataListener;
    }

    public DrSenderStore getStore() {
        return this.store;
    }

    private class BinaryMetadataUpdatesListener
    implements BinaryMetadataUpdatedListener {
        private BinaryMetadataUpdatesListener() {
        }

        public void binaryMetadataUpdated(BinaryMetadata metadata) {
            try {
                DrMetadataAwareStore.this.updateBinaryMetadata(metadata);
            }
            catch (Exception e) {
                throw new CacheEntryListenerException("Failed to process DR marshaller metadata update.", (Throwable)e);
            }
        }
    }

    private class MarshallerUpdatesListener
    implements MappingUpdatedListener {
        private MarshallerUpdatesListener() {
        }

        public void mappingUpdated(byte platformId, int typeId, String typeName) throws CacheEntryListenerException {
            try {
                DrMetadataAwareStore.this.updateMarshallerMappingsForKnownBinaryTypes(typeName, platformId, typeId);
            }
            catch (IgniteCheckedException e) {
                throw new CacheEntryListenerException("Failed to process DR marshaller metadata update.", (Throwable)e);
            }
        }
    }
}

