/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.messages;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class DrInternalResponse
implements Message {
    private static final long serialVersionUID = 0L;
    private long id;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;
    private byte code;

    public DrInternalResponse() {
    }

    public DrInternalResponse(long id, @Nullable Throwable err, byte code) {
        assert (id > 0L);
        this.id = id;
        this.err = err;
        this.code = code;
    }

    public long id() {
        return this.id;
    }

    @Nullable
    public Throwable error() {
        assert (this.err != null || this.errBytes == null);
        return this.err;
    }

    public byte code() {
        return this.code;
    }

    public void code(byte code) {
        this.code = code;
    }

    public void onAckReceived() {
    }

    public void prepareMarshal(Marshaller marsh) throws IgniteCheckedException {
        if (this.errBytes == null && this.err != null) {
            this.errBytes = marsh.marshal((Object)this.err);
        }
    }

    public void finishUnmarshal(Marshaller marsh, ClassLoader loader) throws IgniteCheckedException {
        if (this.errBytes != null && this.err == null) {
            this.err = (Throwable)U.unmarshal((Marshaller)marsh, (byte[])this.errBytes, (ClassLoader)loader);
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByte("code", this.code)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.code = reader.readByte("code");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.id = reader.readLong("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DrInternalResponse.class);
    }

    public short directType() {
        return 122;
    }

    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return S.toString(DrInternalResponse.class, (Object)this);
    }
}

