/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.EnumMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.internal.processors.dr.DrSenderRemoteDataCenterNode;
import org.jetbrains.annotations.Nullable;

class DrSenderRemoteDataCenterNodeStateProcessor {
    private final DrSenderConfiguration cfg;
    private final IgniteLogger log;
    private DataCenterNodeState nodeState = DataCenterNodeState.NOT_CONNECTED;
    private volatile long lastReadTime;
    private int failedConnAttempts;
    private volatile long lastPingSndTime;
    private long lastHandshakeSndTime;
    private final EnumMap<DataCenterNodeState, Long> stateChangeTime = new EnumMap(DataCenterNodeState.class);
    @GridToStringExclude
    private final DrSenderRemoteDataCenterNode node;

    DrSenderRemoteDataCenterNodeStateProcessor(DrSenderConfiguration cfg, IgniteLogger log, DrSenderRemoteDataCenterNode node) {
        this.cfg = cfg;
        this.log = log;
        this.node = node;
        for (DataCenterNodeState st : DataCenterNodeState.values()) {
            this.stateChangeTime.put(st, 0L);
        }
    }

    long checkHealth() {
        long currTime = U.currentTimeMillis();
        switch (this.nodeState) {
            case CRASHED: {
                long crashReconTime = this.stateChangeTime.get((Object)DataCenterNodeState.CRASHED) + this.cfg.getReconnectOnFailureTimeout();
                if (currTime < crashReconTime) {
                    return crashReconTime;
                }
            }
            case NOT_CONNECTED: {
                this.node.connect();
                break;
            }
            case CONNECTING: {
                this.checkHealthConnecting(currTime);
                break;
            }
            case CONNECTED: {
                this.checkHealthConnected(currTime);
                break;
            }
            case PAUSED: {
                break;
            }
            default: {
                assert (false) : "Unknown state " + (Object)((Object)this.nodeState);
                break;
            }
        }
        return currTime + this.cfg.getHealthCheckFrequency();
    }

    private void checkHealthConnecting(long currTime) {
        assert (this.stateChangeTime.get((Object)DataCenterNodeState.CONNECTING) > 0L);
        if (this.lastHandshakeSndTime > 0L && currTime - this.lastHandshakeSndTime > this.cfg.getSystemRequestTimeout()) {
            if (this.log.isDebugEnabled()) {
                U.warn((IgniteLogger)this.log, (Object)("Handshake response was not obtained in a timely manner. Node will disconnect: " + this));
            }
            this.node.disconnect(false);
        }
    }

    private void checkHealthConnected(long currTime) {
        long readTimeout = this.cfg.getReadTimeout();
        long lastPingSndTime0 = this.lastPingSndTime;
        if (lastPingSndTime0 == 0L) {
            if (readTimeout != 0L && currTime - this.lastReadTime > readTimeout) {
                this.node.sendPing();
                this.lastPingSndTime = currTime;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sender hub will send ping request: " + this.node);
                }
            }
        } else if (currTime - lastPingSndTime0 > this.cfg.getSystemRequestTimeout()) {
            U.warn((IgniteLogger)this.log, (Object)("Ping response was not obtained in " + (currTime - lastPingSndTime0) + " ms. Node will disconnect: " + this.node));
            this.node.disconnect(false);
        }
    }

    public void changeState(DataCenterNodeState to) {
        DataCenterNodeState from = this.nodeState;
        this.nodeState = to;
        this.stateChangeTime.put(to, U.currentTimeMillis());
        if (this.log.isDebugEnabled()) {
            this.log.debug("DC node state transition: " + (Object)((Object)from) + " -> " + (Object)((Object)to) + ", delta = " + (this.stateChangeTime.get((Object)to) - this.stateChangeTime.get((Object)from)) + " ms.");
        }
        switch (to) {
            case CRASHED: 
            case PAUSED: {
                this.failedConnAttempts = 0;
            }
            case NOT_CONNECTED: {
                this.lastPingSndTime = 0L;
                this.lastReadTime = 0L;
                this.lastHandshakeSndTime = 0L;
                if (from != DataCenterNodeState.CONNECTED) break;
                this.log.warning("A sender hub is disconnected from a remote receiver [node=" + this.node + ']');
                break;
            }
            case CONNECTING: {
                break;
            }
            case CONNECTED: {
                this.failedConnAttempts = 0;
                this.log.info("A sender hub has successfully connected to a remote receiver [node=" + this.node + ']');
                break;
            }
            default: {
                assert (false) : "Unknown state " + (Object)((Object)to);
                break;
            }
        }
    }

    DataCenterNodeState getNodeState() {
        return this.nodeState;
    }

    void notifyHandshakeSent() {
        this.lastHandshakeSndTime = U.currentTimeMillis();
    }

    void notifyPingResponseArrived() {
        this.lastPingSndTime = 0L;
    }

    void notifyDataReceived() {
        this.lastReadTime = U.currentTimeMillis();
        this.lastPingSndTime = 0L;
    }

    void notifyDisconnect(boolean crashed) {
        if (this.nodeState == DataCenterNodeState.CONNECTING) {
            ++this.failedConnAttempts;
        }
        if (crashed || this.failedConnAttempts >= this.cfg.getMaxFailedConnectAttempts()) {
            this.changeState(DataCenterNodeState.CRASHED);
        } else {
            this.changeState(DataCenterNodeState.NOT_CONNECTED);
        }
    }

    static enum DataCenterNodeState {
        CRASHED,
        NOT_CONNECTED,
        CONNECTING,
        CONNECTED,
        PAUSED;

        private static final DataCenterNodeState[] VALS;

        @Nullable
        public static DataCenterNodeState fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = DataCenterNodeState.values();
        }
    }
}

