/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderOutCacheMetrics;
import org.gridgain.grid.internal.processors.dr.DrSenderOutCacheMetricsAdapter;

class DrSenderOutCacheMetricsAggregate
implements DrSenderOutCacheMetrics {
    private long batchesSent;
    private long entriesSent;
    private long bytesSent;
    private long batchesAcked;
    private long entriesAcked;
    private long bytesAcked;
    private long ackSndTime;

    @Override
    public int batchesSent() {
        return (int)this.batchesSent;
    }

    @Override
    public long entriesSent() {
        return this.entriesSent;
    }

    @Override
    public long bytesSent() {
        return this.bytesSent;
    }

    @Override
    public int batchesAcked() {
        return (int)this.batchesAcked;
    }

    @Override
    public long entriesAcked() {
        return this.entriesAcked;
    }

    @Override
    public long bytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public double averageBatchAckTime() {
        int acked = this.batchesAcked();
        return acked > 0 ? (double)this.ackSendTime() * 1.0 / (double)acked : 0.0;
    }

    long ackSendTime() {
        return this.ackSndTime;
    }

    void aggregate(DrSenderOutCacheMetricsAdapter m) {
        if (m != null) {
            this.batchesSent += (long)m.batchesSent();
            this.entriesSent += m.entriesSent();
            this.bytesSent += m.bytesSent();
            this.batchesAcked += (long)m.batchesAcked();
            this.entriesAcked += m.entriesAcked();
            this.bytesAcked += m.bytesAcked();
            this.ackSndTime += m.ackSendTime();
        }
    }

    public String toString() {
        return S.toString(DrSenderOutCacheMetricsAggregate.class, (Object)this);
    }
}

