/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrSenderRemoteDataCenterNodeStateProcessor;

public class DrSenderHealthCheckScheduler {
    private final BlockingQueue<DelayedTask> delayedQueue = new DelayQueue<DelayedTask>();
    private final DrProcessor proc;
    private GridWorker worker;

    DrSenderHealthCheckScheduler(DrProcessor proc) {
        assert (proc != null);
        this.proc = proc;
    }

    public void add(DrSenderRemoteDataCenterNodeStateProcessor proc) {
        this.proc.senderHub().submit(new CheckHealthDrSenderTask(this.delayedQueue, proc));
    }

    void start() {
        IgniteLogger log = this.proc.context().log(DrSenderHealthCheckScheduler.class);
        this.worker = new GridWorker(this.proc.context().grid().name(), "dr-health-checker-scheduler-worker", log){

            protected void body() throws InterruptedException {
                try {
                    while (!this.isCancelled()) {
                        DrSenderHealthCheckScheduler.this.proc.senderHub().submit(((DelayedTask)DrSenderHealthCheckScheduler.this.delayedQueue.take()).task);
                    }
                }
                finally {
                    DrSenderHealthCheckScheduler.this.delayedQueue.clear();
                }
            }
        };
        new IgniteThread(this.worker).start();
    }

    void stop() throws IgniteCheckedException {
        U.cancel((GridWorker)this.worker);
        U.join((GridWorker)this.worker);
    }

    private static class DelayedTask
    implements Delayed {
        private static final AtomicLong idGen = new AtomicLong();
        private final long id;
        private final long execTimeMs;
        private final Runnable task;

        DelayedTask(long execTimeMs, Runnable task) {
            assert (task != null);
            this.id = idGen.incrementAndGet();
            this.execTimeMs = execTimeMs;
            this.task = task;
        }

        @Override
        public final long getDelay(TimeUnit unit) {
            return unit.convert(this.execTimeMs - U.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            long delayOther;
            if (this == other) {
                return 0;
            }
            assert (other instanceof DelayedTask);
            long delayThis = this.getDelay(TimeUnit.MILLISECONDS);
            if (delayThis > (delayOther = other.getDelay(TimeUnit.MILLISECONDS))) {
                return 1;
            }
            if (delayThis < delayOther) {
                return -1;
            }
            long otherId = ((DelayedTask)other).id;
            if (this.id > otherId) {
                return 1;
            }
            if (this.id < otherId) {
                return -1;
            }
            assert (this.id != otherId);
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return (int)this.id;
        }
    }

    private static class CheckHealthDrSenderTask
    implements Runnable {
        private final BlockingQueue<DelayedTask> delayQueue;
        private final DrSenderRemoteDataCenterNodeStateProcessor stateProcessor;

        CheckHealthDrSenderTask(BlockingQueue<DelayedTask> delayQueue, DrSenderRemoteDataCenterNodeStateProcessor stateProcessor) {
            this.delayQueue = delayQueue;
            this.stateProcessor = stateProcessor;
        }

        @Override
        public void run() {
            long nextExecTime = this.stateProcessor.checkHealth();
            DelayedTask dt = new DelayedTask(nextExecTime, this);
            boolean put = this.delayQueue.offer(dt);
            assert (put);
        }
    }
}

