/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.dr.GridCacheReplicationManager;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLog;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.CachePluginContext;
import org.gridgain.grid.cache.dr.CacheDrEntryFilter;
import org.gridgain.grid.cache.dr.CacheDrMBean;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrManager;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrMetrics;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrSenderMetricsAdapter;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrStateTransferKey;
import org.gridgain.grid.internal.processors.cache.dr.GridGainCacheDrManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheIncrementalDrHandler;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheIncrementalDrMBeanAdapter;
import org.gridgain.grid.internal.processors.cache.dr.ist.CachePartitionStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheSenderHubManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheStateTransferHandler;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrCollectDrLwmCountersJob;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrCollectReservedCountersJob;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrControlTask;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateHolder;
import org.gridgain.grid.internal.processors.cache.dr.ist.PartitionCounterInfo;
import org.gridgain.grid.internal.processors.cache.dr.ist.StateTransferInfo;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedDrStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.DistributedStateTransferManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.MetastoreDrStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.distributed.SysCacheDrStateManager;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class GridGainCacheIncrementalDrManager
extends GridCacheManagerAdapter
implements CacheDrManager,
GridCacheReplicationManager,
PartitionsExchangeAware {
    private final byte dataCenterId;
    private final GridGainConfiguration ggCfg;
    private final GridGainCacheConfiguration ggCcfg;
    private final DrProcessor drProc;
    private final GridFutureAdapter<Object> initFut = new GridFutureAdapter();
    private final DiscoveryListener discoLsnr = new DiscoveryListener();
    private final GridBusyLock busyLock = new GridBusyLock();
    private CachePartitionStateManager partStateMgr;
    private CacheSenderHubManager sndHubMgr;
    private boolean sndEnabled;
    private CacheIncrementalDrHandler drHnd;
    private CacheStateTransferHandler stateTransferHnd;
    private DistributedStateTransferManager distrStateMgr;
    private DrStateHolder drState;
    private ObjectName cacheMBean;
    private DrControlTaskExecutor ctrlTaskExec;
    protected volatile CacheDrMetrics metrics;
    private CacheDrEntryFilter entryFilter;
    private static final String FULL_STATE_RECOMENDATION = "Entry tombstone was cleaned up. Full state transfer is recommended.";

    public GridGainCacheIncrementalDrManager(CachePluginContext<GridGainCacheConfiguration> ggCctx, DrProcessor drProc) {
        this.ggCfg = GridPluginUtils.gridPluginConfiguration(ggCctx.grid().configuration());
        if (this.ggCfg == null) {
            throw new IllegalStateException("GridGain plugin configuration was not found. GridGain plugin has to be configured if DR feature is used.");
        }
        this.dataCenterId = this.ggCfg.getDataCenterId();
        assert (this.dataCenterId > 0) : "DR is not configured for cache.";
        assert (DrUtils.isIncrementalDrEnabled()) : "Incremental state transfer feature is disabled.";
        assert (!CU.isSystemCache((String)ggCctx.igniteCacheConfiguration().getName())) : "DR is forbidden for system cache: " + ggCctx.igniteCacheConfiguration().getName();
        this.ggCcfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ggCctx.igniteCacheConfiguration(), GridGainCacheConfiguration.class);
        this.drProc = drProc;
    }

    public byte dataCenterId() {
        return this.dataCenterId;
    }

    public void replicate(KeyCacheObject key, @Nullable CacheObject val, long ttl, long expireTime, GridCacheVersion ver, GridDrType drType, AffinityTopologyVersion topVer) {
        switch (drType) {
            case DR_PRIMARY: 
            case DR_LOAD: {
                long cntr = ver.updateCounter();
                assert (cntr > 0L) : "Invalid update counter [cntr=" + cntr + ']';
                this.updateCounter(key.partition(), cntr);
                break;
            }
            case DR_BACKUP: 
            case DR_PRELOAD: 
            case DR_NONE: {
                return;
            }
        }
    }

    public void updateCounter(int part, long cntr) {
        if (this.partStateMgr.updateCounter(part, cntr)) {
            this.drHnd.onPartitionCounterChanged(part);
        }
    }

    public void updateCounter(int part, long cntr, long delta) {
        if (this.partStateMgr.updateCounter(part, cntr, delta)) {
            this.drHnd.onPartitionCounterChanged(part);
        }
    }

    public long lwmOrDefault(int part, long defVal) {
        return this.partStateMgr.lwmOrDefault(part, defVal);
    }

    public void onExchange(AffinityTopologyVersion topVer, boolean left) {
    }

    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (this.cctx.kernalContext().isStopping() || fut.exchangeActions() != null && fut.exchangeActions().cacheGroupStopping(this.cctx.groupId()) || !fut.changedAffinity()) {
            return;
        }
        this.onAssignmentChanged(fut.topologyVersion());
    }

    public boolean enabled() {
        return this.sndEnabled;
    }

    public boolean receiveEnabled() {
        return this.ggCcfg != null;
    }

    public void partitionEvicted(int part) {
        this.partStateMgr.onPartitionEvicted(part);
    }

    public void onReceiveCacheEntriesReceived(int entriesCnt) {
        this.metrics.onReceiveCacheEntriesReceived(entriesCnt);
    }

    public void onReceiveCacheConflictResolved(boolean useNew, boolean useOld, boolean merge) {
        this.metrics.onReceiveCacheConflictResolved(useNew, useOld, merge);
    }

    public void resetMetrics() {
        boolean isDrSndCache = this.ggCcfg != null && this.ggCcfg.getDrSenderConfiguration() != null;
        boolean isDrRcvCache = this.ggCcfg != null;
        this.metrics = new CacheDrMetrics(isDrSndCache, isDrRcvCache);
        if (!this.cctx.isColocated() && this.cctx.dht().near() != null) {
            this.metrics.delegate(((CacheDrManager)this.cctx.dht().near().context().dr()).metrics());
        }
    }

    public void start0() throws IgniteCheckedException {
        CacheDrSenderConfiguration sndCfg = this.ggCcfg != null ? this.ggCcfg.getDrSenderConfiguration() : null;
        this.sndEnabled = sndCfg != null && !this.cctx.isNear();
        boolean isDrSndCache = sndCfg != null;
        boolean isDrRcvCache = this.ggCcfg != null;
        this.metrics = new CacheDrMetrics(isDrSndCache, isDrRcvCache);
        if (!this.sndEnabled) {
            return;
        }
        this.ctrlTaskExec = new DrControlTaskExecutor();
        this.distrStateMgr = this.createDistrStateMgr(sndCfg);
        assert (this.distrStateMgr instanceof DistributedDrStateManager);
        this.drState = new DrStateHolder((DistributedDrStateManager)((Object)this.distrStateMgr));
        long bufSize = (long)this.ggCcfg.getDrSenderConfiguration().getMaxBatches() * (long)Math.max(this.ggCfg.getBatchSendSizeBytes(), this.ggCfg.getStateTransferBatchSendSizeBytes());
        this.sndHubMgr = new CacheSenderHubManager(this.cctx, this.ggCfg, sndCfg, this.drProc, this::metrics0, bufSize);
        if (this.cctx.affinityNode()) {
            this.sndHubMgr.startServingRequests();
            this.cctx.shared().exchange().registerExchangeAwareComponent((PartitionsExchangeAware)this);
            this.partStateMgr = new CachePartitionStateManager(this.cctx, sndCfg, this.drProc, this.busyLock);
            this.entryFilter = sndCfg.getEntryFilter();
            this.injectResources(this.entryFilter);
            U.startLifecycleAware(Collections.singleton(this.entryFilter));
            this.drHnd = new CacheIncrementalDrHandler(this.cctx, this.log, this.partStateMgr, this.sndHubMgr, this.drState, this.busyLock, this.entryFilter, this.ggCcfg.getDrSenderConfiguration().getBatchSendSize(), this.ggCfg.getBatchSendSizeBytes(), this.ggCcfg.getDrSenderConfiguration().getBatchSendFrequency(), this.drProc::submit, this::metrics0);
            this.stateTransferHnd = new CacheStateTransferHandler(this.cctx, this.partStateMgr, this.sndHubMgr, this.distrStateMgr, this.ggCfg.getStateTransferBatchSendSizeBytes(), this.entryFilter, this.drProc::submitStateTransferTask, this::metrics0);
            this.drState.subscribe(this.drHnd, this.stateTransferHnd);
            this.registerMBean();
        }
        this.cctx.kernalContext().event().addDiscoveryEventListener((DiscoveryEventListener)this.discoLsnr, 10, new int[]{12, 11});
    }

    private void injectResources(@Nullable Object component) throws IgniteCheckedException {
        if (component == null) {
            return;
        }
        this.cctx.kernalContext().resource().injectGeneric(component);
        this.cctx.kernalContext().resource().injectCacheName(component, this.cctx.config().getName());
    }

    private DistributedStateTransferManager createDistrStateMgr(CacheDrSenderConfiguration sndCfg) {
        return Boolean.getBoolean("GG_DR_USE_METASTORE") ? new MetastoreDrStateManager(this.cctx, this.ctrlTaskExec, this.drProc::submit) : new SysCacheDrStateManager(this.cctx, this.ctrlTaskExec, this.ggCfg.isDrUseCacheNames() ? new GridGainCacheDrManager.DrEntryEventFilter(this.cctx.name()) : new GridGainCacheDrManager.DrGroupControlEventFilter(DrUtils.effectiveSenderGroup(sndCfg), this.cctx.config().getName()), this.drProc::submit);
    }

    public void onKernalStart0() throws IgniteCheckedException {
        if (!this.sndEnabled) {
            return;
        }
        if (this.cctx.affinityNode()) {
            this.partStateMgr.start();
        }
        this.distrStateMgr.start();
        this.initDr();
    }

    private void initDr() {
        GridCachePartitionExchangeManager exch = this.cctx.shared().exchange();
        GridDhtPartitionsExchangeFuture topFuture = exch.lastTopologyFuture();
        assert (topFuture != null) : "DR Worker should start after join to topology (last exchange future is null)";
        IgniteInternalFuture affinityReadyFuture = exch.affinityReadyFuture(topFuture.initialVersion());
        affinityReadyFuture.chainCompose((IgniteClosure & Serializable)ignore -> this.cctx.kernalContext().cache().utilityCache().context().preloader().syncFuture()).listen((IgniteInClosure & Serializable)f -> {
            try {
                f.get();
                boolean hasSenders = false;
                for (ClusterNode node : this.cctx.kernalContext().discovery().allNodes()) {
                    if (!this.sndHubMgr.isSenderNode(node)) continue;
                    this.submitControlTask(new SenderHubStartTask(node));
                    hasSenders = true;
                }
                if (hasSenders) {
                    this.ctrlTaskExec.accept(() -> this.initFut.onDone());
                } else {
                    this.initFut.onDone();
                }
                this.drProc.submit(this.ctrlTaskExec);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Data center replication manager initialized: cache=" + this.cctx.name());
                }
            }
            catch (NodeStoppingException e) {
                this.initFut.onDone((Throwable)e);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Failed to wait for initial affinity due to node stopped: cache=" + this.cctx.name());
                }
            }
            catch (IgniteClientDisconnectedCheckedException e) {
                this.initFut.onDone((Throwable)e);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to wait for initial affinity due to client disconnect: ");
                }
            }
            catch (Throwable e) {
                this.initFut.onDone(e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new IgniteException("Failed to wait for affinity ready future [topVer=" + topFuture.initialVersion() + "]", e);
            }
        });
    }

    private void awaitDrInitialization() throws IgniteCheckedException {
        this.initFut.get();
    }

    public void syncDrState() throws IgniteCheckedException {
        if (!this.sndEnabled) {
            throw new IllegalStateException("Can't sync DR state for non-DR cache: " + this.cctx.name());
        }
        if (!this.cctx.affinityNode()) {
            throw new IllegalStateException("Sync DR state called on non-affinity node.");
        }
        this.awaitDrInitialization();
        this.partStateMgr.sendStateToBackups();
    }

    private void onAssignmentChanged(AffinityTopologyVersion affTopVer) {
        if (affTopVer == null) {
            return;
        }
        AffinityAssignment assignment = this.cctx.affinity().assignment(affTopVer);
        UUID localNodeId = this.cctx.localNodeId();
        Set primaryParts = assignment.primaryPartitions(localNodeId);
        Set backupParts = assignment.backupPartitions(localNodeId);
        this.partStateMgr.onPartitionAssignment(primaryParts, backupParts);
        this.drHnd.onPartitionAssignment(primaryParts, backupParts);
        this.stateTransferHnd.onPartitionAssignment(primaryParts);
    }

    public void onKernalStop0(boolean cancel) {
        this.initFut.onDone((Throwable)new CacheStoppedException("Failed to wait DR initialization for cache. Cache was stopped."));
        this.unregisterMBean();
        if (this.ctrlTaskExec != null) {
            this.ctrlTaskExec.stop();
        }
        if (this.distrStateMgr != null) {
            this.distrStateMgr.stop();
        }
        if (this.stateTransferHnd != null) {
            this.stateTransferHnd.stop();
        }
        if (this.drHnd != null) {
            this.drHnd.stop();
        }
        if (this.sndHubMgr != null) {
            this.sndHubMgr.stopServingRequests();
        }
        this.busyLock.block();
        if (this.partStateMgr != null) {
            this.partStateMgr.stop();
        }
    }

    public void stop0(boolean cancel, boolean destroy) {
        if (this.cctx != null) {
            this.cctx.kernalContext().event().removeDiscoveryEventListener((DiscoveryEventListener)this.discoLsnr, new int[0]);
        }
        if (this.entryFilter != null) {
            U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.entryFilter));
        }
        if (destroy) {
            if (this.partStateMgr != null) {
                this.partStateMgr.onCacheDestroy();
            }
            if (this.distrStateMgr != null) {
                this.distrStateMgr.destroyState(this.cctx.name());
            }
        }
        this.cctx.shared().exchange().unregisterExchangeAwareComponent((PartitionsExchangeAware)this);
    }

    @Override
    public CacheDrMetrics metrics() {
        CacheDrMetrics metrics = CacheDrMetrics.copyOf(this.metrics);
        if (!this.sndEnabled || metrics == null) {
            return metrics;
        }
        CacheDrStatus status = this.drState.drStatus();
        metrics.onStopStateChanged(status.reason(), status.error());
        if (!this.cctx.affinityNode()) {
            return metrics;
        }
        CacheDrSenderMetricsAdapter drSndMetrics = metrics.drSendMetrics0();
        if (drSndMetrics == null) {
            return metrics;
        }
        long backupQueueSize = 0L;
        long pendingQueueSize = 0L;
        try {
            AffinityTopologyVersion topVer = this.cctx.topology().readyTopologyVersion();
            Set primaryParts = this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer);
            Set backupParts = this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
            for (GridDhtLocalPartition part : this.cctx.topology().localPartitions()) {
                UpdateLog updateLog;
                if (part == null || (updateLog = part.dataStore().logTree()) == null || !updateLog.hasTree()) continue;
                if (primaryParts.contains(part.id())) {
                    pendingQueueSize += updateLog.tree().size();
                    continue;
                }
                if (!backupParts.contains(part.id())) continue;
                backupQueueSize += updateLog.tree().size();
            }
            drSndMetrics.pendingQueueSize(pendingQueueSize);
            drSndMetrics.backupQueueSize(backupQueueSize);
        }
        catch (IgniteCheckedException ex) {
            throw new IllegalStateException(ex);
        }
        return metrics;
    }

    CacheDrMetrics metrics0() {
        return this.metrics;
    }

    @Override
    public CacheDrStatus drStatus() {
        if (this.cctx.isNear()) {
            return ((GridGainCacheIncrementalDrManager)this.cctx.near().dht().context().dr()).drStatus();
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            return this.drState.drStatus();
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void startReplication() {
        if (this.cctx.isNear()) {
            ((CacheDrManager)this.cctx.near().dht().context().dr()).startReplication();
            return;
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            this.drState.startReplication().get();
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void stopReplication() {
        if (this.cctx.isNear()) {
            ((CacheDrManager)this.cctx.near().dht().context().dr()).stopReplication();
            return;
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            this.drState.stopReplication().get();
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<CacheDrStateTransfer> activeStateTransferTasks() {
        if (this.cctx.isNear()) {
            return ((CacheDrManager)this.cctx.near().dht().context().dr()).activeStateTransferTasks();
        }
        this.checkDrEnabled();
        List<StateTransferInfo> transferInfos = this.distrStateMgr.activeStateTransfers();
        return transferInfos.stream().map(info -> new CacheDrStateTransfer(info.fstId(), info.targetDCs(), this.cctx.name(), info.nodeInitiator(), info.startTime(), true, this.cctx.affinity().partitions() - info.partsToTransfer())).collect(Collectors.toList());
    }

    public IgniteInternalFuture<?> startStateTransfer(Collection<Byte> targetDCs, boolean sync) {
        if (this.cctx.isNear()) {
            return ((CacheDrManager)this.cctx.near().dht().context().dr()).startStateTransfer(targetDCs, sync);
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            return (IgniteInternalFuture)this.distrStateMgr.startStateTransfer(targetDCs).get();
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException("Failed to initiate state transfer.", e);
        }
    }

    public IgniteInternalFuture<?> stopStateTransfer(CacheDrStateTransferKey fstKey) {
        if (this.cctx.isNear()) {
            return ((CacheDrManager)this.cctx.near().dht().context().dr()).stopStateTransfer(fstKey);
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            return this.distrStateMgr.stopStateTransfer(fstKey, null);
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException("Failed to stop state transfer.", e);
        }
    }

    public IgniteInternalFuture<?> incrementalStateTransfer(long snapshotId, byte datacenterId) {
        if (this.cctx.isNear()) {
            return ((CacheDrManager)this.cctx.near().dht().context().dr()).incrementalStateTransfer(snapshotId, datacenterId);
        }
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            return (IgniteInternalFuture)this.distrStateMgr.incrementalStateTransfer(snapshotId, Collections.singleton(datacenterId)).get();
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException("Failed to initiate incremental state transfer.", e);
        }
    }

    public IgniteInternalFuture<?> flush() {
        this.checkDrEnabled();
        try {
            this.awaitDrInitialization();
            GridFutureAdapter fut = new GridFutureAdapter();
            this.drProc.submit(new DrFlushTask(fut));
            return fut;
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException("Failed to flush DR updates.", e);
        }
    }

    @Override
    public void onBatchFailed(Map<UUID, Throwable> err) {
        assert (!F.isEmpty(err));
        this.drState.fail();
    }

    private void registerMBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            this.cacheMBean = U.registerMBean((MBeanServer)this.cctx.gridConfig().getMBeanServer(), (String)this.cctx.igniteInstanceName(), (String)this.cctx.name(), (String)"Cache data replication", (Object)new CacheIncrementalDrMBeanAdapter(this, this.sndHubMgr, this.ggCfg, this.ggCcfg), CacheDrMBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered cache MBean: " + this.cacheMBean);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to register cache MBean.", (Throwable)e);
        }
    }

    private void unregisterMBean() {
        if (this.cacheMBean == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.cctx.gridConfig().getMBeanServer().unregisterMBean(this.cacheMBean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered cache MBean: " + this.cacheMBean);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to unregister cache MBean: " + this.cacheMBean), (Throwable)e);
        }
    }

    private void checkDrEnabled() {
        if (!this.enabled()) {
            throw new IllegalStateException("Data center replication is not configured for cache: " + this.cctx.name());
        }
    }

    public void onTombstoneCleaned(int part, long updCnt) {
        long lwm = this.partStateMgr.lwmOrDefault(part, 0L);
        if (lwm < updCnt) {
            LT.warn((IgniteLogger)this.log, (String)FULL_STATE_RECOMENDATION);
        }
    }

    private void submitControlTask(DrControlTask task) {
        this.ctrlTaskExec.accept(task);
    }

    private class DrFlushTask
    implements Runnable {
        private final GridFutureAdapter<?> fut;

        public DrFlushTask(GridFutureAdapter<?> fut) {
            this.fut = fut;
        }

        @Override
        public void run() {
            try {
                IgniteEx grid = GridGainCacheIncrementalDrManager.this.cctx.kernalContext().grid();
                ClusterGroup clusterGroup = grid.cluster().forCacheNodes(GridGainCacheIncrementalDrManager.this.cctx.name());
                Collection<PartitionCounterInfo> reservedCntrs = ((Collection)grid.compute(clusterGroup).broadcastAsync((IgniteCallable)new DrCollectReservedCountersJob(GridGainCacheIncrementalDrManager.this.cctx.name())).get()).stream().flatMap(Collection::stream).collect(Collectors.toMap(PartitionCounterInfo::partitionId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(PartitionCounterInfo::counter)))).values();
                while (!this.fut.isDone()) {
                    clusterGroup = grid.cluster().forCacheNodes(GridGainCacheIncrementalDrManager.this.cctx.name());
                    Map<Integer, Long> drLwmCntrs = ((Collection)grid.compute(clusterGroup).broadcastAsync((IgniteCallable)new DrCollectDrLwmCountersJob(GridGainCacheIncrementalDrManager.this.cctx.name())).get()).stream().flatMap(Collection::stream).collect(Collectors.toMap(PartitionCounterInfo::partitionId, PartitionCounterInfo::counter, BinaryOperator.maxBy(Comparator.comparing(Function.identity()))));
                    boolean done = reservedCntrs.stream().allMatch(part -> drLwmCntrs.containsKey(part.partitionId()) && (Long)drLwmCntrs.get(part.partitionId()) >= part.counter());
                    if (done) {
                        this.fut.onDone();
                        continue;
                    }
                    U.sleep((long)1000L);
                }
            }
            catch (Exception e) {
                this.fut.onDone((Throwable)e);
            }
        }
    }

    private class SenderHubStopTask
    implements DrControlTask {
        private final ClusterNode sndHubNode;

        private SenderHubStopTask(ClusterNode sndHubNode) {
            this.sndHubNode = sndHubNode;
        }

        @Override
        public void run() throws Exception {
            boolean noHubs = GridGainCacheIncrementalDrManager.this.sndHubMgr.unregisterSender(this.sndHubNode.id());
            if (noHubs) {
                GridGainCacheIncrementalDrManager.this.drState.onNoSenderHubs();
            }
        }
    }

    private class SenderHubStartTask
    implements DrControlTask {
        private final ClusterNode sndHubNode;

        private SenderHubStartTask(ClusterNode sndHubNode) {
            this.sndHubNode = sndHubNode;
        }

        @Override
        public void run() throws Exception {
            GridGainCacheIncrementalDrManager.this.sndHubMgr.registerSender(this.sndHubNode);
            GridGainCacheIncrementalDrManager.this.drState.onSenderHubJoin();
        }
    }

    private class DrControlTaskExecutor
    implements Runnable,
    Consumer<DrControlTask> {
        private final BlockingQueue<DrControlTask> tasksQ = new LinkedBlockingDeque<DrControlTask>();
        private boolean hasTasks;
        private volatile TaskExecutorState state = TaskExecutorState.NOT_INITIALIZED;
        private volatile Thread thread;

        private DrControlTaskExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.isCancelled()) {
                return;
            }
            if (this.state == TaskExecutorState.NOT_INITIALIZED) {
                try {
                    if (!GridGainCacheIncrementalDrManager.this.distrStateMgr.init()) {
                        return;
                    }
                    DrControlTaskExecutor drControlTaskExecutor = this;
                    synchronized (drControlTaskExecutor) {
                        if (this.state == TaskExecutorState.NOT_INITIALIZED) {
                            this.state = TaskExecutorState.STARTED;
                            if (!this.hasTasks) {
                                return;
                            }
                        }
                    }
                }
                catch (IgniteCheckedException ex) {
                    GridGainCacheIncrementalDrManager.this.initFut.onDone((Throwable)ex);
                    return;
                }
            }
            this.thread = Thread.currentThread();
            try {
                while (!this.isCancelled()) {
                    DrControlTask task;
                    while ((task = (DrControlTask)this.tasksQ.poll()) != null) {
                        this.processDrTask(task);
                    }
                    DrControlTaskExecutor drControlTaskExecutor = this;
                    synchronized (drControlTaskExecutor) {
                        if (this.tasksQ.isEmpty()) {
                            this.hasTasks = false;
                            return;
                        }
                    }
                }
                return;
            }
            finally {
                DrControlTaskExecutor drControlTaskExecutor = this;
                synchronized (drControlTaskExecutor) {
                    this.thread = null;
                }
            }
        }

        @Override
        public synchronized void accept(DrControlTask drTask) {
            if (this.isCancelled()) {
                drTask.onError((Throwable)new CacheStoppedException("Dr task is cancelled due to cache stop: task=" + drTask + ", cache=" + GridGainCacheIncrementalDrManager.this.cctx.name()));
                return;
            }
            this.tasksQ.offer(drTask);
            if (!this.hasTasks) {
                this.hasTasks = true;
                if (this.state == TaskExecutorState.STARTED) {
                    GridGainCacheIncrementalDrManager.this.drProc.submit(this);
                }
            }
        }

        private boolean isCancelled() {
            return this.state == TaskExecutorState.CANCELLED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            DrControlTaskExecutor drControlTaskExecutor = this;
            synchronized (drControlTaskExecutor) {
                this.state = TaskExecutorState.CANCELLED;
                Thread thread0 = this.thread;
                if (thread0 != null) {
                    thread0.interrupt();
                }
            }
            IgniteCheckedException reason = new IgniteCheckedException("Failed to perform DR task because grid is stopping.");
            this.tasksQ.forEach(t -> t.onError(reason));
            this.tasksQ.clear();
        }

        private void processDrTask(DrControlTask task) {
            if (!GridGainCacheIncrementalDrManager.this.busyLock.enterBusy()) {
                task.onError((Throwable)new CacheStoppedException("Dr task is cancelled due to cache stop: task=" + task + ", cache=" + GridGainCacheIncrementalDrManager.this.cctx.name()));
                return;
            }
            try {
                task.run();
            }
            catch (Throwable e) {
                if (!this.isCancelled() && !GridGainCacheIncrementalDrManager.this.cctx.topology().stopping()) {
                    U.error((IgniteLogger)GridGainCacheIncrementalDrManager.this.log, (Object)"An exception occurred during DR task processing.", (Throwable)e);
                } else if (GridGainCacheIncrementalDrManager.this.log.isDebugEnabled()) {
                    GridGainCacheIncrementalDrManager.this.log.debug("An exception occurred during DR task processing: " + e);
                }
                task.onError(e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
            finally {
                GridGainCacheIncrementalDrManager.this.busyLock.leaveBusy();
            }
        }

        public String toString() {
            return "DrControlTaskExecutor{hasTasks=" + this.hasTasks + ", state=" + (Object)((Object)this.state) + '}';
        }
    }

    private static enum TaskExecutorState {
        NOT_INITIALIZED,
        STARTED,
        CANCELLED;

    }

    private class DiscoveryListener
    implements DiscoveryEventListener {
        private DiscoveryListener() {
        }

        public void onEvent(DiscoveryEvent evt, DiscoCache discoCache) {
            ClusterNode node = evt.eventNode();
            boolean isSndHub = GridGainCacheIncrementalDrManager.this.sndHubMgr.isSenderNode(node);
            switch (evt.type()) {
                case 11: 
                case 12: {
                    if (!isSndHub) break;
                    GridGainCacheIncrementalDrManager.this.submitControlTask(new SenderHubStopTask(node));
                    break;
                }
                case 10: {
                    if (!isSndHub || !GridGainCacheIncrementalDrManager.this.cctx.discovery().alive(node)) break;
                    GridGainCacheIncrementalDrManager.this.submitControlTask(new SenderHubStartTask(node));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }
}

