/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrMetrics;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrResultType;
import org.gridgain.grid.internal.processors.cache.dr.EntryBuffer;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatchStateListener;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrSenderNode;
import org.gridgain.grid.internal.processors.cache.dr.ist.LoadBalancer;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrSenderAttributes;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequestEntry;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalResponse;
import org.jetbrains.annotations.Nullable;

class CacheSenderHubManager {
    private static final AtomicLong ID_GEN = new AtomicLong();
    private final GridGainConfiguration ggCfg;
    private final CacheDrSenderConfiguration sndCfg;
    private final DrSenderNode locSnd;
    private final IgniteLogger log;
    private final GridCacheContext<?, ?> cctx;
    private final GridIoManager ioMgr;
    private final DrProcessor drProc;
    private final ConcurrentMap<UUID, DrSenderNode> sndNodes = new ConcurrentHashMap<UUID, DrSenderNode>();
    private final LoadBalancer<DrSenderNode> loadBalancer;
    private final ConcurrentMap<Long, BatchRequest> reqMap = new ConcurrentHashMap<Long, BatchRequest>();
    private final Object topic;
    private final Supplier<CacheDrMetrics> metrics;
    private final GridBusyLock busyLock;
    private final Permit permits;
    private final Queue<Long> reqIdsToResend = new LinkedBlockingQueue<Long>();
    private final AtomicBoolean resendScheduled = new AtomicBoolean();
    private volatile BitSet ignoredDcs = new BitSet();
    private volatile boolean stopping;

    CacheSenderHubManager(GridCacheContext cctx, GridGainConfiguration ggCfg, CacheDrSenderConfiguration sndCfg, DrProcessor drProc, Supplier<CacheDrMetrics> metrics, long bufSize) {
        Objects.nonNull(cctx);
        Objects.nonNull(ggCfg);
        Objects.nonNull(sndCfg);
        this.cctx = cctx;
        this.ggCfg = ggCfg;
        this.sndCfg = sndCfg;
        this.drProc = drProc;
        this.metrics = metrics;
        this.log = cctx.logger(CacheSenderHubManager.class);
        this.ioMgr = cctx.gridIO();
        this.topic = CU.replicationTopicReceive((String)cctx.name());
        this.permits = new Permit(bufSize);
        this.busyLock = new GridBusyLock();
        this.locSnd = this.hasLocalSender(cctx, sndCfg) && sndCfg.isPreferLocalSender() ? this.fromClusterNodeId(cctx.localNodeId()) : null;
        this.loadBalancer = sndCfg.getLoadBalancingMode() == DrSenderLoadBalancingMode.DR_ROUND_ROBIN ? new LoadBalancer.RoundRobinBalancer() : new LoadBalancer.RandomBalancer();
    }

    private boolean hasLocalSender(GridCacheContext cctx, CacheDrSenderConfiguration sndCfg) {
        DrSenderConfiguration sndHubCfg = this.ggCfg.getDrSenderConfiguration();
        if (sndHubCfg == null) {
            return false;
        }
        if (this.ggCfg.isDrUseCacheNames()) {
            assert (!F.isEmpty((Object[])sndHubCfg.getCacheNames()));
            return Arrays.stream(sndHubCfg.getCacheNames()).anyMatch(s -> s.equals(cctx.name()));
        }
        assert (F.isEmpty((Object[])sndHubCfg.getCacheNames())) : "cache names are not allowed.";
        String sndGrp = DrUtils.effectiveSenderGroup(sndCfg);
        return Arrays.asList(DrUtils.effectiveSenderGroups(sndHubCfg)).contains(sndGrp);
    }

    public boolean shouldIgnoreDc(byte dcId) {
        return this.ignoredDcs.get(dcId);
    }

    public boolean isSenderNode(ClusterNode node) {
        if (node.attribute("plugins.gg.replication.ist.snd.hub") == null) {
            return false;
        }
        if (this.ggCfg.isDrUseCacheNames()) {
            DrSenderAttributes attr = (DrSenderAttributes)node.attribute("plugins.gg.replication.ist.snd.hub");
            String cacheName = CU.mask((String)this.cctx.name());
            return attr != null && attr.getCacheNames().stream().anyMatch(s -> s.equals(cacheName));
        }
        Object[] sndGroups = (String[])node.attribute("plugins.gg.replication.ist.snd.groups");
        if (F.isEmpty((Object[])sndGroups)) {
            return false;
        }
        String sndGrp = DrUtils.effectiveSenderGroup(this.sndCfg);
        return Arrays.asList(sndGroups).contains(sndGrp);
    }

    @Nullable
    private DrSenderNode nextSender() {
        if (this.locSnd != null) {
            return this.locSnd.active() ? this.locSnd : null;
        }
        List sndNodes = this.sndNodes.values().stream().filter(DrSenderNode::active).collect(Collectors.toList());
        if (sndNodes.isEmpty()) {
            return null;
        }
        return this.loadBalancer.apply(sndNodes);
    }

    public void startServingRequests() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start DR batch manager: cache=" + this.cctx.name());
        }
        this.ioMgr.addMessageListener(this.topic, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof DrInternalResponse) {
                    if (CacheSenderHubManager.this.log.isTraceEnabled()) {
                        CacheSenderHubManager.this.log.trace("Received internal replication response message [sourceNodeId=" + nodeId + ", msg=" + msg + ']');
                    }
                    if (!CacheSenderHubManager.this.busyLock.enterBusy()) {
                        return;
                    }
                    DrInternalResponse msg0 = (DrInternalResponse)msg;
                    try {
                        msg0.finishUnmarshal(CacheSenderHubManager.this.cctx.marshaller(), U.resolveClassLoader((IgniteConfiguration)CacheSenderHubManager.this.cctx.gridConfig()));
                        CacheSenderHubManager.this.onResponse(nodeId, msg0);
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        U.error((IgniteLogger)CacheSenderHubManager.this.log, (Object)("Failed to unmarshal message (will ignore): " + msg), (Throwable)e);
                        BatchRequest batchReq = (BatchRequest)CacheSenderHubManager.this.reqMap.get(msg0.id());
                        if (batchReq == null) return;
                        batchReq.complete(CacheDrResultType.FAILED, e);
                        return;
                    }
                    finally {
                        CacheSenderHubManager.this.busyLock.leaveBusy();
                    }
                } else {
                    assert (false) : "Unexpected message type: " + msg;
                    return;
                }
            }
        });
    }

    public void send(Map<Byte, EntryBuffer> buffers, DrBatchStateListener lsnr) {
        this.send(buffers, lsnr, DrUtils.FAKE_FST_ID, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<Byte, EntryBuffer> buffers, DrBatchStateListener lsnr, IgniteUuid fstId, Collection<Byte> targetDCs) {
        BatchRequest req = new BatchRequest(this.createInternalRequest(buffers, targetDCs, fstId), lsnr);
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            do {
                this.resend0();
                if (!this.acquirePermit(req.size(), 100L)) continue;
                BatchRequest old = this.reqMap.put(req.id(), req);
                assert (old == null);
                if (!this.send(req.req)) {
                    this.scheduleResend();
                }
                break;
            } while (!this.stopping);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void resend() {
        if (this.reqIdsToResend.isEmpty() || !this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (!this.resend0()) {
                this.scheduleResend();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private boolean resend0() {
        Long reqId;
        while (!this.stopping && (reqId = this.reqIdsToResend.poll()) != null) {
            BatchRequest req = (BatchRequest)this.reqMap.get(reqId);
            if (req == null) continue;
            DrInternalRequest req0 = req.req;
            if (req0 == null) {
                req.complete(CacheDrResultType.IGNORED, null);
                continue;
            }
            if (this.sndNodes.isEmpty()) {
                req.complete(CacheDrResultType.IGNORED, null);
                continue;
            }
            if (this.send(req0)) continue;
            return false;
        }
        return true;
    }

    private void scheduleResend() {
        if (this.resendScheduled.compareAndSet(false, true)) {
            this.cctx.time().schedule(() -> this.drProc.submit(() -> {
                if (this.resendScheduled.compareAndSet(true, false)) {
                    this.resend();
                }
            }), 100L, -1L);
        }
    }

    private boolean send(DrInternalRequest req) {
        DrSenderNode node = this.nextSender();
        if (node == null) {
            this.reqIdsToResend.add(req.id());
            return false;
        }
        try {
            node.send(req);
            this.metrics.get().onSenderCacheBatchSent(req.entryCount());
        }
        catch (IgniteCheckedException e) {
            this.log.info("Unable to sent request to sender: reqId=" + req.id() + ", nodeId=" + node.id() + ", err=" + (Object)((Object)e));
            node.temporarilySwitchOff();
            this.reqIdsToResend.add(req.id());
            return false;
        }
        return true;
    }

    private synchronized boolean acquirePermit(int size, long millis) {
        if (this.permits.acquire(size)) {
            return true;
        }
        try {
            long start = U.currentTimeMillis();
            this.wait(millis);
            long now = U.currentTimeMillis();
            long waitDuration = now - start;
            if (waitDuration > 0L) {
                this.metrics.get().onFstThrottling(waitDuration);
            }
            return this.permits.acquire(size);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
    }

    private synchronized void releasePermit(int size) {
        this.permits.release(size);
        this.notifyAll();
    }

    boolean registerSender(ClusterNode sndNode) {
        DrSenderNode node;
        sndNode = this.cctx.discovery().node(sndNode.id());
        if (sndNode == null) {
            return false;
        }
        assert (this.isSenderNode(sndNode));
        DrSenderNode drSenderNode = node = this.locSnd != null && sndNode.id().equals(this.locSnd.id()) ? this.locSnd : this.fromClusterNodeId(sndNode.id());
        if (this.sndNodes.isEmpty()) {
            BitSet ignoredDcs = new BitSet();
            DrSenderAttributes attr = (DrSenderAttributes)sndNode.attribute("plugins.gg.replication.ist.snd.hub");
            attr.getIgnoreList().forEach(ignoredDcs::set);
            this.ignoredDcs = ignoredDcs;
        }
        if (this.sndNodes.putIfAbsent(node.id(), node) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("New sender registered: cache=" + this.cctx.name() + ", sndHubNode=" + sndNode.id());
            }
            return true;
        }
        return false;
    }

    private DrSenderNode fromClusterNodeId(UUID nodeId) {
        return new DrSenderNode(this.ioMgr, this.cctx.time(), nodeId);
    }

    boolean unregisterSender(UUID sndNodeId) {
        DrSenderNode node = (DrSenderNode)this.sndNodes.remove(sndNodeId);
        if (node != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sender unregistered: cache=" + this.cctx.name() + ", sndHubNode=" + sndNodeId);
            }
            for (Long reqId : node.unprocessedRequests()) {
                BatchRequest req = (BatchRequest)this.reqMap.get(reqId);
                if (req == null) continue;
                req.complete(CacheDrResultType.IGNORED, null);
            }
        }
        return this.sndNodes.isEmpty();
    }

    public int sendersCnt() {
        return this.sndNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuedKeysCount() {
        if (!this.busyLock.enterBusy()) {
            return 0;
        }
        try {
            int cnt = 0;
            for (BatchRequest req : this.reqMap.values()) {
                cnt += req.entriesCount();
            }
            int n = cnt;
            return n;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public int batchWaitingAcknowledgeCount() {
        return this.reqMap.size();
    }

    private void onResponse(UUID respondedNodeId, DrInternalResponse resp) {
        assert (resp != null);
        BatchRequest batchReq = (BatchRequest)this.reqMap.get(resp.id());
        if (batchReq == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got response for unknown DR request: req=" + resp.id() + ", code=" + resp.code() + ", node=" + respondedNodeId);
            }
            return;
        }
        DrSenderNode node = (DrSenderNode)this.sndNodes.get(respondedNodeId);
        if (node != null) {
            node.onResponse(resp);
        }
        byte code = resp.code();
        switch (code) {
            case 1: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Internal DR request rescheduled: req=" + resp.id() + ", node=" + respondedNodeId);
                }
                this.reqIdsToResend.add(resp.id());
                this.scheduleResend();
                this.metrics.get().onSenderCacheBatchRejected(batchReq.entriesCount());
                return;
            }
            case 2: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Internal DR request confirmation received: req=" + resp.id() + ", node=" + respondedNodeId);
                }
                batchReq.confirm();
                return;
            }
        }
        if (code != 0) {
            this.log.warning("Internal DR response with unknown error code, consider delivery was successful: " + code + "req=" + resp.id() + ", node=" + respondedNodeId);
        }
        batchReq.complete(resp.error() == null ? CacheDrResultType.ACKNOWLEDGED : CacheDrResultType.IGNORED, resp.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DrInternalRequest createInternalRequest(Map<Byte, EntryBuffer> entryBuffers, Collection<Byte> targetDCs, IgniteUuid fstId) {
        ArrayList<DrInternalRequestEntry> reqEntries = new ArrayList<DrInternalRequestEntry>(entryBuffers.size());
        int entriesCnt = 0;
        try {
            for (Map.Entry<Byte, EntryBuffer> e : entryBuffers.entrySet()) {
                EntryBuffer buf = e.getValue();
                buf.flush();
                reqEntries.add(new DrInternalRequestEntry(e.getKey(), buf.entriesCnt(), buf.getBytes(), buf.sizeBytes()));
                entriesCnt += buf.entriesCnt();
            }
        }
        catch (Throwable throwable) {
            for (EntryBuffer buf : entryBuffers.values()) {
                U.closeQuiet((AutoCloseable)buf);
            }
            throw throwable;
        }
        for (EntryBuffer buf : entryBuffers.values()) {
            U.closeQuiet((AutoCloseable)buf);
        }
        return new DrInternalRequest(ID_GEN.incrementAndGet(), this.cctx.name(), targetDCs, reqEntries, entriesCnt, fstId);
    }

    public void stopServingRequests() {
        this.stopping = true;
        this.busyLock.block();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stop DR batch manager: cache=" + this.cctx.name());
        }
        this.ioMgr.removeMessageListener(this.topic);
        this.reqMap.forEach((k, f) -> ((BatchRequest)f).complete(CacheDrResultType.IGNORED, null));
        this.reqMap.clear();
        this.reqIdsToResend.clear();
        this.sndNodes.values().forEach(DrSenderNode::clearUnprocessedRequests);
    }

    private static class Permit {
        private final long maxPermits;
        private long permits;

        private Permit(long permits) {
            this.permits = permits;
            this.maxPermits = permits;
        }

        synchronized boolean acquire(int cnt) {
            if (this.permits < (long)cnt && this.permits < this.maxPermits) {
                return false;
            }
            this.permits -= (long)cnt;
            return true;
        }

        synchronized void release(int cnt) {
            this.permits += (long)cnt;
            assert (this.permits <= this.maxPermits);
        }
    }

    private class BatchRequest {
        private final long reqId;
        private final int size;
        private final int entryCnt;
        private final DrBatchStateListener lsnr;
        private volatile DrInternalRequest req;
        private final AtomicBoolean completed = new AtomicBoolean();

        private BatchRequest(DrInternalRequest req, DrBatchStateListener batchLsnr) {
            this.req = req;
            this.lsnr = batchLsnr;
            this.size = req.entries().parallelStream().mapToInt(DrInternalRequestEntry::dataLength).sum();
            this.entryCnt = req.entryCount();
            this.reqId = req.id();
            this.req.force(true);
        }

        private long id() {
            return this.reqId;
        }

        private int entriesCount() {
            return this.entryCnt;
        }

        private int size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void confirm() {
            BatchRequest batchRequest = this;
            synchronized (batchRequest) {
                if (this.req == null) {
                    return;
                }
                this.req = null;
                CacheSenderHubManager.this.releasePermit(this.size());
            }
            this.lsnr.onSent();
        }

        private void complete(CacheDrResultType resType, @Nullable Throwable err) {
            assert (resType != null);
            if (this.completed.compareAndSet(false, true)) {
                BatchRequest old = (BatchRequest)CacheSenderHubManager.this.reqMap.remove(this.reqId);
                this.confirm();
                switch (resType) {
                    case ACKNOWLEDGED: {
                        assert (old != null);
                        if (CacheSenderHubManager.this.log.isDebugEnabled()) {
                            CacheSenderHubManager.this.log.debug("Incremental DR batch acked: id=" + this.reqId);
                        }
                        this.lsnr.onAcked();
                        ((CacheDrMetrics)CacheSenderHubManager.this.metrics.get()).onSenderCacheBatchAcknowledged(this.entryCnt);
                        break;
                    }
                    case IGNORED: {
                        if (CacheSenderHubManager.this.log.isDebugEnabled()) {
                            CacheSenderHubManager.this.log.debug("Internal DR request ignored: id=" + this.reqId);
                        }
                        this.lsnr.onRejected(null);
                        ((CacheDrMetrics)CacheSenderHubManager.this.metrics.get()).onSenderCacheBatchRejected(this.entryCnt);
                        break;
                    }
                    case FAILED: {
                        CacheSenderHubManager.this.log.info("Incremental DR batch failed, will retry: id=" + this.reqId);
                        this.lsnr.onRejected(err);
                        ((CacheDrMetrics)CacheSenderHubManager.this.metrics.get()).onSenderCacheBatchFailed(this.entryCnt);
                    }
                }
            }
        }
    }
}

