/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collections;
import org.gridgain.grid.cache.dr.CacheDrMBean;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheSenderHubManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.GridGainCacheIncrementalDrManager;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class CacheIncrementalDrMBeanAdapter
implements CacheDrMBean {
    private final GridGainCacheIncrementalDrManager dr;
    private final GridGainCacheConfiguration ggCcfg;
    private final GridGainConfiguration ggCfg;
    private final CacheSenderHubManager sndHubMgr;

    CacheIncrementalDrMBeanAdapter(GridGainCacheIncrementalDrManager dr, CacheSenderHubManager sndHubMgr, GridGainConfiguration ggCfg, GridGainCacheConfiguration ggCcfg) {
        this.dr = dr;
        this.sndHubMgr = sndHubMgr;
        this.ggCfg = ggCfg;
        this.ggCcfg = ggCcfg;
    }

    @Override
    public int getDrQueuedKeysCount() {
        return this.sndHubMgr.queuedKeysCount();
    }

    @Override
    public int getDrBackupQueueSize() {
        throw new UnsupportedOperationException("Backup queue is not used for incremental state transfer.");
    }

    @Override
    public int getDrBatchWaitingSendCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDrBatchWaitingAcknowledgeCount() {
        return this.sndHubMgr.batchWaitingAcknowledgeCount();
    }

    @Override
    public int getDrSenderHubsCount() {
        return this.sndHubMgr.sendersCnt();
    }

    @Override
    public String getDrSenderGroup() {
        CacheDrSenderConfiguration sndCfg = this.ggCcfg.getDrSenderConfiguration();
        assert (sndCfg != null);
        return this.ggCfg.isDrUseCacheNames() ? "" : DrUtils.effectiveSenderGroup(sndCfg);
    }

    @Override
    public String getDrStatus() {
        try {
            CacheDrStatus status = this.dr.drStatus();
            if (!status.stopped()) {
                return "Active";
            }
            return "Stopped [reason=" + (Object)((Object)status.reason()) + (status.error() == null ? "" : ", error=" + status.error()) + ']';
        }
        catch (IllegalStateException ignored) {
            return "Not configured";
        }
    }

    @Override
    public void pause() {
        this.dr.stopReplication();
    }

    @Override
    public void resume() {
        this.dr.startReplication();
    }

    @Override
    @Deprecated
    public void stop() {
        this.pause();
    }

    @Override
    @Deprecated
    public void start() {
        this.resume();
    }

    @Override
    public void transferTo(byte dataCenterId) {
        this.dr.startStateTransfer(Collections.singleton(dataCenterId), false);
    }

    @Override
    public void setStateTransferThrottle(long stateTransferThrottle) {
        throw new UnsupportedOperationException("Throttling is not supported with incremental state transfer.");
    }

    @Override
    public long getStateTransferThrottle() {
        throw new UnsupportedOperationException("Throttling is not supported with incremental state transfer.");
    }

    @Override
    public void disableAdaptiveThrottling() {
        throw new UnsupportedOperationException("Throttling is not supported with incremental state transfer.");
    }

    @Override
    public void enableAdaptiveThrottling() {
        throw new UnsupportedOperationException("Throttling is not supported with incremental state transfer.");
    }
}

