/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.tree.updatelog.PartitionLogTree;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.cache.dr.CacheDrEntryFilter;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrMetrics;
import org.gridgain.grid.internal.processors.cache.dr.Cancellable;
import org.gridgain.grid.internal.processors.cache.dr.SerializedDrEntry;
import org.gridgain.grid.internal.processors.cache.dr.ist.CachePartitionStateManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.CacheSenderHubManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatch;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatchManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrBatchStateListener;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrEntryFilterWrapper;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrPartitionAwareJob;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateAware;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateHolder;
import org.gridgain.grid.internal.processors.cache.dr.ist.PartitionDrHandler;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CacheIncrementalDrHandler
implements DrStateAware {
    private final GridCacheContext cctx;
    private final Consumer<DrPartitionAwareJob> executor;
    private final IgniteLogger log;
    private final DrBatchManager batchMgr;
    private final CacheSenderHubManager sndHubMgr;
    private final CachePartitionStateManager partStateMgr;
    private final Supplier<CacheDrMetrics> metrics;
    private final GridBusyLock busyLock;
    private final DrEntryFilterWrapper drFilter;
    private final Map<Integer, PartitionDrHandler> handlers = new ConcurrentHashMap<Integer, PartitionDrHandler>();
    private final DrStateHolder drState;
    private final GridTimeoutProcessor.CancelableTask batchTimeoutTask;
    private final FlushBatchJob flushBatchJob;

    public CacheIncrementalDrHandler(GridCacheContext cctx, IgniteLogger log, CachePartitionStateManager partStateMgr, CacheSenderHubManager sndHubMgr, DrStateHolder drState, GridBusyLock busyLock, CacheDrEntryFilter entryFilter, int batchSendSize, int batchSendSizeBytes, long batchSendPeriod, Consumer<DrPartitionAwareJob> executor, Supplier<CacheDrMetrics> metricsSupplier) {
        this.cctx = cctx;
        this.log = log;
        this.partStateMgr = partStateMgr;
        this.sndHubMgr = sndHubMgr;
        this.drState = drState;
        this.busyLock = busyLock;
        this.executor = executor;
        this.metrics = metricsSupplier;
        this.drFilter = entryFilter == null ? null : new DrEntryFilterWrapper(cctx.cacheObjectContext(), entryFilter);
        this.batchMgr = new DrBatchManager(batchSendSize, batchSendSizeBytes, batchSendPeriod);
        this.batchTimeoutTask = batchSendPeriod == 0L ? null : cctx.kernalContext().timeout().schedule(this::sendBatchOnTimeout, batchSendPeriod, batchSendPeriod);
        this.flushBatchJob = new FlushBatchJob();
        String cacheName = cctx.name();
        assert (CacheType.cacheType((String)cacheName) == CacheType.USER) : "replication of inner system caches is deprecated, cacheName=" + cacheName;
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stop incremental DR handler.");
        }
        this.handlers.values().forEach(h -> h.cancel());
        if (this.batchTimeoutTask != null) {
            this.batchTimeoutTask.close();
        }
    }

    @Override
    public void onPause() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Pause incremental DR.");
        }
        this.handlers.values().forEach(h -> h.pauseTransfer());
    }

    @Override
    public void onResume() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resume incremental DR.");
        }
        this.handlers.values().forEach(h -> h.resumeTransfer());
    }

    <K, V> SerializedDrEntry serializeEntry(GridCacheRawVersionedEntry<K, V> entry) {
        try {
            entry.marshal(this.cctx.cacheObjectContext(), this.cctx.gridConfig().getMarshaller());
            GridByteArrayOutputStream out = new GridByteArrayOutputStream(DrUtils.drEntrySize(entry));
            try (DataOutputStream dataOutput = new DataOutputStream((OutputStream)out);){
                DrUtils.writeDrEntry(dataOutput, entry);
            }
            assert (DrUtils.drEntrySize(entry) == out.internalArray().length);
            return new SerializedDrEntry(entry.version().dataCenterId(), out.internalArray());
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException("Failed to marshal data for replication.", e);
        }
    }

    public void onPartitionCounterChanged(int part) {
        PartitionDrHandler hnd = this.handlers.get(part);
        if (hnd != null) {
            hnd.onUpdateCounterChanged();
        }
    }

    public void onPartitionAssignment(Set<Integer> primaryParts, Set<Integer> backupParts) {
        this.cctx.topology().localPartitions().forEach(locPart -> {
            int part = locPart.id();
            if (primaryParts.contains(part)) {
                if (locPart.state() != GridDhtPartitionState.OWNING) {
                    this.log.warning("Skip replication for cache partition: cache=" + this.cctx.name() + ", part=" + part + ", partState=" + locPart.state());
                    return;
                }
                if (this.log.isDebugEnabled() && !this.handlers.containsKey(part)) {
                    this.log.debug("Start partition replication: cache=" + this.cctx.name() + ", part=" + part);
                }
                PartitionDrHandler hnd = this.handlers.computeIfAbsent(part, p -> new PartitionDrHandler(this.cctx, (Integer)p, this, this.partStateMgr));
                this.partStateMgr.initUpdateCounter(part, locPart.updateCounter());
                hnd.continueTransfer();
                this.partStateMgr.cleanupAsync(part);
            } else {
                PartitionDrHandler rmv = this.handlers.remove(part);
                if (rmv != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Cancel partition replication, owner changed: cache=" + this.cctx.name() + ", part=" + rmv.part());
                    }
                    rmv.cancel();
                }
                if (backupParts.contains(part)) {
                    this.partStateMgr.cleanupAsync(part);
                }
            }
        });
    }

    public boolean isActive() {
        return this.drState.isActive();
    }

    public IncrementalStateTransferJob createJob(PartitionDrHandler handler, long startCntr) {
        return new IncrementalStateTransferJob(handler, startCntr);
    }

    public void submit(DrPartitionAwareJob job) {
        this.executor.accept(job);
    }

    private void sendBatchOnTimeout() {
        DrBatch batch = this.batchMgr.tryGetCurrentBatch();
        if (batch != null && batch.readyToSend()) {
            this.flushBatchJob.tryRunAsync();
        }
    }

    private void send(DrBatch batch) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending batch: " + batch);
        }
        this.sndHubMgr.send(batch.toBuffers(this.cctx), batch);
    }

    private static boolean shouldBatchBeSent(DrBatch batch) {
        return batch != null && batch.readyToSend() && batch.denyAdditions();
    }

    public class IncrementalStateTransferJob
    implements DrPartitionAwareJob,
    Cancellable {
        private final int part;
        private final PartitionDrHandler istHnd;
        private long startCntr;
        private volatile boolean cancelled;

        IncrementalStateTransferJob(PartitionDrHandler istHnd, long startCntr) {
            this.istHnd = istHnd;
            this.part = istHnd.part();
            this.startCntr = startCntr;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public int part() {
            return this.part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: {
                if (!CacheIncrementalDrHandler.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    GridDhtLocalPartition locPart = CacheIncrementalDrHandler.this.cctx.topology().localPartition(this.part, AffinityTopologyVersion.NONE, false);
                    if (!this.reservePartition(locPart)) {
                        return;
                    }
                    try {
                        long from = this.startCntr;
                        long to = CacheIncrementalDrHandler.this.partStateMgr.updateCounter(this.part);
                        if (from >= to) {
                            if (CacheIncrementalDrHandler.this.log.isTraceEnabled()) {
                                CacheIncrementalDrHandler.this.log.trace("Skip partition replication: part=" + this.part + ", reason='Nothing to do'");
                            }
                            return;
                        }
                        this.scanLogTree(this.partitionLogTree(locPart), from, to);
                    }
                    catch (Exception ex) {
                        throw new IgniteException((Throwable)ex);
                    }
                    finally {
                        locPart.release();
                        this.istHnd.onTransferJobFinished(this);
                    }
                }
                catch (Throwable th) {
                    if (this.cancelled) {
                        if (CacheIncrementalDrHandler.this.log.isTraceEnabled()) {
                            CacheIncrementalDrHandler.this.log.trace("Partition replication was cancelled: " + this.toString());
                        }
                        break block19;
                    }
                    U.error((IgniteLogger)CacheIncrementalDrHandler.this.log, (Object)("Partition replication failed: " + this.toString()), (Throwable)th);
                    throw th;
                }
                finally {
                    CacheIncrementalDrHandler.this.busyLock.leaveBusy();
                }
            }
        }

        void scanLogTree(PartitionLogTree tree, long fromCntr, long toCntr) throws IgniteCheckedException {
            assert (tree != null);
            while (fromCntr < toCntr) {
                if (this.isCancelled()) {
                    return;
                }
                GridCursor curs = tree.find((Object)new UpdateLogRow(CacheIncrementalDrHandler.this.cctx.cacheId(), fromCntr + 1L), (Object)new UpdateLogRow(CacheIncrementalDrHandler.this.cctx.cacheId(), toCntr), PartitionLogTree.FULL_ROW);
                this.scanCursor((GridCursor<UpdateLogRow>)curs, fromCntr, toCntr);
                if (this.isCancelled()) {
                    return;
                }
                fromCntr = toCntr;
                toCntr = CacheIncrementalDrHandler.this.partStateMgr.updateCounter(this.part);
            }
            this.startCntr = toCntr;
        }

        private void scanCursor(GridCursor<UpdateLogRow> curs, long fromCntr, long toCntr) throws IgniteCheckedException {
            long lastCntr = fromCntr;
            DrBatch currentBatch = null;
            boolean addedToBatch = false;
            while (curs.next()) {
                UpdateLogRow row = (UpdateLogRow)curs.get();
                SerializedDrEntry entry = this.prepareBatchEntry(row);
                if (entry == null) {
                    lastCntr = row.updateCounter();
                    continue;
                }
                while (!this.isCancelled()) {
                    if (currentBatch == null) {
                        currentBatch = CacheIncrementalDrHandler.this.batchMgr.getCurrentBatch();
                        addedToBatch = false;
                    }
                    if (currentBatch.add(entry)) {
                        addedToBatch = true;
                        if (!currentBatch.readyToSend()) break;
                        this.progressCheckpoint(fromCntr, row.updateCounter(), currentBatch);
                        if (currentBatch.denyAdditions()) {
                            CacheIncrementalDrHandler.this.batchMgr.discardBatch(currentBatch);
                            CacheIncrementalDrHandler.this.send(currentBatch);
                        }
                        currentBatch = null;
                        fromCntr = row.updateCounter();
                        break;
                    }
                    this.progressCheckpoint(fromCntr, lastCntr, addedToBatch ? currentBatch : null);
                    CacheIncrementalDrHandler.this.batchMgr.discardBatch(currentBatch);
                    currentBatch = null;
                    fromCntr = lastCntr;
                }
                if (this.isCancelled()) {
                    return;
                }
                lastCntr = row.updateCounter();
            }
            this.progressCheckpoint(fromCntr, toCntr, addedToBatch ? currentBatch : null);
        }

        private void progressCheckpoint(long fromCntr, long toCntr, @Nullable DrBatch currentBatch) {
            if (toCntr <= fromCntr) {
                return;
            }
            this.istHnd.onBatchUpdated(this, fromCntr, toCntr);
            if (currentBatch != null) {
                currentBatch.listen(new BatchStateListener(fromCntr, toCntr));
            } else {
                this.istHnd.onBatchAcknowledged(fromCntr, toCntr);
            }
        }

        PartitionLogTree partitionLogTree(GridDhtLocalPartition locPart) throws IgniteCheckedException {
            return CacheIncrementalDrHandler.this.cctx.offheap().dataStore(locPart).logTree().tree();
        }

        @Contract(value="null -> false")
        private boolean reservePartition(@Nullable GridDhtLocalPartition locPart) {
            if (locPart == null || !locPart.reserve()) {
                if (CacheIncrementalDrHandler.this.log.isTraceEnabled()) {
                    CacheIncrementalDrHandler.this.log.trace("Skip partition replication: part=" + this.part + ", reason='Can't reserve partition'");
                }
                return false;
            }
            boolean isValid = false;
            try {
                isValid = locPart.state() == GridDhtPartitionState.OWNING && CacheIncrementalDrHandler.this.cctx.affinity().primaryByPartition(CacheIncrementalDrHandler.this.cctx.localNode(), this.part, AffinityTopologyVersion.NONE);
            }
            finally {
                if (!isValid) {
                    locPart.release();
                    if (CacheIncrementalDrHandler.this.log.isTraceEnabled()) {
                        CacheIncrementalDrHandler.this.log.trace("Skip partition replication: part=" + this.part + ", reason='Partition is not primary'");
                    }
                }
            }
            return isValid;
        }

        @Nullable
        SerializedDrEntry prepareBatchEntry(UpdateLogRow row) throws IgniteCheckedException {
            GridCacheVersion conflictVer = row.version().conflictVersion();
            if (CacheIncrementalDrHandler.this.sndHubMgr.shouldIgnoreDc(conflictVer.dataCenterId())) {
                return null;
            }
            GridCacheRawVersionedEntry entry = new GridCacheRawVersionedEntry(row.key(), row.value().cacheObjectType() == -1 ? null : row.value(), row.expireTime() > 0L ? 1L : 0L, row.expireTime(), conflictVer);
            if (CacheIncrementalDrHandler.this.drFilter != null && !CacheIncrementalDrHandler.this.drFilter.accept(entry)) {
                ((CacheDrMetrics)CacheIncrementalDrHandler.this.metrics.get()).onSenderCacheEntryFiltered();
                return null;
            }
            return CacheIncrementalDrHandler.this.serializeEntry(entry);
        }

        public String toString() {
            return "IncrementalStateTransferJob[cache=" + CacheIncrementalDrHandler.this.cctx.name() + "part=" + this.part + ']';
        }

        private class BatchStateListener
        implements DrBatchStateListener {
            private final long start;
            private final long end;

            BatchStateListener(long start, long end) {
                this.start = start;
                this.end = end;
            }

            @Override
            public void onAcked() {
                if (!IncrementalStateTransferJob.this.isCancelled()) {
                    IncrementalStateTransferJob.this.istHnd.onBatchAcknowledged(this.start, this.end);
                }
            }

            @Override
            public void onRejected(@Nullable Throwable err) {
                if (!IncrementalStateTransferJob.this.isCancelled()) {
                    IncrementalStateTransferJob.this.istHnd.onBatchRejected(IncrementalStateTransferJob.this);
                }
            }

            @Override
            public void onSent() {
            }

            public String toString() {
                return S.toString(BatchStateListener.class, (Object)this);
            }
        }
    }

    public class FlushBatchJob
    implements DrPartitionAwareJob {
        private final int fakePartId;
        private final AtomicBoolean submitted;

        public FlushBatchJob() {
            this.fakePartId = Math.abs(CacheIncrementalDrHandler.this.cctx.cacheId());
            this.submitted = new AtomicBoolean();
        }

        void tryRunAsync() {
            if (this.submitted.compareAndSet(false, true)) {
                CacheIncrementalDrHandler.this.submit(this);
            }
        }

        @Override
        public int part() {
            return this.fakePartId;
        }

        @Override
        public void run() {
            block4: {
                this.submitted.set(false);
                try {
                    DrBatch batch = CacheIncrementalDrHandler.this.batchMgr.tryGetCurrentBatch();
                    if (CacheIncrementalDrHandler.shouldBatchBeSent(batch)) {
                        CacheIncrementalDrHandler.this.send(batch);
                        CacheIncrementalDrHandler.this.batchMgr.discardBatch(batch);
                    }
                }
                catch (Throwable th) {
                    if (!(th instanceof IgniteInterruptedException) || CacheIncrementalDrHandler.this.log.isDebugEnabled()) {
                        CacheIncrementalDrHandler.this.log.warning("Failed to send batch by timeout: cacheId=" + CacheIncrementalDrHandler.this.cctx.cacheId(), th);
                    }
                    if (!CacheIncrementalDrHandler.this.log.isTraceEnabled()) break block4;
                    CacheIncrementalDrHandler.this.log.trace("Failed to send batch by timeout: cacheId=" + CacheIncrementalDrHandler.this.cctx.cacheId());
                }
            }
        }
    }
}

