/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.jetbrains.annotations.Nullable;

public final class SnapshotMetadataV2
implements Externalizable {
    public static final String FAILED_TO_MERGE_SNAPSHOT_METADATA = "Failed to merge snapshot metadata [oldMeta=";
    private static final int PROTO_VER = 11;
    private static final long serialVersionUID = 0L;
    private int protocol = 11;
    private long id;
    private UUID initiatorNodeId;
    private int pageSize;
    private boolean fullSnapshot;
    private boolean forcedFullSnapshot;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    private Collection<ClusterNode> topology;
    private String msg;
    @GridToStringInclude
    private Map<Integer, CacheSnapshotMetadata> cacheMetas;
    @GridToStringInclude
    private Map<Byte, Map<Integer, String>> marshallerMappingsMap = new HashMap<Byte, Map<Integer, String>>();
    private Map<String, Long> sizeOnlyDataInPages;
    private Map<String, Long> sizeInPages;
    @GridToStringInclude
    private Map<Integer, BinaryMetadata> binaryMetadataMap = new HashMap<Integer, BinaryMetadata>();
    private Map<Short, WALPointer> walPoints = new HashMap<Short, WALPointer>();
    @Nullable
    private BaselineTopology baselineTop;
    private boolean pointInTimeRecoveryEnabled;
    private CompressionOption compressionOption = CompressionOption.NONE;
    private int compressionLevel = -1;
    private boolean singleCopied;
    private boolean exchangelessSnapshot;
    private SnapshotEncryptionOptions encryptionOptions;
    private Map<Short, ConsistentCutMeta> consistentCutMetas = new HashMap<Short, ConsistentCutMeta>();

    public SnapshotMetadataV2(long id, UUID initiatorNodeId, int pageSize, Map<Byte, Map<Integer, String>> marshallerMappingsMap, Map<Integer, BinaryMetadata> binaryMetadataMap, boolean fullSnapshot, boolean forcedFullSnapshot, AffinityTopologyVersion topVer, Collection<ClusterNode> topology, Map<Integer, CacheSnapshotMetadata> cacheMetas, Map<String, Long> sizeOnlyDataInPages, Map<String, Long> sizeInPages, boolean pointInTimeRecoveryEnabled, Map<Short, WALPointer> walPoints, @Nullable BaselineTopology baselineTop, String msg, CompressionOption compressionOption, int compressionLevel, boolean singleCopied, boolean exchangelessSnapshot, @Nullable SnapshotEncryptionOptions encryptionOptions, @Nullable Map<Short, ConsistentCutMeta> consistentCutMetas) {
        this.id = id;
        this.initiatorNodeId = initiatorNodeId;
        this.pageSize = pageSize;
        this.marshallerMappingsMap.putAll(marshallerMappingsMap);
        this.binaryMetadataMap.putAll(binaryMetadataMap);
        this.fullSnapshot = fullSnapshot;
        this.forcedFullSnapshot = forcedFullSnapshot;
        this.topVer = topVer;
        this.topology = topology;
        this.cacheMetas = cacheMetas;
        this.sizeOnlyDataInPages = sizeOnlyDataInPages;
        this.sizeInPages = sizeInPages;
        this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
        this.baselineTop = baselineTop;
        this.msg = msg;
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.exchangelessSnapshot = exchangelessSnapshot;
        this.encryptionOptions = encryptionOptions;
        if (walPoints != null) {
            this.walPoints.putAll(walPoints);
        }
        this.singleCopied = singleCopied;
        if (consistentCutMetas != null) {
            this.consistentCutMetas.putAll(consistentCutMetas);
        }
    }

    public SnapshotMetadataV2(SnapshotMetadata oldMetadata) {
        this.id = oldMetadata.id();
        this.initiatorNodeId = oldMetadata.initiatorNodeId();
        this.pageSize = oldMetadata.pageSize();
        this.marshallerMappingsMap.putAll(oldMetadata.typeMap());
        this.fullSnapshot = oldMetadata.fullSnapshot();
        this.topVer = oldMetadata.topologyVersion();
        this.topology = oldMetadata.topology();
        this.cacheMetas = oldMetadata.cacheMetadata();
        this.sizeOnlyDataInPages = oldMetadata.sizeOnlyDataInPages;
        this.sizeInPages = oldMetadata.sizeInPages;
        this.msg = oldMetadata.message();
    }

    public SnapshotMetadataV2() {
    }

    public long id() {
        return this.id;
    }

    public UUID initiatorNodeId() {
        return this.initiatorNodeId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Set<Integer> cacheGroupIds() {
        return new HashSet<Integer>(this.cacheMetas.keySet());
    }

    public Map<Byte, Map<Integer, String>> typeMap() {
        if (this.marshallerMappingsMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.marshallerMappingsMap);
    }

    public Map<Integer, BinaryMetadata> binaryMetadataMap() {
        if (this.binaryMetadataMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.binaryMetadataMap);
    }

    public SnapshotEncryptionOptions encryptionOptions() {
        return this.encryptionOptions;
    }

    public Map<Short, WALPointer> walPoints() {
        if (this.walPoints == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.walPoints);
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTop;
    }

    @Deprecated
    public Map<Integer, CacheSnapshotMetadata> cacheMetadata() {
        return this.cacheMetas;
    }

    public Map<Integer, CacheSnapshotMetadata> cacheGroupsMetadata() {
        return this.cacheMetas;
    }

    public long sizeInPages() {
        if (this.sizeInPages == null) {
            return -1L;
        }
        long size = 0L;
        for (Long s : this.sizeInPages.values()) {
            size += s.longValue();
        }
        return size;
    }

    public long sizeInBytes() {
        long sizeInPages = this.sizeInPages();
        return sizeInPages == -1L ? -1L : sizeInPages * (long)this.pageSize;
    }

    public long sizeOnlyDataInPages() {
        if (this.sizeOnlyDataInPages == null) {
            return -1L;
        }
        long size = 0L;
        for (Long s : this.sizeOnlyDataInPages.values()) {
            size += s.longValue();
        }
        return size;
    }

    public long sizeOnlyDataInBytes() {
        long sizeOnlyDataInPages = this.sizeOnlyDataInPages();
        return sizeOnlyDataInPages == -1L ? -1L : sizeOnlyDataInPages * (long)this.pageSize;
    }

    public Map<Long, Set<String>> previousSnapshots() {
        HashMap<Long, Set<String>> prevSnapshots = new HashMap<Long, Set<String>>();
        if (!F.isEmpty(this.cacheMetas)) {
            for (CacheSnapshotMetadata m : this.cacheMetas.values()) {
                for (Long prevSnapshotId : m.previousSnapshotIds()) {
                    if (prevSnapshotId != null && prevSnapshotId <= 0L) continue;
                    Set caches = prevSnapshots.computeIfAbsent(prevSnapshotId, id -> new HashSet());
                    caches.add(m.cacheOrGroupName());
                    prevSnapshots.put(prevSnapshotId, caches);
                }
            }
        }
        return prevSnapshots;
    }

    public boolean fullSnapshot() {
        return this.fullSnapshot;
    }

    public boolean exchangelessSnapshot() {
        return this.exchangelessSnapshot;
    }

    public Map<Short, ConsistentCutMeta> consistentCutMetas() {
        return Collections.unmodifiableMap(this.consistentCutMetas);
    }

    public boolean forceFullSnapshot() {
        return this.forcedFullSnapshot;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Collection<ClusterNode> topology() {
        return this.topology;
    }

    public CompressionOption compressionOption() {
        return this.compressionOption;
    }

    public int compressionLevel() {
        return this.compressionLevel;
    }

    public int clientNodesCount() {
        int clnNodesCnt = 0;
        if (!F.isEmpty(this.topology)) {
            for (ClusterNode node : this.topology) {
                if (!node.isClient()) continue;
                ++clnNodesCnt;
            }
        }
        return clnNodesCnt;
    }

    public Set<IgniteProductVersion> getVersions() {
        HashSet<IgniteProductVersion> versions = new HashSet<IgniteProductVersion>();
        for (ClusterNode node : this.topology) {
            versions.add(node.version());
        }
        return versions;
    }

    public String message() {
        return this.msg;
    }

    public SnapshotMetadataV2 merge(@Nullable SnapshotMetadataV2 oldMetadata) throws IgniteCheckedException {
        Map<Short, ConsistentCutMeta> consistentCutMetas;
        Map<Short, WALPointer> walPoints;
        Map<String, Long> sizeInPages;
        Map<String, Long> sizeOnlyDataInPages;
        if (oldMetadata == null) {
            return this;
        }
        if (oldMetadata.initiatorNodeId() == null || oldMetadata.topologyVersion() == null || !oldMetadata.initiatorNodeId().equals(this.initiatorNodeId()) || oldMetadata.pageSize() != this.pageSize() || !oldMetadata.topologyVersion().equals((Object)this.topologyVersion()) || oldMetadata.pointInTimeRecoveryEnabled() != this.pointInTimeRecoveryEnabled() || oldMetadata.exchangelessSnapshot() != this.exchangelessSnapshot() || oldMetadata.fullSnapshot() != this.fullSnapshot() && (oldMetadata.fullSnapshot() && !oldMetadata.forceFullSnapshot() || this.fullSnapshot() && !this.forceFullSnapshot())) {
            throw new IgniteCheckedException(FAILED_TO_MERGE_SNAPSHOT_METADATA + oldMetadata + ", mergeMeta=" + this + ']');
        }
        Map<Integer, CacheSnapshotMetadata> mergedMetas = oldMetadata.cacheGroupsMetadata();
        Set<IgniteProductVersion> versions = this.getVersions();
        for (Map.Entry<Integer, CacheSnapshotMetadata> metaEntry : this.cacheGroupsMetadata().entrySet()) {
            Integer grpId = metaEntry.getKey();
            CacheSnapshotMetadata oldCacheMeta = mergedMetas.get(grpId);
            assert (oldCacheMeta != null);
            mergedMetas.put(grpId, oldCacheMeta.merge(metaEntry.getValue(), versions, this.exchangelessSnapshot()));
        }
        Map<Byte, Map<Integer, String>> marshallerMappings = this.mergeMarshallerMappingsMeta(oldMetadata.marshallerMappingsMap);
        Map<Integer, BinaryMetadata> binaryMetas = this.mergeBinaryMetadataMap(oldMetadata.binaryMetadataMap);
        if (this.sizeOnlyDataInPages == null || this.sizeOnlyDataInPages.isEmpty()) {
            sizeOnlyDataInPages = oldMetadata.sizeOnlyDataInPages;
        } else if (oldMetadata.sizeOnlyDataInPages == null || oldMetadata.sizeOnlyDataInPages.isEmpty()) {
            sizeOnlyDataInPages = this.sizeOnlyDataInPages;
        } else {
            sizeOnlyDataInPages = new HashMap<String, Long>(this.sizeOnlyDataInPages);
            sizeOnlyDataInPages.putAll(oldMetadata.sizeOnlyDataInPages);
        }
        if (this.sizeInPages == null || this.sizeInPages.isEmpty()) {
            sizeInPages = oldMetadata.sizeInPages;
        } else if (oldMetadata.sizeInPages == null || oldMetadata.sizeInPages.isEmpty()) {
            sizeInPages = this.sizeInPages;
        } else {
            sizeInPages = new HashMap<String, Long>(this.sizeInPages);
            sizeInPages.putAll(oldMetadata.sizeInPages);
        }
        if (this.walPoints == null || this.walPoints.isEmpty()) {
            walPoints = oldMetadata.walPoints;
        } else if (oldMetadata.walPoints == null || oldMetadata.walPoints.isEmpty()) {
            walPoints = this.walPoints;
        } else {
            walPoints = new HashMap<Short, WALPointer>(this.walPoints);
            walPoints.putAll(oldMetadata.walPoints);
        }
        if (this.consistentCutMetas == null || this.consistentCutMetas.isEmpty()) {
            consistentCutMetas = oldMetadata.consistentCutMetas;
        } else if (oldMetadata.consistentCutMetas == null || oldMetadata.consistentCutMetas.isEmpty()) {
            consistentCutMetas = this.consistentCutMetas;
        } else {
            consistentCutMetas = new HashMap<Short, ConsistentCutMeta>(this.consistentCutMetas);
            consistentCutMetas.putAll(oldMetadata.consistentCutMetas);
        }
        return new SnapshotMetadataV2(this.id, oldMetadata.initiatorNodeId(), oldMetadata.pageSize(), marshallerMappings, binaryMetas, oldMetadata.fullSnapshot() && this.fullSnapshot(), false, oldMetadata.topologyVersion(), oldMetadata.topology(), mergedMetas, sizeOnlyDataInPages, sizeInPages, this.pointInTimeRecoveryEnabled, walPoints, oldMetadata.baselineTop != null ? oldMetadata.baselineTop : this.baselineTop, this.msg, this.compressionOption, this.compressionLevel, false, this.exchangelessSnapshot, oldMetadata.encryptionOptions, consistentCutMetas);
    }

    private Map<Integer, BinaryMetadata> mergeBinaryMetadataMap(Map<Integer, BinaryMetadata> oldMetadata) {
        Map<Integer, BinaryMetadata> binMetadata = this.binaryMetadataMap();
        if (binMetadata == null) {
            return oldMetadata;
        }
        for (Map.Entry<Integer, BinaryMetadata> e : binMetadata.entrySet()) {
            if (!oldMetadata.containsKey(e.getKey())) {
                oldMetadata.put(e.getKey(), e.getValue());
                continue;
            }
            BinaryMetadata oldVal = oldMetadata.get(e.getKey());
            BinaryMetadata newVal = e.getValue();
            BinaryMetadata mergedVal = BinaryUtils.mergeMetadata((BinaryMetadata)oldVal, (BinaryMetadata)newVal);
            oldMetadata.put(e.getKey(), mergedVal);
        }
        return oldMetadata;
    }

    private Map<Byte, Map<Integer, String>> mergeMarshallerMappingsMeta(Map<Byte, Map<Integer, String>> oldMappings) {
        Map<Byte, Map<Integer, String>> newMappings = this.marshallerMappingsMap;
        if (newMappings == null) {
            return oldMappings;
        }
        for (Map.Entry<Byte, Map<Integer, String>> newEntry : newMappings.entrySet()) {
            byte platformId = newEntry.getKey();
            if (oldMappings.containsKey(platformId)) {
                oldMappings.get(platformId).putAll(newEntry.getValue());
                continue;
            }
            oldMappings.put(platformId, newEntry.getValue());
        }
        return oldMappings;
    }

    public Set<String> cacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        for (CacheSnapshotMetadata cacheMeta : this.cacheGroupsMetadata().values()) {
            cacheNames.addAll(cacheMeta.cacheNames());
        }
        return cacheNames;
    }

    public Map<String, CacheMode> cacheModes() {
        HashMap<String, CacheMode> cacheModes = new HashMap<String, CacheMode>();
        for (CacheSnapshotMetadata cacheMeta : this.cacheGroupsMetadata().values()) {
            for (CacheConfiguration cfg : cacheMeta.cacheConfigurations()) {
                cacheModes.put(cfg.getName(), cfg.getCacheMode());
            }
        }
        return cacheModes;
    }

    public boolean pointInTimeRecoveryEnabled() {
        return this.pointInTimeRecoveryEnabled;
    }

    public boolean singleCopyFlagSupported() {
        return this.protocol >= 7;
    }

    public boolean isSingleCopied() {
        return this.singleCopied;
    }

    public boolean isCorrect() {
        return this.id > 0L && this.initiatorNodeId != null && this.pageSize >= 1024 && (this.pageSize & this.pageSize - 1) == 0 && this.topVer != null && this.topology != null && this.cacheMetas != null && !this.cacheMetas.isEmpty();
    }

    public void prepareMarshal() throws IgniteCheckedException {
        for (CacheSnapshotMetadata cacheSnapshotMetadata : this.cacheMetas.values()) {
            cacheSnapshotMetadata.prepareMarshal();
        }
    }

    public void finishUnmarshal(ClassLoader ldr, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses) throws IgniteCheckedException {
        for (CacheSnapshotMetadata cacheSnapshotMetadata : this.cacheMetas.values()) {
            cacheSnapshotMetadata.finishUnmarshal(ldr, c, ignoreMissedClasses);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(11);
        out.writeLong(this.id);
        U.writeUuid((DataOutput)out, (UUID)this.initiatorNodeId);
        out.writeInt(this.pageSize);
        out.writeBoolean(this.fullSnapshot);
        out.writeObject(this.topVer);
        U.writeCollection((ObjectOutput)out, this.topology);
        U.writeString((DataOutput)out, (String)this.msg);
        U.writeMap((ObjectOutput)out, this.cacheMetas);
        U.writeMap((ObjectOutput)out, this.marshallerMappingsMap);
        U.writeMap((ObjectOutput)out, this.sizeOnlyDataInPages);
        U.writeMap((ObjectOutput)out, this.sizeInPages);
        U.writeMap((ObjectOutput)out, this.binaryMetadataMap);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bOut);
        U.writeMap((ObjectOutput)os, this.walPoints);
        os.writeObject(this.baselineTop);
        os.flush();
        out.writeObject(bOut.toByteArray());
        out.writeBoolean(this.pointInTimeRecoveryEnabled);
        out.writeByte(this.compressionOption.ordinal());
        out.writeByte(this.compressionLevel);
        out.writeBoolean(this.singleCopied);
        out.writeBoolean(this.exchangelessSnapshot);
        out.writeObject((Object)this.encryptionOptions);
        out.writeBoolean(this.forcedFullSnapshot);
        U.writeMap((ObjectOutput)out, this.consistentCutMetas);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.protocol = in.readInt();
        this.id = in.readLong();
        this.initiatorNodeId = U.readUuid((DataInput)in);
        this.pageSize = in.readInt();
        this.fullSnapshot = in.readBoolean();
        this.topVer = (AffinityTopologyVersion)in.readObject();
        this.topology = U.readCollection((ObjectInput)in);
        this.msg = U.readString((DataInput)in);
        this.cacheMetas = U.readMap((ObjectInput)in);
        this.marshallerMappingsMap = U.readMap((ObjectInput)in);
        this.sizeOnlyDataInPages = U.readMap((ObjectInput)in);
        this.sizeInPages = U.readMap((ObjectInput)in);
        this.binaryMetadataMap = U.readMap((ObjectInput)in);
        if (this.protocol >= 3) {
            byte[] bytes = (byte[])in.readObject();
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ObjectInputStream inp = new ObjectInputStream(bIn);
            this.walPoints = U.readMap((ObjectInput)inp);
            if (this.protocol >= 4) {
                this.baselineTop = (BaselineTopology)inp.readObject();
                this.pointInTimeRecoveryEnabled = in.readBoolean();
                if (this.protocol >= 5) {
                    this.compressionOption = CompressionOption.fromOrdinal(in.readByte());
                    if (this.protocol >= 6) {
                        this.compressionLevel = in.readByte();
                    }
                }
            }
        }
        if (this.protocol >= 7) {
            this.singleCopied = in.readBoolean();
        }
        if (this.protocol >= 8) {
            this.exchangelessSnapshot = in.readBoolean();
        }
        if (this.protocol >= 9) {
            this.encryptionOptions = (SnapshotEncryptionOptions)((Object)in.readObject());
        }
        if (this.protocol >= 10) {
            this.forcedFullSnapshot = in.readBoolean();
        }
        if (this.protocol >= 11) {
            this.consistentCutMetas = U.readMap((ObjectInput)in);
        }
    }

    public SnapshotMetadata toOldMetadata() {
        return new SnapshotMetadata(this.id(), this.initiatorNodeId(), this.pageSize(), this.typeMap(), this.fullSnapshot(), this.topologyVersion(), this.topology(), this.cacheGroupsMetadata(), this.sizeOnlyDataInPages, this.sizeInPages, this.message());
    }

    public Map<String, Integer> cacheNamesWithGroups() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<Integer, CacheSnapshotMetadata> e : this.cacheMetas.entrySet()) {
            for (String name : e.getValue().cacheNames()) {
                result.put(name, e.getKey());
            }
        }
        return result;
    }

    public String toString() {
        return S.toString(SnapshotMetadataV2.class, (Object)this);
    }
}

