/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;

public class SnapshotDescriptorV2
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected Map<Object, Map<String, String>> nodeAttributes;
    @GridToStringInclude
    protected SnapshotMetadataV2 snapshotMetadata;

    protected SnapshotDescriptorV2() {
    }

    public SnapshotDescriptorV2(SnapshotMetadataV2 snapshotMetadata) {
        this.nodeAttributes = new HashMap<Object, Map<String, String>>();
        this.snapshotMetadata = snapshotMetadata;
    }

    public SnapshotDescriptorV2(SnapshotMetadataV2 snapshotMetadata, Map<Object, Map<String, String>> mutablePart) {
        this.snapshotMetadata = snapshotMetadata;
        this.nodeAttributes = mutablePart;
    }

    public Map<Object, Map<String, String>> nodeAttributes() {
        return this.nodeAttributes;
    }

    public SnapshotMetadataV2 snapshotMetadata() {
        return this.snapshotMetadata;
    }

    public void addAttribute(Object consistentId, String name, String val) {
        Map<String, String> map = this.nodeAttributes.get(consistentId);
        if (map == null) {
            map = new HashMap<String, String>();
            this.nodeAttributes.put(consistentId, map);
        }
        map.put(name, val);
    }

    public SnapshotDescriptorV2 merge(SnapshotDescriptorV2 detail) throws IgniteCheckedException {
        this.nodeAttributes.putAll(detail.nodeAttributes);
        this.snapshotMetadata = this.snapshotMetadata.merge(detail.snapshotMetadata);
        return this;
    }

    public SnapshotDescriptorV2 merge(SnapshotMetadataV2 metadata) throws IgniteCheckedException {
        this.snapshotMetadata = this.snapshotMetadata.merge(metadata);
        return this;
    }

    public String toString() {
        return S.toString(SnapshotDescriptorV2.class, (Object)this);
    }
}

