/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.persistentstore.SnapshotChainMode;

public class SnapshotUpdateOperationParameters
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private SnapshotChainMode chainMode = SnapshotChainMode.DEFAULT;
    private boolean deleteSources;
    private boolean singleFileCopy;
    private Integer parallelismLevel;

    public SnapshotUpdateOperationParameters() {
    }

    public SnapshotUpdateOperationParameters(SnapshotChainMode chainMode) {
        this(chainMode, false, false, null);
    }

    public SnapshotUpdateOperationParameters(SnapshotChainMode chainMode, boolean deleteSources, boolean singleFileCopy, Integer parallelismLevel) {
        this.chainMode = chainMode;
        this.deleteSources = deleteSources;
        this.singleFileCopy = singleFileCopy;
        this.parallelismLevel = parallelismLevel;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    public SnapshotChainMode chainMode() {
        return this.chainMode;
    }

    public boolean removeSources() {
        return this.deleteSources;
    }

    public boolean singleFileCopy() {
        return this.singleFileCopy;
    }

    public Integer parallelismLevel() {
        return this.parallelismLevel;
    }

    public void writeExternalData(ObjectOutput out) throws IOException {
        out.writeByte(this.chainMode.ordinal());
        out.writeBoolean(this.deleteSources);
        out.writeBoolean(this.singleFileCopy);
        out.writeInt(null == this.parallelismLevel ? -1 : this.parallelismLevel);
    }

    public void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainMode = SnapshotChainMode.fromOrdinal(in.readByte());
        this.deleteSources = in.readBoolean();
        this.singleFileCopy = in.readBoolean();
        if (protoVer > 1) {
            int parralelismLevel0 = in.readInt();
            this.parallelismLevel = parralelismLevel0 <= 0 ? null : Integer.valueOf(parralelismLevel0);
        }
    }

    public String toString() {
        return S.toString(SnapshotUpdateOperationParameters.class, (Object)((Object)this));
    }

    public static class Builder {
        private SnapshotChainMode mode;
        private Boolean deleteSources;
        private Boolean singleFileCopy;
        private Integer parralelismLevel;

        public Builder withChainMode(SnapshotChainMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withDeleteSources(Boolean deleteSources) {
            this.deleteSources = deleteSources;
            return this;
        }

        public Builder withSingleFileCopy(Boolean singleFileCopy) {
            this.singleFileCopy = singleFileCopy;
            return this;
        }

        public Builder withParralelismLevel(Integer parralelismLevel) {
            this.parralelismLevel = parralelismLevel;
            return this;
        }

        public SnapshotUpdateOperationParameters build() {
            return new SnapshotUpdateOperationParameters(this.mode, Boolean.TRUE == this.deleteSources, Boolean.TRUE == this.singleFileCopy, this.parralelismLevel);
        }
    }
}

