/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.conflict;

import com.sun.istack.Nullable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.gridgain.grid.cache.conflict.CacheConflictMode;
import org.gridgain.grid.cache.conflict.CacheConflictResolver;
import org.gridgain.grid.internal.processors.cache.conflict.CacheConflictContextImpl;
import org.gridgain.grid.internal.processors.cache.conflict.CacheVersionConflictResolverImpl;

public class CacheConflictResolverWrapper
extends CacheVersionConflictResolverImpl {
    private final CacheConflictMode mode;
    private final CacheConflictResolver rslvr;

    public CacheConflictResolverWrapper(CacheConflictMode mode, @Nullable CacheConflictResolver rslvr) {
        assert (mode != null);
        this.mode = mode;
        this.rslvr = rslvr;
    }

    @Override
    protected <K, V> void resolve0(GridCacheVersionConflictContext<K, V> ctx, GridCacheVersionedEntryEx<K, V> oldEntry, GridCacheVersionedEntryEx<K, V> newEntry, boolean atomicVerComp) throws IgniteCheckedException {
        if (newEntry.dataCenterId() != oldEntry.dataCenterId() || this.mode == CacheConflictMode.ALWAYS) {
            assert (this.mode == CacheConflictMode.ALWAYS && this.rslvr != null || this.mode == CacheConflictMode.AUTO) : "Invalid resolver configuration (must be checked on startup) [mode=" + (Object)((Object)this.mode) + ", rslvr=" + this.rslvr + ']';
            if (this.rslvr != null) {
                this.rslvr.resolve(new CacheConflictContextImpl<K, V>(ctx));
                ctx.manualResolve();
            } else {
                ctx.useNew();
            }
            return;
        }
        super.resolve0(ctx, oldEntry, newEntry, atomicVerComp);
    }
}

