/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.gridgain.grid.configuration.InteropConfiguration;

public class InteropUtils {
    public static final int OP_DR_ENTRY_FILTER_CREATE = 2;
    public static final int OP_DR_ENTRY_FILTER_APPLY = 3;
    public static final int OP_DR_ENTRY_FILTER_DESTROY = 4;
    private static final String MTHD_CFG_COPY = "copy";

    public static <T extends InteropConfiguration> T copyConfiguration(T cfg) {
        if (cfg == null) {
            return null;
        }
        try {
            return (T)((InteropConfiguration)U.invoke(cfg.getClass(), cfg, (String)MTHD_CFG_COPY, (Object[])new Object[0]));
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException("Failed to copy interop configuration: " + cfg);
        }
    }

    public static void writeSubject(SecuritySubject subj, BinaryRawWriterEx writer) {
        assert (subj != null);
        writer.writeUuid(subj.id());
        writer.writeByte((byte)subj.type().ordinal());
        writer.writeObject(subj.login());
        if (subj.address() != null) {
            writer.writeBoolean(true);
            writer.writeString(subj.address().getHostString());
            writer.writeInt(subj.address().getPort());
        } else {
            writer.writeBoolean(false);
        }
        if (subj.permissions() != null) {
            writer.writeBoolean(true);
            InteropUtils.writePermissionSet(subj.permissions(), writer);
        } else {
            writer.writeBoolean(false);
        }
    }

    private static void writePermissionSet(SecurityPermissionSet permSet, BinaryRawWriterEx writer) {
        writer.writeBoolean(permSet.defaultAllowAll());
        InteropUtils.writePermissions(permSet.taskPermissions(), writer);
        InteropUtils.writePermissions(permSet.cachePermissions(), writer);
        InteropUtils.writePermissions(permSet.systemPermissions(), writer);
    }

    private static void writePermissions(Map<String, Collection<SecurityPermission>> perms, BinaryRawWriterEx writer) {
        writer.writeInt(perms.size());
        for (Map.Entry<String, Collection<SecurityPermission>> e : perms.entrySet()) {
            writer.writeString(e.getKey());
            InteropUtils.writePermissions(e.getValue(), writer);
        }
    }

    private static void writePermissions(Collection<SecurityPermission> perms, BinaryRawWriterEx writer) {
        if (perms == null) {
            writer.writeInt(-1);
        } else {
            writer.writeInt(perms.size());
            for (SecurityPermission p : perms) {
                writer.writeByte((byte)p.ordinal());
            }
        }
    }

    private InteropUtils() {
    }
}

