/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.configuration;

import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.InteropConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.interop.InteropUtils;
import org.gridgain.grid.security.Authenticator;

public class GridGainConfiguration
implements PluginConfiguration {
    public static final int DFLT_DR_THREAD_CNT = 4;
    public static final int DFLT_DR_STATE_TRANSFER_THREAD_CNT = 4;
    public static final int DFLT_DR_IST_POOL_THREAD_CNT = 4;
    public static final int DFLT_DR_MGMT_THREAD_CNT = 4;
    public static final int DFLT_DR_STREAMER_THREAD_CNT = IgniteConfiguration.DFLT_PUBLIC_THREAD_CNT;
    public static final int DFLT_FST_BATCH_SND_SIZE_BYTES = 0x800000;
    public static final int DFLT_BATCH_SND_SIZE_BYTES = 0x100000;
    public static final boolean DFLT_ROLLING_UPGRADE_ENABLED = false;
    private byte dataCenterId;
    private InteropConfiguration interopCfg;
    private DrReceiverConfiguration drRcvCfg;
    private DrSenderConfiguration drSndCfg;
    private SnapshotConfiguration snapshotCfg;
    private String licUrl;
    private Authenticator authenticator;
    private SecurityCredentialsProvider securityCred;
    private boolean rollingUpdatesEnabled = false;
    private int drPoolSize = 4;
    private int drStreamerPoolSize = DFLT_DR_STREAMER_THREAD_CNT;
    private int drStateTransferPoolSize = 4;
    private int incrementalDrPoolSize = 4;
    private int drMgmtPoolSize = 4;
    private boolean drUseCacheNames;
    private int fstBatchSndSizeBytes = 0x800000;
    private int batchSndSizeBytes = 0x100000;
    private int securityPoolSize = IgniteConfiguration.DFLT_PUBLIC_THREAD_CNT;

    public GridGainConfiguration() {
    }

    public GridGainConfiguration(GridGainConfiguration cfg) {
        this.authenticator = cfg.getAuthenticator();
        this.dataCenterId = cfg.getDataCenterId();
        this.drRcvCfg = cfg.getDrReceiverConfiguration();
        this.drSndCfg = cfg.getDrSenderConfiguration();
        this.drMgmtPoolSize = cfg.getDrManagementThreadPoolSize();
        this.drPoolSize = cfg.getDrThreadPoolSize();
        this.drStateTransferPoolSize = cfg.getDrStateTransferThreadPoolSize();
        this.incrementalDrPoolSize = cfg.getIncrementalDrPoolSize();
        this.drStreamerPoolSize = cfg.getDrStreamerThreadPoolSize();
        this.drUseCacheNames = cfg.isDrUseCacheNames();
        this.batchSndSizeBytes = cfg.getBatchSendSizeBytes();
        this.fstBatchSndSizeBytes = cfg.getStateTransferBatchSendSizeBytes();
        this.interopCfg = InteropUtils.copyConfiguration(cfg.interopCfg);
        this.snapshotCfg = cfg.getSnapshotConfiguration();
        this.licUrl = cfg.getLicenseUrl();
        this.rollingUpdatesEnabled = cfg.isRollingUpdatesEnabled();
        this.securityCred = cfg.getSecurityCredentialsProvider();
    }

    public byte getDataCenterId() {
        return this.dataCenterId;
    }

    public GridGainConfiguration setDataCenterId(byte dataCenterId) {
        this.dataCenterId = dataCenterId;
        return this;
    }

    public InteropConfiguration getInteropConfiguration() {
        return this.interopCfg;
    }

    public GridGainConfiguration setInteropConfiguration(InteropConfiguration interopCfg) {
        this.interopCfg = interopCfg;
        return this;
    }

    public DrReceiverConfiguration getDrReceiverConfiguration() {
        return this.drRcvCfg;
    }

    public GridGainConfiguration setDrReceiverConfiguration(DrReceiverConfiguration drRcvHubCfg) {
        this.drRcvCfg = drRcvHubCfg;
        return this;
    }

    public DrSenderConfiguration getDrSenderConfiguration() {
        return this.drSndCfg;
    }

    public GridGainConfiguration setDrSenderConfiguration(DrSenderConfiguration drSndHubCfg) {
        this.drSndCfg = drSndHubCfg;
        return this;
    }

    public SnapshotConfiguration getSnapshotConfiguration() {
        return this.snapshotCfg;
    }

    public GridGainConfiguration setSnapshotConfiguration(SnapshotConfiguration snapshotCfg) {
        this.snapshotCfg = snapshotCfg;
        return this;
    }

    public String getLicenseUrl() {
        return this.licUrl;
    }

    public GridGainConfiguration setLicenseUrl(String licUrl) {
        this.licUrl = licUrl;
        return this;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public GridGainConfiguration setAuthenticator(Authenticator auth) {
        this.authenticator = auth;
        return this;
    }

    public SecurityCredentialsProvider getSecurityCredentialsProvider() {
        return this.securityCred;
    }

    public GridGainConfiguration setSecurityCredentialsProvider(SecurityCredentialsProvider securityCred) {
        this.securityCred = securityCred;
        return this;
    }

    public boolean isRollingUpdatesEnabled() {
        return this.rollingUpdatesEnabled;
    }

    public GridGainConfiguration setRollingUpdatesEnabled(boolean rollingUpdatesEnabled) {
        this.rollingUpdatesEnabled = rollingUpdatesEnabled;
        return this;
    }

    public boolean isDrUseCacheNames() {
        return this.drUseCacheNames;
    }

    public GridGainConfiguration setDrUseCacheNames(boolean drUseCacheNames) {
        this.drUseCacheNames = drUseCacheNames;
        return this;
    }

    public int getDrThreadPoolSize() {
        return this.drPoolSize;
    }

    public GridGainConfiguration setDrThreadPoolSize(int poolSize) {
        this.drPoolSize = poolSize;
        return this;
    }

    public int getDrStateTransferThreadPoolSize() {
        return this.drStateTransferPoolSize;
    }

    public GridGainConfiguration setDrStateTransferThreadPoolSize(int poolSize) {
        this.drStateTransferPoolSize = poolSize;
        return this;
    }

    public int getIncrementalDrPoolSize() {
        return this.incrementalDrPoolSize;
    }

    public GridGainConfiguration setIncrementalDrPoolSize(int poolSize) {
        this.incrementalDrPoolSize = poolSize;
        return this;
    }

    public int getDrManagementThreadPoolSize() {
        return this.drMgmtPoolSize;
    }

    public GridGainConfiguration setDrManagementThreadPoolSize(int poolSize) {
        this.drMgmtPoolSize = poolSize;
        return this;
    }

    public int getDrStreamerThreadPoolSize() {
        return this.drStreamerPoolSize;
    }

    public GridGainConfiguration setDrStreamerThreadPoolSize(int poolSize) {
        this.drStreamerPoolSize = poolSize;
        return this;
    }

    public int getStateTransferBatchSendSizeBytes() {
        return this.fstBatchSndSizeBytes;
    }

    public GridGainConfiguration setStateTransferBatchSendSizeBytes(int batchSndSizeBytes) {
        this.fstBatchSndSizeBytes = batchSndSizeBytes;
        return this;
    }

    public int getBatchSendSizeBytes() {
        return this.batchSndSizeBytes;
    }

    public GridGainConfiguration setBatchSendSizeBytes(int batchSndSizeBytes) {
        this.batchSndSizeBytes = batchSndSizeBytes;
        return this;
    }

    public int getSecurityThreadPoolSize() {
        return this.securityPoolSize;
    }

    public GridGainConfiguration setSecurityThreadPoolSize(int poolSize) {
        this.securityPoolSize = poolSize;
        return this;
    }

    public String toString() {
        return S.toString(GridGainConfiguration.class, (Object)this);
    }
}

