/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueEnumBase
extends Value {
    private final String label;
    private final int ordinal;

    protected ValueEnumBase(String label, int ordinal) {
        this.label = label;
        this.ordinal = ordinal;
    }

    @Override
    public Value add(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).add(iv);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        return Integer.compare(this.getInt(), v.getInt());
    }

    @Override
    public Value divide(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).divide(iv);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueEnumBase && this.getInt() == ((ValueEnumBase)other).getInt();
    }

    public static ValueEnumBase get(String label, int ordinal) {
        return new ValueEnumBase(label, ordinal);
    }

    @Override
    public int getInt() {
        return this.ordinal;
    }

    @Override
    public long getLong() {
        return this.ordinal;
    }

    @Override
    public Object getObject() {
        return this.label;
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.ordinal);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return StringUtils.quoteStringSQL(builder, this.label);
    }

    @Override
    public String getString() {
        return this.label;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_ENUM_UNDEFINED;
    }

    @Override
    public int getValueType() {
        return 25;
    }

    @Override
    public int getMemory() {
        return 120;
    }

    @Override
    public int hashCode() {
        int results = 31;
        results += this.getString().hashCode();
        return results += this.getInt();
    }

    @Override
    public Value modulus(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).modulus(iv);
    }

    @Override
    public Value multiply(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).multiply(iv);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.ordinal);
    }

    @Override
    public Value subtract(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).subtract(iv);
    }

    @Override
    protected Value convertTo(int targetType, Mode mode, Object column, ExtTypeInfo extTypeInfo) {
        if (targetType == 25) {
            return extTypeInfo.cast(this);
        }
        return super.convertTo(targetType, mode, column, extTypeInfo);
    }
}

