/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.geometry.EWKTUtils;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueGeometry;

public final class ExtTypeInfoGeometry
extends ExtTypeInfo {
    private final int type;
    private final Integer srid;

    private static String toSQL(int type, Integer srid) {
        if (type == 0 && srid == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        if (type == 0) {
            builder.append("GEOMETRY");
        } else {
            builder.append(EWKTUtils.formatGeometryTypeAndDimensionSystem(type));
        }
        if (srid != null) {
            builder.append(", ").append(srid);
        }
        return builder.append(')').toString();
    }

    public ExtTypeInfoGeometry(int type, Integer srid) {
        this.type = type;
        this.srid = srid;
    }

    @Override
    public Value cast(Value value) {
        if (value.getValueType() != 22) {
            value = value.convertTo(22);
        }
        ValueGeometry g = (ValueGeometry)value;
        if (this.type != 0 && g.getTypeAndDimensionSystem() != this.type || this.srid != null && g.getSRID() != this.srid.intValue()) {
            throw DbException.get(23513, ExtTypeInfoGeometry.toSQL(g.getTypeAndDimensionSystem(), g.getSRID()) + " <> " + this.toString());
        }
        return g;
    }

    @Override
    public String getCreateSQL() {
        return ExtTypeInfoGeometry.toSQL(this.type, this.srid);
    }
}

