/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.db.MVDelegateIndex;
import org.gridgain.internal.h2.mvstore.db.MVIndex;
import org.gridgain.internal.h2.mvstore.db.MVPrimaryIndex;
import org.gridgain.internal.h2.mvstore.db.MVSecondaryIndex;
import org.gridgain.internal.h2.mvstore.db.MVSpatialIndex;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.RegularTable;
import org.gridgain.internal.h2.util.DebuggingThreadLocal;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.Utils;

public class MVTable
extends RegularTable {
    public static final DebuggingThreadLocal<String> WAITING_FOR_LOCK;
    public static final DebuggingThreadLocal<ArrayList<String>> EXCLUSIVE_LOCKS;
    public static final DebuggingThreadLocal<ArrayList<String>> SHARED_LOCKS;
    private static final String NO_EXTRA_INFO = "";
    private MVPrimaryIndex primaryIndex;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private final AtomicLong lastModificationId = new AtomicLong();
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final AtomicInteger changesUntilAnalyze;
    private int nextAnalyze;
    private final MVTableEngine.Store store;
    private final TransactionStore transactionStore;

    public MVTable(CreateTableData data, MVTableEngine.Store store) {
        super(data);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.changesUntilAnalyze = this.nextAnalyze <= 0 ? null : new AtomicInteger(this.nextAnalyze);
        this.store = store;
        this.transactionStore = store.getTransactionStore();
        this.traceLock = this.database.getTrace(7);
        this.primaryIndex = new MVPrimaryIndex(this.database, this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        int lockMode = this.database.getLockMode();
        if (lockMode == 0) {
            return false;
        }
        if (!forceLockEvenInMvcc) {
            if (exclusive) {
                exclusive = false;
            } else if (this.lockExclusiveSession == null) {
                return false;
            }
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (!exclusive && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        Object object = this.getLockSyncObject();
        synchronized (object) {
            if (!exclusive && this.lockSharedSessions.containsKey(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                WAITING_FOR_LOCK.set(this.getName());
            }
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, lockMode, exclusive);
            }
            finally {
                session.setWaitForLock(null, null);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    WAITING_FOR_LOCK.remove();
                }
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private Object getLockSyncObject() {
        if (this.database.isMultiThreaded()) {
            return this;
        }
        return this.database;
    }

    private void doLock1(Session session, int lockMode, boolean exclusive) {
        this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_REQUESTING_FOR, NO_EXTRA_INFO);
        long max = 0L;
        boolean checkDeadlock = false;
        while (this.waitingSessions.getFirst() != session || !this.doLock2(session, lockMode, exclusive)) {
            if (checkDeadlock) {
                ArrayList<Session> sessions = this.checkDeadlock(session, null, null);
                if (sessions != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(sessions, exclusive));
                }
            } else {
                checkDeadlock = true;
            }
            long now = System.nanoTime();
            if (max == 0L) {
                max = now + TimeUnit.MILLISECONDS.toNanos(session.getLockTimeout());
            } else if (now >= max) {
                this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_TIMEOUT_AFTER, NO_EXTRA_INFO + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long sleep;
                this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_WAITING_FOR, NO_EXTRA_INFO);
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long free = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long free2 = Runtime.getRuntime().freeMemory();
                        if (free == free2) break;
                    }
                }
                if ((sleep = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(max - now))) == 0L) {
                    sleep = 1L;
                }
                this.getLockSyncObject().wait(sleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session, int lockMode, boolean exclusive) {
        if (this.lockExclusiveSession == null) {
            if (exclusive) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_ADDED_FOR, NO_EXTRA_INFO);
                    session.addLock(this);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_ADD_UPGRADED_FOR, NO_EXTRA_INFO);
                    this.lockExclusiveSession = session;
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        if (EXCLUSIVE_LOCKS.get() == null) {
                            EXCLUSIVE_LOCKS.set(new ArrayList());
                        }
                        EXCLUSIVE_LOCKS.get().add(this.getName());
                    }
                    return true;
                }
            } else {
                if (this.lockSharedSessions.putIfAbsent(session, session) == null) {
                    this.traceLock(session, exclusive, TraceLockEvent.TRACE_LOCK_OK, NO_EXTRA_INFO);
                    session.addLock(this);
                    if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                        ArrayList<String> list = SHARED_LOCKS.get();
                        if (list == null) {
                            list = new ArrayList();
                            SHARED_LOCKS.set(list);
                        }
                        list.add(this.getName());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void traceLock(Session session, boolean exclusive, TraceLockEvent eventEnum, String extraInfo) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3} {4}", session.getId(), exclusive ? "exclusive write lock" : "shared read lock", eventEnum.getEventText(), this.getName(), extraInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session s) {
        if (this.database != null) {
            boolean wasLocked = this.lockExclusiveSession == s;
            this.traceLock(s, wasLocked, TraceLockEvent.TRACE_LOCK_UNLOCK, NO_EXTRA_INFO);
            if (wasLocked) {
                this.lockSharedSessions.remove(s);
                this.lockExclusiveSession = null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && EXCLUSIVE_LOCKS.get() != null) {
                    EXCLUSIVE_LOCKS.get().remove(this.getName());
                }
            } else {
                boolean bl = wasLocked = this.lockSharedSessions.remove(s) != null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && SHARED_LOCKS.get() != null) {
                    SHARED_LOCKS.get().remove(this.getName());
                }
            }
            if (wasLocked && !this.waitingSessions.isEmpty()) {
                Object lockSyncObject;
                Object object = lockSyncObject = this.getLockSyncObject();
                synchronized (object) {
                    lockSyncObject.notifyAll();
                }
            }
        }
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.primaryIndex.getRow(session, key);
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        BaseIndex index;
        int mainIndexColumn;
        boolean isSessionTemporary;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn c : cols) {
                Column column = c.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        int n = mainIndexColumn = this.primaryIndex.getMainIndexColumn() != -1 ? -1 : MVTable.getMainIndexColumn(indexType, cols);
        if (this.database.isStarting()) {
            if (this.transactionStore.hasMap("index." + indexId)) {
                mainIndexColumn = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            mainIndexColumn = -1;
        }
        if (mainIndexColumn != -1) {
            this.primaryIndex.setMainIndexColumn(mainIndexColumn);
            index = new MVDelegateIndex(this, indexId, indexName, this.primaryIndex, indexType);
        } else {
            index = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), this, indexId, indexName, cols, indexType) : new MVSecondaryIndex(session.getDatabase(), this, indexId, indexName, cols, indexType);
        }
        if (index.needRebuild()) {
            this.rebuildIndex(session, (MVIndex)((Object)index), indexName);
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private void rebuildIndex(Session session, MVIndex index, String indexName) {
        try {
            if (session.getDatabase().getStore() == null || index instanceof MVSpatialIndex) {
                this.rebuildIndexBuffered(session, index);
            } else {
                this.rebuildIndexBlockMerge(session, index);
            }
        }
        catch (DbException e) {
            this.getSchema().freeUniqueName(indexName);
            try {
                index.remove(session);
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not remove index");
                throw e2;
            }
            throw e;
        }
    }

    private void rebuildIndexBlockMerge(Session session, MVIndex index) {
        long remaining;
        if (index instanceof MVSpatialIndex) {
            this.rebuildIndexBuffered(session, index);
        }
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        MVTableEngine.Store store = session.getDatabase().getStore();
        int bufferSize = this.database.getMaxMemoryRows() / 2;
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ":" + index.getName();
        int t = MathUtils.convertLongToInt(total);
        ArrayList<String> bufferNames = Utils.newSmallArrayList();
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t);
            if (buffer.size() >= bufferSize) {
                MVTable.sortRows(buffer, index);
                String mapName = store.nextTemporaryMapName();
                index.addRowsToBuffer(buffer, mapName);
                bufferNames.add(mapName);
                buffer.clear();
            }
            --remaining;
        }
        MVTable.sortRows(buffer, index);
        if (!bufferNames.isEmpty()) {
            String mapName = store.nextTemporaryMapName();
            index.addRowsToBuffer(buffer, mapName);
            bufferNames.add(mapName);
            buffer.clear();
            index.addBufferedRows(bufferNames);
        } else {
            MVTable.addRowsToIndex(session, buffer, index);
        }
        if (remaining != 0L) {
            DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
        }
    }

    private void rebuildIndexBuffered(Session session, Index index) {
        long remaining;
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        int bufferSize = (int)Math.min(total, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ":" + index.getName();
        int t = MathUtils.convertLongToInt(total);
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, MathUtils.convertLongToInt(i++), t);
            if (buffer.size() >= bufferSize) {
                MVTable.addRowsToIndex(session, buffer, index);
            }
            --remaining;
        }
        MVTable.addRowsToIndex(session, buffer, index);
        if (remaining != 0L) {
            DbException.throwInternalError("rowcount remaining=" + remaining + " " + this.getName());
        }
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.syncLastModificationIdWithDatabase();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        if (this.changesUntilAnalyze != null) {
            this.changesUntilAnalyze.set(this.nextAnalyze);
        }
    }

    @Override
    public void addRow(Session session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.add(session, row);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void updateRow(Session session, Row oldRow, Row newRow) {
        newRow.setKey(oldRow.getKey());
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.update(session, oldRow, newRow);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public Row lockRow(Session session, Row row) {
        return this.primaryIndex.lockRow(session, row);
    }

    private void analyzeIfRequired(Session session) {
        if (this.changesUntilAnalyze != null && this.changesUntilAnalyze.decrementAndGet() == 0) {
            if (this.nextAnalyze <= 0x3FFFFFFF) {
                this.nextAnalyze *= 2;
            }
            this.changesUntilAnalyze.set(this.nextAnalyze);
            session.markTableForAnalyze(this);
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.primaryIndex;
    }

    @Override
    public Index getUniqueIndex() {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId.get();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        this.database.getStore().removeTable(this);
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            index.remove(session);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        this.primaryIndex.remove(session);
        this.indexes.clear();
        if (SysProperties.CHECK) {
            for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)obj;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.close(session);
        this.invalidate();
    }

    @Override
    public long getRowCount(Session session) {
        return this.primaryIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.primaryIndex.getRowCountApproximation(ses);
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    Transaction getTransactionBegin() {
        return this.transactionStore.begin();
    }

    @Override
    public boolean isMVStore() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.syncLastModificationIdWithDatabase();
        }
    }

    private void syncLastModificationIdWithDatabase() {
        long currentId;
        long nextModificationDataId = this.database.getNextModificationDataId();
        while (nextModificationDataId > (currentId = this.lastModificationId.get()) && !this.lastModificationId.compareAndSet(currentId, nextModificationDataId)) {
        }
    }

    DbException convertException(IllegalStateException e) {
        int errorCode = DataUtils.getErrorCode(e.getMessage());
        if (errorCode == 101) {
            throw DbException.get(90131, e, this.getName());
        }
        if (errorCode == 105) {
            throw DbException.get(40001, e, this.getName());
        }
        return this.store.convertIllegalStateException(e);
    }

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            WAITING_FOR_LOCK = new DebuggingThreadLocal();
            EXCLUSIVE_LOCKS = new DebuggingThreadLocal();
            SHARED_LOCKS = new DebuggingThreadLocal();
        } else {
            WAITING_FOR_LOCK = null;
            EXCLUSIVE_LOCKS = null;
            SHARED_LOCKS = null;
        }
    }

    private static enum TraceLockEvent {
        TRACE_LOCK_OK("ok"),
        TRACE_LOCK_WAITING_FOR("waiting for"),
        TRACE_LOCK_REQUESTING_FOR("requesting for"),
        TRACE_LOCK_TIMEOUT_AFTER("timeout after "),
        TRACE_LOCK_UNLOCK("unlock"),
        TRACE_LOCK_ADDED_FOR("added for"),
        TRACE_LOCK_ADD_UPGRADED_FOR("add (upgraded) for ");

        private final String eventText;

        private TraceLockEvent(String eventText) {
            this.eventText = eventText;
        }

        public String getEventText() {
            return this.eventText;
        }
    }
}

