/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.DbObjectBase;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.StringUtils;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap<Role, Right> grantedRoles;
    private HashMap<DbObject, Right> grantedRights;

    protected RightOwner(Database database, int id, String name, int traceModuleId) {
        super(database, id, StringUtils.toUpperEnglish(name), traceModuleId);
    }

    @Override
    public void rename(String newName) {
        super.rename(StringUtils.toUpperEnglish(newName));
    }

    public boolean isRoleGranted(Role grantedRole) {
        if (grantedRole == this) {
            return true;
        }
        if (this.grantedRoles != null) {
            for (Role role : this.grantedRoles.keySet()) {
                if (role == grantedRole) {
                    return true;
                }
                if (!role.isRoleGranted(grantedRole)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRightGrantedRecursive(Table table, int rightMask) {
        if (this.grantedRights != null) {
            Right right;
            if (table != null && (right = this.grantedRights.get(table.getSchema())) != null && (right.getRightMask() & rightMask) == rightMask) {
                return true;
            }
            right = this.grantedRights.get(table);
            if (right != null && (right.getRightMask() & rightMask) == rightMask) {
                return true;
            }
        }
        if (this.grantedRoles != null) {
            for (RightOwner rightOwner : this.grantedRoles.keySet()) {
                if (!rightOwner.isRightGrantedRecursive(table, rightMask)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(DbObject object, Right right) {
        if (this.grantedRights == null) {
            this.grantedRights = new HashMap();
        }
        this.grantedRights.put(object, right);
    }

    void revokeRight(DbObject object) {
        if (this.grantedRights == null) {
            return;
        }
        this.grantedRights.remove(object);
        if (this.grantedRights.size() == 0) {
            this.grantedRights = null;
        }
    }

    public void grantRole(Role role, Right right) {
        if (this.grantedRoles == null) {
            this.grantedRoles = new HashMap();
        }
        this.grantedRoles.put(role, right);
    }

    void revokeRole(Role role) {
        if (this.grantedRoles == null) {
            return;
        }
        Right right = this.grantedRoles.get(role);
        if (right == null) {
            return;
        }
        this.grantedRoles.remove(role);
        if (this.grantedRoles.size() == 0) {
            this.grantedRoles = null;
        }
    }

    public void revokeTemporaryRightsOnRoles() {
        if (this.grantedRoles == null) {
            return;
        }
        ArrayList<Role> rolesToRemove = new ArrayList<Role>();
        for (Map.Entry<Role, Right> currentEntry : this.grantedRoles.entrySet()) {
            if (!currentEntry.getValue().isTemporary() && currentEntry.getValue().isValid()) continue;
            rolesToRemove.add(currentEntry.getKey());
        }
        for (Role currentRoleToRemove : rolesToRemove) {
            this.revokeRole(currentRoleToRemove);
        }
    }

    public Right getRightForObject(DbObject object) {
        if (this.grantedRights == null) {
            return null;
        }
        return this.grantedRights.get(object);
    }

    public Right getRightForRole(Role role) {
        if (this.grantedRoles == null) {
            return null;
        }
        return this.grantedRoles.get(role);
    }
}

