/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.Delete;
import org.gridgain.internal.h2.command.dml.Insert;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.Update;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.RowImpl;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;

public class MergeUsing
extends Prepared {
    Table targetTable;
    TableFilter targetTableFilter;
    private Query query;
    TableFilter sourceTableFilter;
    Expression onCondition;
    private ArrayList<When> when = Utils.newSmallArrayList();
    private String queryAlias;
    private int countUpdatedRows;
    private Select targetMatchQuery;
    private final HashMap<Value, Integer> targetRowidsRemembered = new HashMap();
    private int sourceQueryRowNumber;

    public MergeUsing(Session session, TableFilter targetTableFilter) {
        super(session);
        this.targetTable = targetTableFilter.getTable();
        this.targetTableFilter = targetTableFilter;
    }

    @Override
    public int update() {
        this.countUpdatedRows = 0;
        this.targetRowidsRemembered.clear();
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        this.sourceTableFilter.startQuery(this.session);
        this.sourceTableFilter.reset();
        this.sourceQueryRowNumber = 0;
        this.checkRights();
        this.setCurrentRowNumber(0L);
        for (When w : this.when) {
            w.reset();
        }
        ResultInterface rows = this.query.query(0);
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), true);
        this.targetTable.lock(this.session, true, false);
        while (rows.next()) {
            ++this.sourceQueryRowNumber;
            Value[] sourceRowValues = rows.currentRow();
            RowImpl sourceRow = new RowImpl(sourceRowValues, 0);
            this.setCurrentRowNumber(this.sourceQueryRowNumber);
            this.merge(sourceRow);
        }
        rows.close();
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), false);
        return this.countUpdatedRows;
    }

    private int evaluateTriggerMasks() {
        int masks = 0;
        for (When w : this.when) {
            masks |= w.evaluateTriggerMasks();
        }
        return masks;
    }

    private void checkRights() {
        for (When w : this.when) {
            w.checkRights();
        }
        this.session.getUser().checkRight(this.targetTable, 1);
        this.session.getUser().checkRight(this.sourceTableFilter.getTable(), 1);
    }

    protected void merge(Row sourceRow) {
        this.sourceTableFilter.set(sourceRow);
        boolean found = this.isTargetRowFound();
        for (When w : this.when) {
            if (!(w.getClass() == WhenNotMatched.class ^ found)) continue;
            this.countUpdatedRows += w.merge();
        }
    }

    private boolean isTargetRowFound() {
        boolean matched = false;
        try (ResultInterface rows = this.targetMatchQuery.query(0);){
            while (rows.next()) {
                Value targetRowId = rows.currentRow()[0];
                Integer number = this.targetRowidsRemembered.get(targetRowId);
                if (number != null) {
                    throw DbException.get(23505, "Merge using ON column expression, duplicate _ROWID_ target record already updated, deleted or inserted:_ROWID_=" + targetRowId + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + number);
                }
                this.targetRowidsRemembered.put(targetRowId, this.sourceQueryRowNumber);
                matched = true;
            }
        }
        return matched;
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        StringBuilder builder = new StringBuilder("MERGE INTO ");
        this.targetTable.getSQL(builder, alwaysQuote).append('\n').append("USING ").append(this.query.getPlanSQL(alwaysQuote));
        return builder.toString();
    }

    @Override
    public void prepare() {
        this.onCondition.addFilterConditions(this.sourceTableFilter, true);
        this.onCondition.addFilterConditions(this.targetTableFilter, true);
        this.onCondition.mapColumns(this.sourceTableFilter, 2, 0);
        this.onCondition.mapColumns(this.targetTableFilter, 1, 0);
        this.onCondition = this.onCondition.optimize(this.session);
        this.onCondition.createIndexConditions(this.session, this.sourceTableFilter);
        this.onCondition.createIndexConditions(this.session, this.targetTableFilter);
        this.query.prepare();
        this.targetTableFilter.doneWithIndexConditions();
        boolean forUpdate = false;
        for (When w : this.when) {
            w.prepare();
            if (!(w instanceof WhenNotMatched)) continue;
            forUpdate = true;
        }
        this.targetMatchQuery = new Select(this.session, null);
        ArrayList<Expression> expressions = new ArrayList<Expression>(1);
        expressions.add(new ExpressionColumn(this.session.getDatabase(), this.targetTable.getSchema().getName(), this.targetTableFilter.getTableAlias(), "_ROWID_", true));
        this.targetMatchQuery.setExpressions(expressions);
        this.targetMatchQuery.addTableFilter(this.targetTableFilter, true);
        this.targetMatchQuery.addCondition(this.onCondition);
        this.targetMatchQuery.setForUpdate(forUpdate);
        this.targetMatchQuery.init();
        this.targetMatchQuery.prepare();
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setOnCondition(Expression condition) {
        this.onCondition = condition;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public ArrayList<When> getWhen() {
        return this.when;
    }

    public void addWhen(When w) {
        this.when.add(w);
    }

    public void setQueryAlias(String alias) {
        this.queryAlias = alias;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setTargetTableFilter(TableFilter targetTableFilter) {
        this.targetTableFilter = targetTableFilter;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    public static final class WhenNotMatched
    extends When {
        private Insert insertCommand;

        public WhenNotMatched(MergeUsing mergeUsing) {
            super(mergeUsing);
        }

        public Insert getInsertCommand() {
            return this.insertCommand;
        }

        public void setInsertCommand(Insert insertCommand) {
            this.insertCommand = insertCommand;
        }

        @Override
        int merge() {
            return this.andCondition == null || this.andCondition.getBooleanValue(this.mergeUsing.getSession()) ? this.insertCommand.update() : 0;
        }

        @Override
        void prepare() {
            super.prepare();
            this.insertCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
            this.insertCommand.prepare();
        }

        @Override
        int evaluateTriggerMasks() {
            return 1;
        }

        @Override
        void checkRights() {
            this.mergeUsing.getSession().getUser().checkRight(this.mergeUsing.targetTable, 4);
        }
    }

    public static final class WhenMatched
    extends When {
        private Update updateCommand;
        private Delete deleteCommand;
        private final HashSet<Long> updatedKeys = new HashSet();

        public WhenMatched(MergeUsing mergeUsing) {
            super(mergeUsing);
        }

        public Prepared getUpdateCommand() {
            return this.updateCommand;
        }

        public void setUpdateCommand(Update updateCommand) {
            this.updateCommand = updateCommand;
        }

        public Prepared getDeleteCommand() {
            return this.deleteCommand;
        }

        public void setDeleteCommand(Delete deleteCommand) {
            this.deleteCommand = deleteCommand;
        }

        @Override
        void reset() {
            this.updatedKeys.clear();
        }

        @Override
        int merge() {
            int countUpdatedRows = 0;
            if (this.updateCommand != null) {
                countUpdatedRows += this.updateCommand.update();
            }
            if (this.deleteCommand != null) {
                countUpdatedRows += this.deleteCommand.update();
                this.updatedKeys.clear();
            }
            return countUpdatedRows;
        }

        @Override
        void prepare() {
            super.prepare();
            if (this.updateCommand != null) {
                this.updateCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
                this.updateCommand.setCondition(WhenMatched.appendCondition(this.updateCommand, this.mergeUsing.onCondition));
                if (this.andCondition != null) {
                    this.updateCommand.setCondition(WhenMatched.appendCondition(this.updateCommand, this.andCondition));
                }
                this.updateCommand.prepare();
            }
            if (this.deleteCommand != null) {
                this.deleteCommand.setSourceTableFilter(this.mergeUsing.sourceTableFilter);
                this.deleteCommand.setCondition(WhenMatched.appendCondition(this.deleteCommand, this.mergeUsing.onCondition));
                if (this.andCondition != null) {
                    this.deleteCommand.setCondition(WhenMatched.appendCondition(this.deleteCommand, this.andCondition));
                }
                this.deleteCommand.prepare();
                if (this.updateCommand != null) {
                    this.updateCommand.setUpdatedKeysCollector(this.updatedKeys);
                    this.deleteCommand.setKeysFilter(this.updatedKeys);
                }
            }
        }

        @Override
        int evaluateTriggerMasks() {
            int masks = 0;
            if (this.updateCommand != null) {
                masks |= 2;
            }
            if (this.deleteCommand != null) {
                masks |= 4;
            }
            return masks;
        }

        @Override
        void checkRights() {
            User user = this.mergeUsing.getSession().getUser();
            if (this.updateCommand != null) {
                user.checkRight(this.mergeUsing.targetTable, 8);
            }
            if (this.deleteCommand != null) {
                user.checkRight(this.mergeUsing.targetTable, 2);
            }
        }

        private static Expression appendCondition(Update updateCommand, Expression condition) {
            Expression c = updateCommand.getCondition();
            return c == null ? condition : new ConditionAndOr(0, c, condition);
        }

        private static Expression appendCondition(Delete deleteCommand, Expression condition) {
            Expression c = deleteCommand.getCondition();
            return c == null ? condition : new ConditionAndOr(0, c, condition);
        }
    }

    public static abstract class When {
        final MergeUsing mergeUsing;
        Expression andCondition;

        When(MergeUsing mergeUsing) {
            this.mergeUsing = mergeUsing;
        }

        public void setAndCondition(Expression andCondition) {
            this.andCondition = andCondition;
        }

        void reset() {
        }

        abstract int merge();

        void prepare() {
            if (this.andCondition != null) {
                this.andCondition.mapColumns(this.mergeUsing.sourceTableFilter, 2, 0);
                this.andCondition.mapColumns(this.mergeUsing.targetTableFilter, 1, 0);
            }
        }

        abstract int evaluateTriggerMasks();

        abstract void checkRights();
    }
}

