/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.command.CommandInterface;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.ParameterInterface;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultWithGeneratedKeys;
import org.gridgain.internal.h2.result.ResultWithPaddedStrings;
import org.gridgain.internal.h2.util.MathUtils;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected long startTimeNanos;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(Session session, String sql) {
        this.session = session;
        this.sql = sql;
        this.trace = session.getDatabase().getTrace(0);
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    public abstract void prepareJoinBatch();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int maxrows) {
        throw DbException.get(90002);
    }

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled() || this.session.getDatabase().getQueryStatistics()) {
            this.startTimeNanos = System.nanoTime();
        }
    }

    void setProgress(int state) {
        this.session.getDatabase().setProgress(state, this.sql, 0, 0);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    @Override
    public void stop() {
        long timeMillis;
        this.session.setCurrentCommand(null, false);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else {
            this.session.unlockReadLocks();
        }
        this.session.endStatement();
        if (this.trace.isInfoEnabled() && this.startTimeNanos > 0L && (timeMillis = (System.nanoTime() - this.startTimeNanos) / 1000L / 1000L) > 100L) {
            this.trace.info("slow query: {0} ms", timeMillis);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultInterface executeQuery(int maxrows, boolean scrollable) {
        boolean writing;
        this.startTimeNanos = 0L;
        long start = 0L;
        Database database = this.session.getDatabase();
        Object sync = database.isMultiThreaded() || database.getStore() != null ? this.session : database;
        this.session.waitIfExclusiveModeEnabled();
        boolean callStop = true;
        boolean bl = writing = !this.isReadOnly();
        if (writing) {
            while (!database.beforeWriting()) {
            }
        }
        Object object = sync;
        synchronized (object) {
            this.session.startStatementWithinTransaction();
            this.session.setCurrentCommand(this, false);
            while (true) {
                ResultInterface result;
                block20: {
                    database.checkPowerOff();
                    result = this.query(maxrows);
                    boolean bl2 = callStop = !result.isLazy();
                    if (!database.getMode().padFixedLengthStrings) break block20;
                    ResultInterface resultInterface = ResultWithPaddedStrings.get(result);
                    return resultInterface;
                }
                ResultInterface resultInterface = result;
                return resultInterface;
                {
                    catch (DbException e) {
                        start = this.filterConcurrentUpdate(e, start);
                        continue;
                    }
                    catch (OutOfMemoryError e) {
                        throw DbException.convert(e);
                    }
                    catch (Throwable e) {
                        throw DbException.convert(e);
                    }
                    {
                        catch (DbException e) {
                            e = e.addSQL(this.sql);
                            SQLException s = e.getSQLException();
                            database.exceptionThrown(s, this.sql);
                            if (s.getErrorCode() == 90108) {
                                throw e;
                            }
                            database.checkPowerOff();
                            throw e;
                        }
                    }
                }
                break;
            }
            finally {
                if (callStop) {
                    this.stop();
                }
                if (writing) {
                    database.afterWriting();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultWithGeneratedKeys executeUpdate(Object generatedKeysRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long filterConcurrentUpdate(DbException e, long start) {
        long now;
        block6: {
            long slept;
            int errorCode = e.getErrorCode();
            if (errorCode != 90131 && errorCode != 90143 && errorCode != 90112) {
                throw e;
            }
            now = System.nanoTime();
            if (start != 0L && TimeUnit.NANOSECONDS.toMillis(now - start) > (long)this.session.getLockTimeout()) {
                throw DbException.get(50200, e, new String[0]);
            }
            Database database = this.session.getDatabase();
            if (database.getStore() != null) break block6;
            int sleep = 1 + MathUtils.randomInt(10);
            do {
                try {
                    if (database.isMultiThreaded()) {
                        Thread.sleep(sleep);
                        continue;
                    }
                    database.wait(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((slept = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - now)) < (long)sleep);
        }
        return start == 0L ? now : start;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> parameters = this.getParameters();
        for (ParameterInterface parameterInterface : parameters) {
            parameterInterface.setValue(null, true);
        }
    }

    public void setCanReuse(boolean canReuse) {
        this.canReuse = canReuse;
    }
}

