/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.bnf.context;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.gridgain.internal.h2.bnf.context.DbContents;
import org.gridgain.internal.h2.bnf.context.DbProcedure;
import org.gridgain.internal.h2.bnf.context.DbTableOrView;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class DbSchema {
    public final String name;
    public final boolean isDefault;
    public final boolean isSystem;
    public final String quotedName;
    private final DbContents contents;
    private DbTableOrView[] tables;
    private DbProcedure[] procedures;

    DbSchema(DbContents contents, String name, boolean isDefault) {
        this.contents = contents;
        this.name = name;
        this.quotedName = contents.quoteIdentifier(name);
        this.isDefault = isDefault;
        this.isSystem = name == null ? true : ("INFORMATION_SCHEMA".equals(name) ? true : (!contents.isH2() && StringUtils.toUpperEnglish(name).startsWith("INFO") ? true : (contents.isPostgreSQL() && StringUtils.toUpperEnglish(name).startsWith("PG_") ? true : contents.isDerby() && name.startsWith("SYS"))));
    }

    public DbContents getContents() {
        return this.contents;
    }

    public DbTableOrView[] getTables() {
        return this.tables;
    }

    public DbProcedure[] getProcedures() {
        return this.procedures;
    }

    public void readTables(DatabaseMetaData meta, String[] tableTypes) throws SQLException {
        ResultSet rs = meta.getTables(null, this.name, null, tableTypes);
        ArrayList<DbTableOrView> list = new ArrayList<DbTableOrView>();
        while (rs.next()) {
            DbTableOrView table = new DbTableOrView(this, rs);
            if (this.contents.isOracle() && table.getName().indexOf(36) > 0) continue;
            list.add(table);
        }
        rs.close();
        this.tables = list.toArray(new DbTableOrView[0]);
        if (this.tables.length < SysProperties.CONSOLE_MAX_TABLES_LIST_COLUMNS) {
            try (PreparedStatement ps = this.contents.isH2() ? meta.getConnection().prepareStatement("SELECT COLUMN_NAME, ORDINAL_POSITION, COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?") : null;){
                for (DbTableOrView tab : this.tables) {
                    try {
                        tab.readColumns(meta, ps);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void readProcedures(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = meta.getProcedures(null, this.name, null);
        ArrayList<DbProcedure> list = Utils.newSmallArrayList();
        while (rs.next()) {
            list.add(new DbProcedure(this, rs));
        }
        rs.close();
        this.procedures = list.toArray(new DbProcedure[0]);
        if (this.procedures.length < SysProperties.CONSOLE_MAX_PROCEDURES_LIST_COLUMNS) {
            for (DbProcedure procedure : this.procedures) {
                procedure.readParameters(meta);
            }
        }
    }
}

