/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.FileUtils;
import org.gridgain.cachechecksum.utility.commands.PartitionDiff;
import org.gridgain.cachechecksum.utility.commands.PartitionResult;

public class PartitionHashSumComparator {
    protected static final Logger log = LogManager.getLogger(PartitionHashSumComparator.class);
    protected final CacheCheckSumArguments args;
    private static final String FS = File.separator;

    PartitionHashSumComparator(CacheCheckSumArguments args) {
        this.args = args;
    }

    int checkFiles(String path1, String path2, String dumpPath) {
        HashMap<String, Map<Object, Map<Object, Object>>> checkMap1 = FileUtils.readMap(path1);
        HashMap<String, Map<Object, Map<Object, Object>>> checkMap2 = FileUtils.readMap(path2);
        if (checkMap1 == null || checkMap2 == null) {
            return -1;
        }
        HashMap<String, Map<Integer, PartitionDiff>> diffs = new HashMap<String, Map<Integer, PartitionDiff>>();
        Set cacheNames1 = checkMap1.keySet();
        Set cacheNames2 = checkMap2.keySet();
        if (cacheNames1.isEmpty()) {
            log.error("No cache data in first result path " + path1);
            return -1;
        }
        if (cacheNames2.isEmpty()) {
            log.error("No cache data in second result path " + path2);
            return -1;
        }
        if (cacheNames1.size() != cacheNames2.size()) {
            log.error("Found different cache numbers: ");
            log.error(cacheNames1.size() + " caches in first result path " + path1);
            log.error(cacheNames2.size() + " caches in second result path." + path2);
            return -1;
        }
        for (String cacheName : cacheNames1) {
            if (checkMap1.get(cacheName) == null) {
                log.error("Failed to read cache partition result [cache name: " + cacheName + "] in first result path");
                return -1;
            }
            if (checkMap2.get(cacheName) == null) {
                log.error("Failed to read cache partition result [cache name: " + cacheName + "] in second result path");
                return -1;
            }
            Map map1 = (Map)checkMap1.get(cacheName);
            Map map2 = (Map)checkMap2.get(cacheName);
            if (map1.size() != map2.size()) {
                log.info("WARNING: different number of partitions in cache " + cacheName + " result.");
                log.info("First result path: " + map1.size());
                log.info("Second result path: " + map2.size());
                return -1;
            }
            HashMap<Integer, PartitionDiff> partDiff = new HashMap<Integer, PartitionDiff>();
            for (int i = 0; i < map1.size(); ++i) {
                if (map1.get(String.valueOf(i)) == null) {
                    log.error("No partition data in first result file. [Partition ID = " + i + "]");
                    return -1;
                }
                if (map2.get(String.valueOf(i)) == null) {
                    log.error("No partition data in second result file. [Partition ID = " + i + "]");
                    return -1;
                }
                PartitionResult pr1 = this.mapToPartResult((Map)map1.get(String.valueOf(i)));
                PartitionResult pr2 = this.mapToPartResult((Map)map2.get(String.valueOf(i)));
                if (pr1 == null || pr2 == null) {
                    log.error("Failed to convert map to PartitionResult. [Partition ID = " + i + "]");
                    return -1;
                }
                PartitionDiff diff = this.checkPartitionResultDiff(pr1, pr2, this.args.countValues());
                if (diff == null) continue;
                partDiff.put(i, diff);
            }
            if (partDiff.isEmpty()) continue;
            diffs.put(cacheName, partDiff);
        }
        if (!diffs.isEmpty()) {
            String endStr = diffs.size() == 1 ? " cache." : " caches.";
            log.info("Found different partitions in " + diffs.size() + endStr);
            String dumpDir = this.args.getWorkDir() + FS + this.args.getStartTime() + "-diff";
            try {
                if (this.args.filePerCache()) {
                    FileUtils.createDir(dumpDir);
                }
                FileUtils.dumpDiff(dumpPath, diffs);
            }
            catch (IOException e) {
                log.error("Failed to save result in " + dumpPath, (Throwable)e);
                return -1;
            }
            log.info("Diff file: " + dumpPath);
            return 1;
        }
        log.info("No different partitions found.");
        return 0;
    }

    private PartitionDiff checkPartitionResultDiff(PartitionResult pr1, PartitionResult pr2, boolean checkValHashSum) {
        boolean foundDiff;
        boolean bl = foundDiff = pr1.getKeys() != pr2.getKeys();
        if (!pr1.getKeyHashSum().equals(pr2.getKeyHashSum())) {
            foundDiff = true;
        }
        if (checkValHashSum && !pr1.getValHashSum().equals(pr2.getValHashSum())) {
            foundDiff = true;
        }
        return foundDiff ? this.createDiff(pr1, pr2) : null;
    }

    PartitionResult mapToPartResult(Map<Object, Object> map) {
        PartitionResult pr = new PartitionResult();
        try {
            pr.setPartID(Integer.valueOf(map.get("partID").toString()));
            pr.setKeys(Long.valueOf(map.get("keys").toString()));
            pr.setKeyHashSum(map.get("keyHashSum").toString());
            pr.setValHashSum(map.get("valHashSum").toString());
            pr.setNodeName(map.get("nodeName").toString());
            pr.setNodeIP(map.get("nodeIP").toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return pr;
    }

    private PartitionDiff createDiff(PartitionResult pr1, PartitionResult pr2) {
        return new PartitionDiff(pr1.getPartID(), pr1.getKeys(), pr2.getKeys(), pr1.getKeyHashSum(), pr2.getKeyHashSum(), pr1.getValHashSum(), pr2.getValHashSum(), pr1.getNodeName(), pr2.getNodeName(), pr1.getNodeIP(), pr2.getNodeIP());
    }

    int checkDirs() {
        int diffCaches = 0;
        if (this.validateDir(this.args.getPathOne()) > 0) {
            return -1;
        }
        if (this.validateDir(this.args.getPathTwo()) > 0) {
            return -1;
        }
        String dir1 = this.args.getWorkDir() + FS + this.args.getPathOne();
        String dir2 = this.args.getWorkDir() + FS + this.args.getPathTwo();
        File[] files1 = new File(dir1).listFiles();
        File[] files2 = new File(dir2).listFiles();
        String suffix1 = '-' + this.args.getPathOne().replace("result-", "") + ".json";
        String suffix2 = '-' + this.args.getPathTwo().replace("result-", "") + ".json";
        Collection<String> cacheNames1 = this.getCacheNames(files1, suffix1);
        Collection<String> cacheNames2 = this.getCacheNames(files2, suffix2);
        if (cacheNames1.size() != cacheNames2.size()) {
            log.info("Different number of caches in result directories.");
            return -1;
        }
        String dumpDir = this.args.getWorkDir() + FS + this.args.getStartTime() + "-diff";
        for (String cacheName : cacheNames1) {
            String path1 = this.args.getWorkDir() + FS + this.args.getPathOne() + FS + cacheName + suffix1;
            String path2 = this.args.getWorkDir() + FS + this.args.getPathTwo() + FS + cacheName + suffix2;
            String dumpPath = dumpDir + FS + cacheName + "__" + this.args.getPathOne() + "__" + this.args.getPathTwo() + "__diff.json";
            log.info("Processing cache " + cacheName + '.');
            int res = this.checkFiles(path1, path2, dumpPath);
            if (res == -1) {
                return -1;
            }
            diffCaches += res;
        }
        return diffCaches;
    }

    private Collection<String> getCacheNames(File[] arr, String suffix) {
        ArrayList<String> res = new ArrayList<String>(arr.length);
        for (File file : arr) {
            if (!file.getName().endsWith(suffix)) continue;
            res.add(file.getName().replace(suffix, ""));
        }
        return res;
    }

    private int validateDir(String path) {
        File[] files;
        File dirPath;
        int res = 0;
        if (!path.startsWith("result-")) {
            log.error(this.args.getPathOne() + " is not valid name for result directory. Name should start with 'result-'");
            res = 1;
        }
        if (!(dirPath = new File(this.args.getWorkDir() + FS + path)).exists()) {
            log.error(dirPath.getAbsolutePath() + " does not exist.");
            res = 1;
        }
        if (!dirPath.isDirectory()) {
            log.error(dirPath.getAbsolutePath() + " is not a directory.");
            res = 1;
        }
        if ((files = dirPath.listFiles()) == null || files.length == 0) {
            log.error("Failed to read result files from " + dirPath.getPath() + " directory.");
            res = 1;
        }
        return res;
    }
}

