/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.cachechecksum.utility.commands.PartitionDiff;
import org.gridgain.cachechecksum.utility.commands.PartitionResult;

public class FileUtils {
    protected static final Logger log = LogManager.getLogger(FileUtils.class);

    static void dumpRes(String path, Map<String, Map<Integer, PartitionResult>> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        PrintWriter writer = new PrintWriter(new FileOutputStream(new File(path)));
        writer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map));
        writer.close();
    }

    static HashMap<String, Map<Object, Map<Object, Object>>> readMap(String path) {
        File file = new File(path);
        if (!file.exists() || file.isDirectory()) {
            log.error("File " + path + " does not exist");
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap res = null;
        try {
            res = (HashMap)mapper.readValue(new File(path), HashMap.class);
        }
        catch (IOException e) {
            log.error("Failed to read map from file " + path, (Throwable)e);
        }
        return res;
    }

    static void dumpDiff(String path, Map<String, Map<Integer, PartitionDiff>> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        PrintWriter writer = new PrintWriter(new FileOutputStream(new File(path)));
        writer.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map));
        writer.close();
    }

    static void createDir(String path) {
        File workDir = new File(path);
        if (!workDir.exists() && !workDir.mkdir()) {
            log.error("Failed to create directory " + path);
        }
    }
}

