/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.AbstractCheckSumMapCreator;
import org.gridgain.cachechecksum.utility.commands.AffinityCheckSumMapCreator;
import org.gridgain.cachechecksum.utility.commands.BroadcastCheckSumMapCreator;
import org.gridgain.cachechecksum.utility.commands.Command;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class CommandCreate
extends Command {
    private Ignite ignite;

    @Override
    public String name() {
        return "CREATE";
    }

    @Override
    protected void initHelp() {
        log.info("Command CREATE help:");
        log.info("-h or --help - prints help. If this parameter is specified, all others will be ignored.");
        log.info("Mandatory parameters:");
        log.info("-cfg or --cfgPath - path to ignite configuration file.");
        log.info("-wd or --workDir - path to working directory.");
        log.info("Optional parameters:");
        log.info("-cn or --cacheNames - list of comma separated cache names to calculate partition hash sum.");
        log.info("-cp or --cachePrefix - if this parameter is specified, all caches matching this prefix will be added to the cache name list to calculate hash sum.");
        log.info("-ca or --checkAllCaches - if this parameter is specified, all caches in cluster will be added to the cache name list to calculate hash sum.");
        log.info("NOTE that you must specify at least one of three parameters above, otherwise no calculations will be performed.");
        log.info("-cv or --countValues - if this parameter is specified, values hash sum will be calculated. NOTE that if hashCode() method is not properly implemented, hash sum calculations of partitions may not match even if value objects are identical.");
        log.info("-fpc or --filePerCache - Flag indicating that each cache result will be placed in its own file");
        log.info("in common directory. Do not rename any of files or directory, otherwise you will not be able to");
        log.info("compare results later.");
    }

    @Override
    protected int execute0(CacheCheckSumArguments args) {
        if (args.help()) {
            this.initHelp();
            return 0;
        }
        try {
            IgniteConfiguration icfg = this.loadConfiguration(args.getCfgPath());
            icfg.setIgniteInstanceName("check-hash-sum-utility");
            icfg.setMetricsLogFrequency(0L);
            icfg.setClientMode(true);
            this.ignite = Ignition.start((IgniteConfiguration)icfg);
        }
        catch (Exception e) {
            log.error("Failed to start Ignite instance.", (Throwable)e);
            return 5;
        }
        AbstractCheckSumMapCreator creator = args.useBroadcast() ? new BroadcastCheckSumMapCreator(this.ignite, args) : new AffinityCheckSumMapCreator(this.ignite, args);
        int res = creator.saveMap();
        this.ignite.close();
        return res;
    }

    private IgniteConfiguration loadConfiguration(String springCfgPath) throws Exception {
        Map cfgMap;
        GenericApplicationContext springCtx;
        URL url;
        block7: {
            try {
                url = new URL(springCfgPath);
            }
            catch (MalformedURLException e) {
                url = IgniteUtils.resolveIgniteUrl((String)springCfgPath);
                if (url != null) break block7;
                throw new IgniteCheckedException("Spring XML configuration path is invalid: " + springCfgPath + ". Note that this path should be either absolute or a relative local file system path, relative to META-INF in classpath or valid URL to IGNITE_HOME.", (Throwable)e);
            }
        }
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(url));
            springCtx.refresh();
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate Spring XML application context [springUrl=" + url + ", err=" + e.getMessage() + ']', e);
        }
        try {
            cfgMap = springCtx.getBeansOfType(IgniteConfiguration.class);
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate bean [type=" + IgniteConfiguration.class + ", err=" + e.getMessage() + ']', e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new Exception("Failed to find ignite configuration in: " + url);
        }
        return (IgniteConfiguration)cfgMap.values().iterator().next();
    }
}

