/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.io.File;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.Command;
import org.gridgain.cachechecksum.utility.commands.PartitionHashSumComparator;

public class CommandCompare
extends Command {
    @Override
    public String name() {
        return "COMPARE";
    }

    @Override
    protected void initHelp() {
        log.info("Command COMPARE help:");
        log.info("-h or --help - prints help. If this parameter is specified, all others will be ignored.");
        log.info("Mandatory parameters:");
        log.info("-wd or --workDir - path to working directory.");
        log.info("-p1 or --pathOne - path to first file or directory to compare.");
        log.info("-p2 or --pathTwo - path to second file or directory to compare.");
        log.info("Optional parameters:");
        log.info("-fpc or --filePerCache - Flag indicating that each cache result is placed in its own file.");
        log.info("If this parameter is specified you should specify names of directories to compare in -p1 and -p2.");
        log.info("Names of directories should look like 'result-YY-MM-dd-HH-mm-ss'.");
        log.info("Names of files in directory should look like 'cacheName-YY-MM-dd-HH-mm-ss'.");
    }

    @Override
    protected int execute0(CacheCheckSumArguments args) {
        int res;
        if (args.help()) {
            this.initHelp();
            return 0;
        }
        PartitionHashSumComparator comp = new PartitionHashSumComparator(args);
        if (!args.filePerCache()) {
            String path1 = args.getWorkDir() + File.separator + args.getPathOne();
            String path2 = args.getWorkDir() + File.separator + args.getPathTwo();
            String dumpPath = args.getWorkDir() + File.separator + args.getStartTime() + "-diff.json";
            res = comp.checkFiles(path1, path2, dumpPath);
        } else {
            res = comp.checkDirs();
            if (res > 0) {
                log.info("Found different partitions in " + res + " files.");
            }
        }
        if (res == -1) {
            log.info("Failed to perform result comparison.");
            return 5;
        }
        if (res == 0) {
            log.info("No different partition found.");
        }
        return 0;
    }
}

