/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.grid.internal.util.GridGainProperties;

public abstract class Command {
    protected static final Logger log = LogManager.getLogger(Command.class);
    public static final int RESULT_OK = 0;
    protected static final String DELIM = "--------------------------------------------------------------------------------";
    private final Map<Integer, String> errMsgs = new HashMap<Integer, String>();
    protected final Collection<String> help = new ArrayList<String>();
    protected final String ses = U.id8((UUID)UUID.randomUUID());
    protected static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.US).withZone(ZoneId.systemDefault());

    public abstract String name();

    protected abstract void initHelp();

    protected Command addHelp(String line) {
        this.help.add(line);
        return this;
    }

    protected Command addHelpIdent(String line) {
        return this.addHelp("    " + line);
    }

    protected void NL() {
        this.addHelp("");
    }

    public void printHelp() {
        if (F.isEmpty(this.help)) {
            this.initHelp();
            this.NL();
            this.addHelp("Exit codes:");
            this.addHelpIdent("0 - successful execution.");
            this.addHelpIdent("1 - unexpected error.");
            this.addHelpIdent("2 - unknown command.");
            this.addHelpIdent("3 - invalid arguments.");
            this.addHelpIdent("4 - connection failed.");
            this.addHelpIdent("5 - command failed with known error code.");
            this.addHelpIdent("6 - command executed successfully, but snapshot utility failed to write result to output file.");
            this.addHelpIdent("7 - command failed and snapshot utility failed to write error code to output file.");
        }
        for (String line : this.help) {
            log.info(line);
        }
    }

    protected abstract int execute0(CacheCheckSumArguments var1);

    public int execute(CacheCheckSumArguments args) {
        Thread.currentThread().setName("session=" + this.ses);
        log.info("GridGain Cachechecksum utility [ver. {}]", (Object)IgniteVersionUtils.ACK_VER_STR);
        log.info(GridGainProperties.COPYRIGHT);
        log.info("User: {}", (Object)System.getProperty("user.name"));
        log.info(DELIM);
        return this.internalExecute(args);
    }

    private int internalExecute(CacheCheckSumArguments args) {
        Instant start = Instant.now();
        log.info("Command [{}] started at [{}]...", (Object)this.name(), (Object)DATE_FMT.format(start));
        int status = this.execute0(args);
        if (status > 0) {
            log.error("Command [{}] failed with error: {}", (Object)this.name(), (Object)this.errorMessage(status));
        } else {
            log.info("Command [{}] successfully finished in {} seconds.", (Object)this.name(), (Object)Duration.between(start, Instant.now()).getSeconds());
        }
        return status;
    }

    protected String errorMessage(int errCode) {
        String errMsg;
        if (F.isEmpty(this.help)) {
            this.initHelp();
        }
        return F.isEmpty((String)(errMsg = this.errMsgs.get(errCode))) ? String.valueOf(errCode) : errMsg;
    }
}

