/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.lang.IgniteCallable;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.AbstractCheckSumMapCreator;
import org.gridgain.cachechecksum.utility.commands.BroadcastCheckSumCalcClosure;
import org.gridgain.cachechecksum.utility.commands.PartitionResult;

public class BroadcastCheckSumMapCreator
extends AbstractCheckSumMapCreator {
    BroadcastCheckSumMapCreator(Ignite ignite, CacheCheckSumArguments args) {
        super(ignite, args);
    }

    @Override
    public Map<Integer, PartitionResult> createCacheMap(String cacheName) {
        ConcurrentHashMap<Integer, PartitionResult> hashSumMap = new ConcurrentHashMap<Integer, PartitionResult>();
        BroadcastCheckSumCalcClosure task = new BroadcastCheckSumCalcClosure(cacheName, this.args.countValues(), this.args.calcSHA());
        Collection r = this.ignite.compute(this.ignite.cluster().forDataNodes(cacheName)).broadcast((IgniteCallable)task);
        for (List clq : r) {
            for (BinaryObject obj : clq) {
                PartitionResult pr = this.convertToPartitionResult(obj);
                hashSumMap.put(pr.getPartID(), pr);
            }
        }
        return hashSumMap;
    }
}

