/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.cachechecksum.utility.commands.AbstractCheckSumCalcClosure;

public class BroadcastCheckSumCalcClosure
extends AbstractCheckSumCalcClosure
implements IgniteCallable<List<BinaryObject>> {
    BroadcastCheckSumCalcClosure(String cacheName, boolean cntValues, boolean calcSHA) {
        super(cacheName, cntValues, calcSHA);
    }

    public List<BinaryObject> call() throws Exception {
        Affinity aff = this.ignite.affinity(this.cacheName);
        int[] partIds = aff.primaryPartitions(((IgniteEx)this.ignite).localNode());
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new IgniteThreadFactory(this.ignite.name(), "checksum-worker"));
        ArrayList<1> callList = new ArrayList<1>(partIds.length);
        for (final int partId : partIds) {
            Callable<BinaryObject> call = new Callable<BinaryObject>(){

                @Override
                public BinaryObject call() {
                    QueryCursor entries = BroadcastCheckSumCalcClosure.this.ignite.cache(BroadcastCheckSumCalcClosure.this.cacheName).query((Query)new ScanQuery(partId));
                    return BroadcastCheckSumCalcClosure.this.convertToBinary(entries, partId);
                }
            };
            callList.add(call);
        }
        List futList = exec.invokeAll(callList);
        ArrayList<BinaryObject> partResList = new ArrayList<BinaryObject>(partIds.length);
        for (Future future : futList) {
            partResList.add((BinaryObject)future.get());
        }
        return partResList;
    }
}

