/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.Ignite;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.AbstractCheckSumMapCreator;
import org.gridgain.cachechecksum.utility.commands.AffinityCheckSumCalcClosure;
import org.gridgain.cachechecksum.utility.commands.PartitionResult;

public class AffinityCheckSumMapCreator
extends AbstractCheckSumMapCreator {
    AffinityCheckSumMapCreator(Ignite ignite, CacheCheckSumArguments args) {
        super(ignite, args);
    }

    @Override
    public Map<Integer, PartitionResult> createCacheMap(final String cacheName) throws Exception {
        HashMap<Integer, PartitionResult> hashSumMap = new HashMap<Integer, PartitionResult>();
        Affinity af = this.ignite.affinity(cacheName);
        int partitions = af.partitions();
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new IgniteThreadFactory(this.ignite.name(), "checksum-worker"));
        ArrayList<1> callList = new ArrayList<1>(partitions);
        int i = 0;
        while (i < partitions) {
            final int part = i++;
            Callable<PartitionResult> call = new Callable<PartitionResult>(){

                @Override
                public PartitionResult call() {
                    AffinityCheckSumCalcClosure task = new AffinityCheckSumCalcClosure(cacheName, part, AffinityCheckSumMapCreator.this.args.countValues(), AffinityCheckSumMapCreator.this.args.calcSHA());
                    BinaryObject obj = (BinaryObject)AffinityCheckSumMapCreator.this.ignite.compute().affinityCall(Collections.singletonList(cacheName), part, (IgniteCallable)task);
                    return AffinityCheckSumMapCreator.this.convertToPartitionResult(obj);
                }
            };
            callList.add(call);
        }
        List futList = exec.invokeAll(callList);
        for (Future future : futList) {
            PartitionResult pr = (PartitionResult)future.get();
            hashSumMap.put(pr.getPartID(), pr);
        }
        exec.shutdown();
        return hashSumMap;
    }
}

