/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.FileUtils;
import org.gridgain.cachechecksum.utility.commands.PartitionResult;

public abstract class AbstractCheckSumMapCreator {
    protected static final Logger log = LogManager.getLogger(AbstractCheckSumMapCreator.class);
    protected final CacheCheckSumArguments args;
    @IgniteInstanceResource
    protected final Ignite ignite;
    private static final String FS = File.separator;
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    AbstractCheckSumMapCreator(Ignite ignite, CacheCheckSumArguments args) {
        this.ignite = ignite;
        this.args = args;
    }

    public abstract Map<Integer, PartitionResult> createCacheMap(String var1) throws Exception;

    int saveMap() {
        Collection<String> cacheNames = this.getCacheNameList(this.ignite, this.args);
        if (cacheNames == null) {
            log.error("Failed to get list of cache names to process.");
            return 5;
        }
        HashMap<String, Map<Integer, PartitionResult>> map = new HashMap<String, Map<Integer, PartitionResult>>();
        FileUtils.createDir(this.args.getWorkDir());
        if (this.args.filePerCache()) {
            FileUtils.createDir(this.args.getWorkDir() + FS + "result-" + this.args.getStartTime());
        }
        for (String cacheName : cacheNames) {
            log.info("Processing cache " + cacheName);
            try {
                map.put(cacheName, this.createCacheMap(cacheName));
            }
            catch (Exception e) {
                log.error("Failed to calculate partition results in cache " + cacheName, (Throwable)e);
            }
            if (!this.args.filePerCache()) continue;
            String fileName = cacheName + "-" + this.args.getStartTime() + ".json";
            String path = this.args.getWorkDir() + FS + "result-" + this.args.getStartTime() + FS + fileName;
            try {
                FileUtils.dumpRes(path, map);
            }
            catch (IOException e) {
                log.error("Failed to save result to " + path, (Throwable)e);
                return 5;
            }
            map = new HashMap();
        }
        if (!this.args.filePerCache()) {
            String path = this.args.getWorkDir() + FS + "result-" + this.args.getStartTime() + ".json";
            try {
                FileUtils.dumpRes(path, map);
            }
            catch (IOException e) {
                log.error("Failed to save result to " + path, (Throwable)e);
                return 5;
            }
        }
        return 0;
    }

    private Collection<String> getCacheNameList(Ignite ignite, CacheCheckSumArguments args) {
        LinkedList<String> res = new LinkedList<String>();
        if (args.checkAllCaches()) {
            return ignite.cacheNames();
        }
        if (args.getCacheNames() != null) {
            String[] names;
            for (String name : names = args.getCacheNames().split(",")) {
                if (ignite.cache(name) != null) {
                    res.add(name);
                    continue;
                }
                log.info("Cache " + name + " is not found in the cluster.");
            }
        }
        if (args.getCachePrefix() != null) {
            for (String name : ignite.cacheNames()) {
                if (!name.startsWith(args.getCachePrefix())) continue;
                res.add(name);
            }
        }
        if (res.isEmpty()) {
            log.info("No caches are listed for hash sum calculation.");
        }
        return res;
    }

    PartitionResult convertToPartitionResult(BinaryObject obj) {
        PartitionResult pr = new PartitionResult();
        BinaryObjectBuilder builder = obj.toBuilder();
        pr.setNodeIP(builder.getField("nodeIP").toString());
        pr.setNodeName(builder.getField("nodeName").toString());
        pr.setPartID((Integer)builder.getField("partID"));
        pr.setKeys((Long)builder.getField("keys"));
        pr.setKeyHashSum(this.arrToString((byte[])builder.getField("keyHashSum")));
        pr.setValHashSum(this.arrToString((byte[])builder.getField("valHashSum")));
        return pr;
    }

    private String arrToString(byte[] arr) {
        StringBuilder hexStr = new StringBuilder();
        for (byte b : arr) {
            char lo = chars[0xF & b];
            char hi = chars[(0xF0 & b) >> 4];
            hexStr.append(Character.toString(hi)).append(Character.toString(lo));
        }
        return hexStr.toString();
    }
}

