/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility.commands;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.resources.IgniteInstanceResource;

public abstract class AbstractCheckSumCalcClosure {
    final String cacheName;
    private final boolean cntValues;
    private final boolean calcSHA;
    protected final int partID;
    @IgniteInstanceResource
    protected Ignite ignite;

    AbstractCheckSumCalcClosure(String cacheName, int partID, boolean cntValues, boolean calcSHA) {
        this.cacheName = cacheName;
        this.partID = partID;
        this.cntValues = cntValues;
        this.calcSHA = calcSHA;
    }

    AbstractCheckSumCalcClosure(String cacheName, boolean cntValues, boolean calcSHA) {
        this(cacheName, 0, cntValues, calcSHA);
    }

    BinaryObject convertToBinary(QueryCursor entries, int partID) {
        BinaryObjectBuilder builder = this.convertToBinary(entries).toBuilder();
        builder.setField("partID", (Object)partID);
        return builder.build();
    }

    BinaryObject convertToBinary(QueryCursor entries) {
        BinaryObjectBuilder builder = this.ignite.binary().builder("org.gridgain.cachechecksum.utility.commands.PartitionResult");
        String nodeName = this.ignite.name() != null ? this.ignite.name() : "unknown";
        Iterator iter = entries.iterator();
        builder.setField("nodeName", (Object)nodeName);
        builder.setField("partID", (Object)this.partID);
        builder.setField("nodeIP", this.ignite.cluster().localNode().consistentId());
        long size = 0L;
        if (!this.calcSHA) {
            long keySum = 0L;
            long valSum = 0L;
            while (iter.hasNext()) {
                Cache.Entry entry = (Cache.Entry)iter.next();
                Object key = entry.getKey();
                keySum += (long)key.hashCode();
                if (this.cntValues) {
                    valSum += (long)entry.getValue().hashCode();
                }
                ++size;
            }
            builder.setField("keys", (Object)size);
            builder.setField("keyHashSum", (Object)ByteBuffer.allocate(8).putLong(keySum).array());
            builder.setField("valHashSum", (Object)ByteBuffer.allocate(8).putLong(valSum).array());
            return builder.build();
        }
        try {
            MessageDigest mdKeys = MessageDigest.getInstance("SHA-256");
            MessageDigest mdVals = MessageDigest.getInstance("SHA-256");
            while (iter.hasNext()) {
                Cache.Entry entry = (Cache.Entry)iter.next();
                Object key = entry.getKey();
                mdKeys.update(ByteBuffer.allocate(4).putInt(key.hashCode()).array());
                if (this.cntValues) {
                    Object val = entry.getValue();
                    mdVals.update(ByteBuffer.allocate(4).putInt(val.hashCode()).array());
                }
                ++size;
            }
            builder.setField("keys", (Object)size);
            builder.setField("keyHashSum", (Object)mdKeys.digest());
            if (this.cntValues) {
                builder.setField("valHashSum", (Object)mdVals.digest());
            } else {
                byte[] zero = new byte[]{0};
                builder.setField("valHashSum", (Object)zero);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.ignite.log().error("Failed to get algorithm SHA-256", (Throwable)e);
        }
        return builder.build();
    }
}

