/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.cachechecksum.utility.commands.DummyMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class Utils {
    public static void main(String[] args) throws Exception {
        int i;
        String cfg = "modules/cache-checksum-utility/config/ignite-localhost-config.xml";
        String workDir = "modules/cache-checksum-utility/work";
        boolean threads = true;
        File conf = new File("modules/cache-checksum-utility/config/ignite-localhost-config.xml");
        if (!conf.exists()) {
            cfg = "/home/oostanin/gg/ggprivate/modules/cache-checksum-utility/config/ignite-localhost-config.xml";
        }
        boolean extraNodes = true;
        IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> tup = Utils.loadConfiguration(cfg);
        IgniteConfiguration c = (IgniteConfiguration)tup.get1();
        c.setIgniteInstanceName("node-0");
        c.setMetricsLogFrequency(0L);
        Ignite ignite = Ignition.start((IgniteConfiguration)c);
        for (int i2 = 1; i2 <= 1; ++i2) {
            tup = Utils.loadConfiguration(cfg);
            c = (IgniteConfiguration)tup.get1();
            c.setIgniteInstanceName("node-" + i2);
            c.setMetricsLogFrequency(0L);
            Ignition.start((IgniteConfiguration)c);
        }
        ArrayList<String> args0 = new ArrayList<String>();
        Utils.addArg(args0, "create", "");
        Utils.addArg(args0, "-cfg", cfg);
        Utils.addArg(args0, "-wd", "modules/cache-checksum-utility/work");
        Utils.addArg(args0, "-cv", "");
        Utils.addArg(args0, "-sha", "");
        Utils.addArg(args0, "-mi", 1);
        Utils.addArg(args0, "-fpc", "");
        Utils.addArg(args0, "-cn", "tx,atomic,compute");
        Utils.addArg(args0, "-p1", "result-2017-08-02-17-19-47");
        Utils.addArg(args0, "-p2", "result-2017-08-02-17-20-05");
        IgniteCache testCache = ignite.cache("tx");
        IgniteCache loopCache = ignite.cache("tx");
        Random r = new Random(1L);
        int loop = 50000;
        for (i = 0; i < loop; ++i) {
            testCache.put((Object)i, (Object)Utils.createVal(r.nextInt(60)));
        }
        testCache = ignite.cache("atomic");
        System.out.println("atomic");
        for (i = 0; i < loop; ++i) {
            testCache.put((Object)i, (Object)Utils.createVal(r.nextInt(60)));
        }
        testCache = ignite.cache("compute");
        System.out.println("compute");
        for (i = 0; i < loop; ++i) {
            testCache.put((Object)i, (Object)Utils.createVal(r.nextInt(60)));
        }
        System.out.println("Loaded.");
        Thread.sleep(60000L);
        for (i = loop; i < loop + 20; ++i) {
            System.out.println("i = " + i);
            loopCache.put((Object)i, (Object)Utils.createVal(r.nextInt(60)));
            Thread.sleep(60000L);
        }
        ignite.close();
    }

    private static void addArg(List<String> args, String arg, Object val) {
        args.add(arg);
        args.add(val.toString());
    }

    public static IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> loadConfiguration(String springCfgPath) throws Exception {
        Map cfgMap;
        GenericApplicationContext springCtx;
        URL url;
        block7: {
            try {
                url = new URL(springCfgPath);
            }
            catch (MalformedURLException e) {
                url = IgniteUtils.resolveIgniteUrl((String)springCfgPath);
                if (url != null) break block7;
                throw new IgniteCheckedException("Spring XML configuration path is invalid: " + springCfgPath + ". Note that this path should be either absolute or a relative local file system path, relative to META-INF in classpath or valid URL to IGNITE_HOME.", (Throwable)e);
            }
        }
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(url));
            springCtx.refresh();
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate Spring XML application context [springUrl=" + url + ", err=" + e.getMessage() + ']', e);
        }
        try {
            cfgMap = springCtx.getBeansOfType(IgniteConfiguration.class);
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate bean [type=" + IgniteConfiguration.class + ", err=" + e.getMessage() + ']', e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new Exception("Failed to find ignite configuration in: " + url);
        }
        return new IgniteBiTuple(cfgMap.values().iterator().next(), (Object)springCtx);
    }

    public static JCommander jcommander(String[] a, Object args, String programName) {
        JCommander jCommander = new JCommander();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.setProgramName(programName);
        jCommander.addObject(args);
        jCommander.parse(a);
        return jCommander;
    }

    private static DummyMap createVal(int c) {
        return new DummyMap(c);
    }
}

