/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cachechecksum.utility;

import com.beust.jcommander.ParameterException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.gridgain.cachechecksum.utility.CacheCheckSumArguments;
import org.gridgain.cachechecksum.utility.commands.Command;
import org.gridgain.cachechecksum.utility.commands.CommandHelp;
import org.gridgain.cachechecksum.utility.commands.Commands;

public class CacheCheckSumUtility {
    private static final Logger log = LogManager.getLogger(CommandHelp.class);
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 1;
    public static final int EXIT_CODE_UNKNOWN_CMD = 2;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 3;
    public static final int EXIT_CODE_CONNECTION_FAILED = 4;
    public static final int EXIT_CODE_CMD_FAILED = 5;
    public static final int EXIT_CODE_OUTPUT_FAILED = 6;
    public static final int EXIT_CODE_CMD_FAILED_OUTPUT_FAILED = 7;

    public static void main(String[] args) {
        CacheCheckSumUtility utility = new CacheCheckSumUtility();
        System.exit(utility.execute(args));
    }

    int execute(String[] cmdArgs) {
        CacheCheckSumArguments args = new CacheCheckSumArguments();
        try {
            Command help = Commands.HELP.command();
            if (F.isEmpty((Object[])cmdArgs)) {
                return help.execute(args);
            }
            String arg = cmdArgs[0].trim().toUpperCase();
            try {
                if (Commands.valueOf(arg).command() == null) {
                    Command cmd = Commands.HELP.command();
                    return cmd.execute(args);
                }
                Command cmd = Commands.valueOf(arg).command();
                cmdArgs[0] = "-kc";
                CacheCheckSumArguments.parseArgs(cmdArgs, args, "checksum-utility");
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneId.systemDefault());
                String dateTime = format.format(Instant.now());
                args.setStartTime(dateTime);
                return cmd.execute(args);
            }
            catch (ParameterException e) {
                log.error("Error code: {}. Invalid arguments: {}", (Object)3, (Object)e.getMessage());
                help.printHelp();
                return 3;
            }
            catch (IllegalArgumentException ignored) {
                log.error("Error code: {}. Unknown command: {}", (Object)2, (Object)arg);
                help.printHelp();
                return 2;
            }
        }
        catch (Throwable e) {
            log.error((Message)new ParameterizedMessage("Error code: {}. Unexpected exception", (Object)1), e);
            return 1;
        }
    }
}

