/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationStopTask;

public class CommandStop
extends CommandRemote {
    public static final String CMD_NAME = "STOP";
    public static final String ARG_FORCE_STOPPING = "-NOW";
    public static final String ARG_RECOVERY_ON_REPLICA = "-RECOVERY";
    private static final String HELP_USAGE_ARG_FORCE_STOPPING = "[-now]";
    private static final String HELP_USAGE_ARG_RECOVERY_ON_REPLICA = "[-recovery]";
    private static final String HELP_EXAMPLE_ARG_FORCE_STOPPING = "-now";
    private static final String HELP_ARG_FORCE_STOPPING = "-now - forcibly stops the replication process on master or replica cluster.";
    private static final String HELP_ARG_RECOVERY_ON_REPLICA1 = "-recovery - for replica cluster only. After stopping replication process recovery operation";
    private static final String HELP_ARG_RECOVERY_ON_REPLICA2 = "  is immediately executed by available wal segments. (PITR must be enabled in snapshot configuration).";

    public CommandStop() {
        this.supportedArgs.add(ARG_FORCE_STOPPING);
        this.supportedArgs.add(ARG_RECOVERY_ON_REPLICA);
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 6000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command stops the replication session.");
        this.addHelpUsage(HELP_USAGE_ARG_FORCE_STOPPING, HELP_USAGE_ARG_RECOVERY_ON_REPLICA);
        this.addHelpExample();
        this.addHelpExample(null);
        this.addHelpExample(HELP_EXAMPLE_ARG_FORCE_STOPPING);
        this.addHelpExample(HELP_EXAMPLE_ARG_FORCE_STOPPING, "-output=my_file.txt");
        this.addHelpArguments();
        this.addHelpIndentLn(HELP_ARG_FORCE_STOPPING);
        this.addHelpIndent(HELP_ARG_RECOVERY_ON_REPLICA1);
        this.addHelpIndent(HELP_ARG_RECOVERY_ON_REPLICA2);
        this.NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareTextOutput(VisorReplicationInfo info) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("sessionId: " + info.sessionId());
        lines.add("stopped: true");
        lines.add("forciblyStopped: " + info.forcibleStop());
        lines.add("recovery: " + info.recovery());
        if (info.recovery()) {
            lines.add("recoveryTime: " + info.resultRecoveryTime());
        }
        return lines;
    }

    private void printToOutputJson(VisorReplicationInfo info) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("sessionId", info.sessionId());
        json.put("stopped", true);
        json.put("forciblyStopped", info.forcibleStop());
        json.put("recovery", info.recovery());
        if (info.recovery()) {
            json.put("recoveryTime", info.resultRecoveryTime());
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorReplicationInfo info) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorReplicationInfo res = (VisorReplicationInfo)this.execute(VisorReplicationStopTask.class, new VisorReplicationInfo.Builder().withForcibleStop(this.hasArg(ARG_FORCE_STOPPING)).withRecovery(this.hasArg(ARG_RECOVERY_ON_REPLICA)).build());
        this.printToConsole(this.prepareTextOutput(res));
        this.printToOutput(res);
        return 0;
    }
}

