/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationDebugTask;

public class CommandDebug
extends CommandRemote {
    public static final String CMD_NAME = "DEBUG";
    public static final String ARG_MODE = "-MODE";
    private static final String HELP_USAGE_ARG_MODE = "-mode=none|pause_on_failure|pause_on_every_cut";
    private static final String HELP_ARG_MODE = "mode - specifies the debug mode of the replica cluster. Possible values are: none, pause_on_failure, pause_on_every_cut";

    public CommandDebug() {
        this.supportedArgs.add(ARG_MODE);
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 11000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command allows switch debug mode of replica cluster.");
        this.addHelpUsage(HELP_USAGE_ARG_MODE);
        this.addHelpExample();
        this.addHelpExample("-mode=none");
        this.addHelpExample("-mode=pause_on_failure");
        this.addHelpExample("-mode=pause_on_every_cut");
        this.addHelpArguments();
        this.addHelpIndentLn(HELP_ARG_MODE);
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    @Override
    protected int executeCmd() throws Throwable {
        DebugMode debugMode = this.enumArg(ARG_MODE, DebugMode.class);
        Map res = (Map)this.execute(VisorReplicationDebugTask.class, debugMode);
        if (F.isEmpty((Map)res)) {
            return 0;
        }
        IgniteException e = new IgniteException();
        for (Map.Entry entry : res.entrySet()) {
            e.addSuppressed((Throwable)entry.getValue());
        }
        throw e;
    }
}

