/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.txdr.VisorConsistentCutInfo;
import org.gridgain.grid.internal.visor.txdr.VisorCreateConsistentCutTask;

public class CommandCreateConsistentCut
extends CommandRemote {
    public static final String CMD_NAME = "CUT";

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 8000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command create a consistent cut.");
        this.addHelpExample();
        this.addHelpArguments();
        this.NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareTextOutput(VisorConsistentCutInfo info) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.valueOf(info.id()));
        lines.add("Consistent cut created: true");
        lines.add("  ID: " + info.id());
        return lines;
    }

    private void printToOutputJson(VisorConsistentCutInfo info) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", info.id());
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorConsistentCutInfo info) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorConsistentCutInfo info = (VisorConsistentCutInfo)this.execute(VisorCreateConsistentCutTask.class, new VisorConsistentCutInfo.Builder().build());
        this.printToConsole(this.prepareTextOutput(info));
        this.printToOutput(info);
        return 0;
    }
}

