/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationBootstrapTask;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;

public class CommandBootstrap
extends CommandRemote {
    public static final String CMD_NAME = "BOOTSTRAP";
    public static final String ARG_ROLE = "-ROLE";
    public static final String ARG_SNAPSHOT_MOVE_FOLDER = "-SNAPSHOT_FOLDER";
    public static final String ARG_SESSION_ID = "-SESSION_ID";
    private static final String HELP_USAGE_ARG_ROLE = "-role=master|replica";
    private static final String HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER = "-snapshot_folder=/network/attached/storage";
    private static final String HELP_USAGE_ARG_SESSION_ID = "-session_id=12345";
    private static final String HELP_ARG_ROLE = "role - specifies the role of the cluster. Possible values are: master, replica";
    private static final String HELP_ARG_SNAPSHOT_MOVE_FOLDER = "snapshot_folder - specifies a destination folder where the snapshot will be moved in case of bootstrapping the master cluster and source folder in case of bootstrapping the replica cluster.";
    private static final String HELP_ARG_SESSION_ID = "session_id - specifies the snapshot id that will be used to restore the state of the replica cluster.";

    public CommandBootstrap() {
        this.supportedArgs.add(ARG_ROLE);
        this.supportedArgs.add(ARG_SNAPSHOT_MOVE_FOLDER);
        this.supportedArgs.add(ARG_SESSION_ID);
        this.supportedArgs.add("-ARCHIVE");
        this.supportedArgs.add("-COMPRESSION_LEVEL");
        this.supportedArgs.add("-PARALLELISM");
        this.supportedArgs.add("-SINGLE_COPY");
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 2000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command executes the bootstrap method on the master or replica cluster.");
        this.addHelpUsage(HELP_USAGE_ARG_ROLE, HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER, HELP_USAGE_ARG_SESSION_ID, this.optional("-parallelism=4"), this.optional("-archive=NONE|ZIP"), this.optional("-compression_level=5"), this.optional("-single_copy"));
        this.addHelpExample();
        this.addHelpExample("-role=master", HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER);
        this.addHelpExample("-role=master", HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER, "parallelism=4");
        this.addHelpExample("-role=master", HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER, "-archive=NONE", "-single_copy");
        this.addHelpExample("-role=master", HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER, "-compression_level=8");
        this.addHelpExample("-role=replica", HELP_USAGE_ARG_SNASHOT_MOVE_FOLDER, HELP_USAGE_ARG_SESSION_ID);
        this.addHelpArguments();
        this.addHelpIndentLn(HELP_ARG_ROLE);
        this.addHelpIndentLn(HELP_ARG_SNAPSHOT_MOVE_FOLDER);
        this.addHelpIndentLn(HELP_ARG_SESSION_ID);
        this.addHelpIndentLn("-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N");
        this.addHelpIndentLn(HELP_ARG_ARCHIVE);
        this.addHelpIndentLn(HELP_ARG_COMPRESSION_LEVEL);
        this.addHelpIndentLn("-single_copy - will synchronize node to copy partition files exactly once.");
        this.addHelpCommonArgs();
    }

    @Override
    protected int executeCmd() throws Throwable {
        ClusterRole role;
        try {
            role = ClusterRole.valueOf((String)this.stringArg(ARG_ROLE, "").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value for the argument '-ROLE': " + this.stringArg(ARG_ROLE, "") + ". Possible values are: master, replica.");
        }
        if (role == ClusterRole.DISABLED) {
            throw new IllegalArgumentException("Invalid value for the argument '-ROLE': " + this.stringArg(ARG_ROLE, "") + ". If you want to stop the replication, please use 'stop' command instead.");
        }
        String folder = this.stringArg(ARG_SNAPSHOT_MOVE_FOLDER, null);
        long snapshotId = this.longArg(ARG_SESSION_ID, -1L);
        int parallelism = this.intArg("-PARALLELISM", 2);
        CompressionOption compressionOption = CompressionOption.valueOf((String)this.stringArg("-ARCHIVE", CompressionOption.ZIP.name()));
        int compressionLevel = this.intArg("-COMPRESSION_LEVEL", -1);
        boolean singleFileCopy = this.hasArg("-SINGLE_COPY");
        if (role == ClusterRole.REPLICA && snapshotId < 0L) {
            throw new IllegalArgumentException("Session ID is not specified.");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Snapshot folder is not specified.");
        }
        VisorReplicationInfo res = (VisorReplicationInfo)this.execute(VisorReplicationBootstrapTask.class, new VisorReplicationInfo.Builder().withRole(role).withSnapshotFolder(folder).withSessionId(snapshotId).withParallelism(parallelism).withCompressionOption(compressionOption).withCompressionLevel(compressionLevel).withSingleFileCopy(singleFileCopy).build());
        this.printToConsole(this.prepareTextOutput(res));
        this.printToOutput(res);
        return 0;
    }

    private Collection<String> prepareTextOutput(VisorReplicationInfo info) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("sessionId: " + info.sessionId());
        lines.add("role: " + info.role().name());
        lines.add("snapshotFolder: " + info.snapshotFolder());
        return lines;
    }

    private void printToOutputJson(VisorReplicationInfo info) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("sessionId", info.sessionId());
        json.put("role", info.role().name());
        json.put("snapshotFolder", info.snapshotFolder());
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorReplicationInfo info) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info);
                break;
            }
        }
    }
}

