/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.txdr.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.txdr.VisorApplyConsistentCutTask;
import org.gridgain.grid.internal.visor.txdr.VisorConsistentCutInfo;

public class CommandApplyConsistentCut
extends CommandRemote {
    public static final String CMD_NAME = "APPLY";
    public static final String ARG_CONSISTENT_CUT_ID = "-TO";
    public static final String ARG_LAST_CONSISTENT_CUT_ID = "-FROM";
    private static final String HELP_USAGE_ARG_CONSISTENT_CUT_ID = "-to=CONSISTENT_CUT_ID2";
    private static final String HELP_USAGE_ARG_LAST_CONSISTENT_CUT_ID = "-from=CONSISTENT_CUT_ID1";
    private static final String HELP_EXAMPLE_ARG_CONSISTENT_CUT_ID = "-to=54321";
    private static final String HELP_EXAMPLE_ARG_LAST_CONSISTENT_CUT_ID = "-from=12345";
    private static final String HELP_ARG_CONSISTENT_CUT_ID = "-to - specifies the consistent cut id that will be applied.";
    private static final String HELP_ARG_LAST_CONSISTENT_CUT_ID = "-from - specifies the last applied consistent cut id or the snapshot id in case of the first applying.";

    public CommandApplyConsistentCut() {
        this.supportedArgs.add(ARG_CONSISTENT_CUT_ID);
        this.supportedArgs.add(ARG_LAST_CONSISTENT_CUT_ID);
    }

    @Override
    public String name() {
        return CMD_NAME;
    }

    @Override
    public int errorBase() {
        return 9000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command applies a consistent cut(s) on the replica cluster.");
        this.addHelpUsage(HELP_USAGE_ARG_LAST_CONSISTENT_CUT_ID, HELP_USAGE_ARG_CONSISTENT_CUT_ID);
        this.addHelpExample();
        this.addHelpExample(HELP_EXAMPLE_ARG_LAST_CONSISTENT_CUT_ID, HELP_EXAMPLE_ARG_CONSISTENT_CUT_ID);
        this.addHelpExample(HELP_EXAMPLE_ARG_LAST_CONSISTENT_CUT_ID, HELP_EXAMPLE_ARG_CONSISTENT_CUT_ID, "-output=my_file.txt");
        this.addHelpArguments();
        this.addHelpIndentLn(HELP_ARG_LAST_CONSISTENT_CUT_ID);
        this.addHelpIndentLn(HELP_ARG_CONSISTENT_CUT_ID);
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareTextOutput(VisorConsistentCutInfo info, boolean applied) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.valueOf(info.id()));
        lines.add("Consistent cut applied: " + applied);
        lines.add("  ID: " + info.id());
        return lines;
    }

    private void printToOutputJson(VisorConsistentCutInfo info, boolean applied) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", info.id());
        json.put("applied", applied);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(VisorConsistentCutInfo info, boolean applied) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(info, applied));
                break;
            }
            case "JSON": {
                this.printToOutputJson(info, applied);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        long cutId = this.longArg(ARG_CONSISTENT_CUT_ID, -1L);
        long lastAppliedId = this.longArg(ARG_LAST_CONSISTENT_CUT_ID, -1L);
        if (cutId < 0L) {
            throw new IllegalArgumentException("Consistent cut id is not specified.");
        }
        if (lastAppliedId < 0L) {
            throw new IllegalArgumentException("The last applied consistent cut id is not specified.");
        }
        VisorConsistentCutInfo info = new VisorConsistentCutInfo.Builder().withId(cutId).withLastAppliedId(lastAppliedId).build();
        Map res = (Map)this.execute(VisorApplyConsistentCutTask.class, info);
        if (F.isEmpty((Map)res)) {
            this.printToConsole(this.prepareTextOutput(info, true));
            this.printToOutput(info, true);
            return 0;
        }
        IgniteException e = new IgniteException();
        for (Map.Entry entry : res.entrySet()) {
            e.addSuppressed((Throwable)entry.getValue());
        }
        throw e;
    }
}

