/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorChangeSnapshotSecurityLevelTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorDisplaySnapshotSecurityLevelTask;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;

public class CommandSecurityLevel
extends CommandRemote {
    public static final String COMMAND_NAME = "SECURITY_LEVEL";
    private static final String ARG_LEVEL = "-LEVEL";
    private static final String LEVELS_CHOICE = Arrays.stream(SnapshotSecurityLevel.values()).map(Enum::name).collect(Collectors.joining("|"));
    private static final String HELP_USAGE_LEVEL = "[-level=<" + LEVELS_CHOICE + ">]";
    private static final String HELP_ARG_LEVEL = "-level=<" + LEVELS_CHOICE + "> - snapshot security level to set. If this argument is omitted, current level will be displayed.";

    public CommandSecurityLevel() {
        this.supportedArgs.add(ARG_LEVEL);
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected int executeCmd() throws Throwable {
        boolean setLevel = this.hasArg(ARG_LEVEL);
        if (setLevel) {
            SnapshotSecurityLevel level = this.enumArg(ARG_LEVEL, SnapshotSecurityLevel.class);
            this.execute(VisorChangeSnapshotSecurityLevelTask.class, level);
            this.printToConsole("Snapshot security level has been set");
            this.printToOutput(level);
        } else {
            SnapshotSecurityLevel level = (SnapshotSecurityLevel)this.execute(VisorDisplaySnapshotSecurityLevelTask.class, null);
            this.printToConsole("Snapshot security level is " + level.name());
            this.printToOutput(level);
        }
        return 0;
    }

    @Override
    public String name() {
        return COMMAND_NAME;
    }

    @Override
    public int errorBase() {
        return 18000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will display or change cluster-wide snapshot security level");
        this.addHelpUsage(HELP_USAGE_LEVEL, "[-verbose]");
        this.addHelpArguments();
        this.addHelpIndent(HELP_ARG_LEVEL).NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpErrorOutput();
    }

    private void printToOutput(SnapshotSecurityLevel level) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(level));
                break;
            }
            case "JSON": {
                this.printToOutputJson(level);
                break;
            }
        }
    }

    private Collection<String> prepareTextOutput(SnapshotSecurityLevel level) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Snapshot security level status:");
        lines.add("  Level: " + level);
        if (this.hasArg(ARG_LEVEL)) {
            lines.add("  Changed: true");
        }
        return lines;
    }

    private void printToOutputJson(SnapshotSecurityLevel level) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("level", level.name());
        if (this.hasArg(ARG_LEVEL)) {
            json.put("changed", true);
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }
}

