/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import it.sauronsoftware.cron4j.SchedulingPattern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCollectSnapshotSchedulesTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorDeleteSnapshotScheduleTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorScheduleSnapshotOperationTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotSchedule;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.internal.visor.database.snapshot.VisorToggleSnapshotScheduleEnabledStateTask;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

public class CommandSchedule
extends CommandRemote {
    protected static final long DFLT_TTL = 259200000L;
    private static final String ARG_LIST = "-LIST";
    private static final String ARG_NAME = "-NAME";
    private static final String ARG_FREQUENCY = "-FREQUENCY";
    private static final String ARG_FULL_FREQUENCY = "-FULL_FREQUENCY";
    private static final String ARG_INCREMENTAL_FREQUENCY = "-INCREMENTAL_FREQUENCY";
    private static final String ARG_TTL = "-TTL";
    private static final String ARG_ENABLE = "-ENABLE";
    private static final String ARG_DISABLE = "-DISABLE";
    private static final String ARG_DELETE = "-DELETE";
    private static final String ARG_FOR_OLDEST = "-FOR-OLDEST";
    private static final String ARG_FOR_LATEST = "-FOR-LATEST";
    private static final String ARG_EXEC_AFTER = "-EXEC-AFTER";
    private static final String ARG_KEEP_COUNT = "-KEEP";
    private static final String HELP_USAGE_LIST = "-list";
    private static final String HELP_USAGE_NAME = "-name=SCHEDULE_NAME";
    private static final String HELP_USAGE_COMMAND_CREATE = "-command=create";
    private static final String HELP_USAGE_FULL_FREQUENCY = "-full_frequency=FREQUENCY";
    private static final String HELP_USAGE_INC_FREQUENCY = "[-incremental_frequency=FREQUENCY]";
    private static final String HELP_USAGE_COMMAND_DELETE = "-command=delete";
    private static final String HELP_USAGE_TTL = "-ttl=TTL";
    private static final String HELP_USAGE_FOR_OLDEST = "-for-oldest";
    private static final String HELP_USAGE_FOR_LATEST = "-for-latest";
    private static final String HELP_USAGE_EXEC_AFTER = "-exec-after=PREVIOUS_TASK";
    private static final String HELP_USAGE_KEEP_COUNT = "-keep=KEEP_COUNT";
    private static final String HELP_USAGE_FREQUENCY = "-frequency=hourly";
    private static final String HELP_USAGE_COMMAND_MOVE = "-command=move";
    private static final String HELP_USAGE_COMMAND_CHECK = "-command=check";
    private static final String HELP_USAGE_ENABLE = "-enable";
    private static final String HELP_USAGE_DISABLE = "-disable";
    private static final String HELP_USAGE_DELETE = "-delete";
    private static final String HELP_EXAMPLE_NAME = "-name=my_schedule";
    private static final String HELP_EXAMPLE_TTL = "-ttl=3d";
    private static final String HELP_EXAMPLE_FOR_OLDEST = "-for-oldest=1";
    private static final String HELP_EXAMPLE_FOR_LATEST = "-for-latest=1";
    private static final String HELP_EXAMPLE_EXEC_AFTER = "-exec-after=schedule_create_snapshot";
    private static final String HELP_EXAMPLE_FULL_FREQUENCY = "-full_frequency=daily";
    private static final String HELP_EXAMPLE_INC_FREQUENCY = "-incremental_frequency=hourly";
    private static final String HELP_EXAMPLE_KEEP_COUNT = "-keep=2";
    private static final String HELP_ARG_LIST = "-list - list all registered schedules.";
    private static final String HELP_ARG_NAME = "-name=SCHEDULE_NAME - specify schedule name.";
    private static final String HELP_ARG_COMMAND = "-command=create | delete | move | check - specify snapshot operation to schedule.";
    private static final String HELP_ARG_FULL_FREQUENCY = "-full_frequency=FREQUENCY - specify frequency for full snapshots.";
    private static final String HELP_ARG_INC_FREQUENCY = "-incremental_frequency=FREQUENCY - specify frequency for incremental snapshots.";
    private static final String HELP_ARG_FREQUENCY = "-frequency=FREQUENCY - specify frequency for snapshots TTL check in order to delete or move obsolete snapshots.";
    private static final String HELP_ARG_TTL = "-ttl=TTL - specify period after which snapshots will be considered as obsolete.";
    private static final String HELP_ARG_ENABLE = "-enable - enable specified schedule.";
    private static final String HELP_ARG_DISABLE = "-disable - disable specified schedule.";
    private static final String HELP_ARG_DELETE = "-delete - delete specified schedule.";
    private static final String HELP_ARG_FOR_OLDEST = "-for-oldest=N - select N oldest snapshots.";
    private static final String HELP_ARG_FOR_LATEST = "-for-latest=N - select N latest snapshots.";
    private static final String HELP_ARG_EXEC_AFTER = "-exec-after=prev_schedule - execute after successful completion of schedule \"prev_schedule\". If this parameter is used, -FREQUENCY is not needed.";
    private static final String HELP_ARG_KEEP_COUNT = "-keep=N - keep N latest full snapshots and their dependants (default is 1).";

    public CommandSchedule() {
        this.supportedArgs.add(ARG_LIST);
        this.supportedArgs.add(ARG_NAME);
        this.supportedArgs.add("-COMMAND");
        this.supportedArgs.add(ARG_FULL_FREQUENCY);
        this.supportedArgs.add(ARG_INCREMENTAL_FREQUENCY);
        this.supportedArgs.add("-CACHES");
        this.supportedArgs.add(ARG_FREQUENCY);
        this.supportedArgs.add(ARG_TTL);
        this.supportedArgs.add(ARG_FOR_OLDEST);
        this.supportedArgs.add(ARG_FOR_LATEST);
        this.supportedArgs.add(ARG_EXEC_AFTER);
        this.supportedArgs.add(ARG_KEEP_COUNT);
        this.supportedArgs.add("-DEST");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add(ARG_ENABLE);
        this.supportedArgs.add(ARG_DISABLE);
        this.supportedArgs.add(ARG_DELETE);
        this.supportedArgs.add("-VERBOSE");
        this.supportedArgs.add("-ARCHIVE");
        this.supportedArgs.add("-COMPRESSION_LEVEL");
        this.supportedArgs.add("-PARALLELISM");
        this.supportedArgs.add("-WRITE_THROTTLING");
    }

    @Override
    public String name() {
        return "SCHEDULE";
    }

    @Override
    public int errorBase() {
        return 12000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will schedule snapshot operation in cluster.");
        this.addHelpUsage(HELP_USAGE_LIST, "[-verbose]");
        this.addHelp("List all registered schedules.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_COMMAND_CREATE, "[-caches=cache1,cache2,...,cacheN]", HELP_USAGE_FULL_FREQUENCY, HELP_USAGE_INC_FREQUENCY, "[-verbose]", this.optional("-archive=NONE|ZIP"), this.optional("-compression_level=5"), this.optional("-parallelism=4"));
        this.addHelp("Schedule snapshots creation.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_COMMAND_DELETE, this.optional(HELP_USAGE_TTL), this.optional(HELP_USAGE_FOR_OLDEST), this.optional(HELP_USAGE_FOR_LATEST), this.optional(this.alternation(HELP_USAGE_FREQUENCY, HELP_USAGE_EXEC_AFTER)), this.optional(HELP_USAGE_KEEP_COUNT), "[-verbose]");
        this.addHelp("Schedule snapshots deletion.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_COMMAND_MOVE, "-dest=EXTERNAL_FOLDER", this.optional(HELP_USAGE_TTL), this.optional(HELP_USAGE_FOR_OLDEST), this.optional(HELP_USAGE_FOR_LATEST), this.optional(this.alternation(HELP_USAGE_FREQUENCY, HELP_USAGE_EXEC_AFTER)), "[-verbose]");
        this.addHelp("Schedule snapshots moving.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_COMMAND_CHECK, this.optional(HELP_USAGE_TTL), this.optional(HELP_USAGE_FOR_OLDEST), this.optional(HELP_USAGE_FOR_LATEST), this.optional(this.alternation(HELP_USAGE_FREQUENCY, HELP_USAGE_EXEC_AFTER)), "[-verbose]");
        this.addHelp("Schedule snapshots check.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_ENABLE, "[-verbose]");
        this.addHelp("Enabled specified schedule.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_DISABLE, "[-verbose]");
        this.addHelp("Disable specified schedule.");
        this.addHelpUsage(HELP_USAGE_NAME, HELP_USAGE_DELETE, "[-verbose]");
        this.addHelp("Delete specified schedule.").NL();
        this.addHelp("Where FREQUENCY could be one of the following:");
        this.addHelp("  15mins - execute every 15 minutes");
        this.addHelp("  30mins - execute every 30 minutes");
        this.addHelp("  hourly - execute every hour");
        this.addHelp("  daily - execute every day at 00:00");
        this.addHelp("  weekly - execute every sunday at 00:00");
        this.addHelp("  any valid CRON expression, for example: 0 0 * * *").NL();
        this.addHelp("You can specify EXEC_AFTER instead of FREQUENCY. This will make your schedule execute after successful completion of another scheduled operation.").NL();
        this.addHelp("Where TTL could be one of the following:");
        this.addHelp("  Nd - NN days, for example: 3d");
        this.addHelp("  Nh - NN hours, for example: 12h");
        this.addHelp("  Nm - NN minutes, for example: 90m");
        this.addHelp("  N - NN milliseconds, for example: 100000");
        this.addHelp("You should specify only one of filters: TTL, FOR_OLDEST or FOR_LATEST filter.");
        this.addHelpExample();
        this.addHelpExample(HELP_USAGE_LIST);
        this.addHelpExample(HELP_USAGE_LIST, "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample(HELP_USAGE_LIST, "-verbose");
        this.addHelpExample(HELP_USAGE_LIST, "-host=192.168.1.10");
        this.addHelpExample(HELP_USAGE_COMMAND_CREATE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_FULL_FREQUENCY);
        this.addHelpExample(HELP_USAGE_COMMAND_CREATE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_FULL_FREQUENCY, HELP_EXAMPLE_INC_FREQUENCY);
        this.addHelpExample(HELP_USAGE_COMMAND_CREATE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_FULL_FREQUENCY, HELP_EXAMPLE_INC_FREQUENCY, "-archive=NONE|ZIP", "-compression_level=5", "-parallelism=4");
        this.addHelpExample(HELP_USAGE_COMMAND_DELETE, HELP_EXAMPLE_NAME);
        this.addHelpExample(HELP_USAGE_COMMAND_DELETE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_TTL);
        this.addHelpExample(HELP_USAGE_COMMAND_DELETE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_FOR_OLDEST);
        this.addHelpExample(HELP_USAGE_COMMAND_DELETE, HELP_EXAMPLE_NAME, HELP_EXAMPLE_KEEP_COUNT);
        this.addHelpExample(HELP_USAGE_COMMAND_MOVE, HELP_EXAMPLE_NAME, "-dest=/snapshots/2017/01");
        this.addHelpExample(HELP_USAGE_COMMAND_MOVE, HELP_EXAMPLE_NAME, "-dest=/snapshots/2017/01", "-key_alias=my_sftp");
        this.addHelpExample(HELP_USAGE_COMMAND_MOVE, HELP_EXAMPLE_NAME, "-dest=/snapshots/2017/01", HELP_EXAMPLE_TTL);
        this.addHelpExample(HELP_USAGE_COMMAND_CHECK, HELP_EXAMPLE_NAME, HELP_EXAMPLE_FOR_LATEST, HELP_EXAMPLE_EXEC_AFTER);
        this.addHelpExample(HELP_USAGE_ENABLE, HELP_EXAMPLE_NAME);
        this.addHelpExample(HELP_USAGE_DISABLE, HELP_EXAMPLE_NAME);
        this.addHelpExample(HELP_USAGE_DELETE, HELP_EXAMPLE_NAME);
        this.addHelpArguments();
        this.addHelpIndent(HELP_ARG_LIST).NL();
        this.addHelpIndent("-verbose - this argument enable verbose mode, for example, cache names.").NL();
        this.addHelpIndent(HELP_ARG_NAME).NL();
        this.addHelpIndent(HELP_ARG_COMMAND).NL();
        this.addHelpIndent("-caches=cache1,...,cacheN,group1,...,groupK - list of cache or group names to process.").NL();
        this.addHelpIndent(HELP_ARG_FULL_FREQUENCY).NL();
        this.addHelpIndent(HELP_ARG_INC_FREQUENCY).NL();
        this.addHelpIndent(HELP_ARG_FREQUENCY).NL();
        this.addHelpIndent(HELP_ARG_TTL).NL();
        this.addHelpIndent(HELP_ARG_FOR_OLDEST).NL();
        this.addHelpIndent(HELP_ARG_FOR_LATEST).NL();
        this.addHelpIndent(HELP_ARG_EXEC_AFTER).NL();
        this.addHelpIndent(HELP_ARG_KEEP_COUNT).NL();
        this.addHelpIndent("-dest=EXTERNAL_FOLDER - folder name where snapshot files should be moved.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent(HELP_ARG_ENABLE).NL();
        this.addHelpIndent(HELP_ARG_DISABLE).NL();
        this.addHelpIndent(HELP_ARG_DELETE).NL();
        this.addHelpIndent(HELP_ARG_ARCHIVE).NL();
        this.addHelpIndent(HELP_ARG_COMPRESSION_LEVEL).NL();
        this.addHelpIndent("-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N").NL();
        this.addHelpIndent("-write_throttling=N - this argument enables write throttling. Snapshot write speed will be throttled when reached N bytes per second on each node. Only non-negative values are supported, default value is 0 - no throttling.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(420, "ignite-schedule module not found in cluster nodes classpath.");
        this.addHelpError(430, "schedule with specified name not found.");
        this.addHelpError(440, "schedule with specified name already exists.");
        this.addHelpError(770, "invalid compression level, should be between 1 and 9.");
        this.addHelpError(780, "compression level couldn't be applied, cause compression is off.");
        this.addHelpErrorOutput();
    }

    private Long ttl() {
        String ttl = this.stringArg(ARG_TTL, "3d").toLowerCase();
        try {
            return VisorSnapshots.timeToMilliseconds((String)ttl);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value for argument 'TTL': " + ttl, nfe);
        }
    }

    private String snapshotFiltersTextOutput(VisorSnapshotSchedule schedule) {
        return schedule.getTtl() != -1L ? "TTL: " + VisorSnapshots.millisecondsToTime((long)schedule.getTtl()) : (schedule.forOldest() != -1 ? "For oldest snapshots count: " + schedule.forOldest() : "For latest snapshots count: " + schedule.forLatest());
    }

    private Collection<String> prepareScheduleTextOutput(Collection<String> lines, VisorSnapshotSchedule schedule, int level, int idx, boolean verbose) {
        StringBuilder tab = new StringBuilder();
        for (int l = 0; l < level; ++l) {
            tab.append("  ");
        }
        SnapshotOperationType opType = schedule.getOperationType();
        long ttl = schedule.getTtl();
        if (idx > 0) {
            lines.add(tab + "#: " + idx);
        }
        lines.add(tab + "Name: " + schedule.getName());
        lines.add(tab + "Command: " + opType);
        lines.add(tab + "State: " + (schedule.isEnabled() ? "enabled" : "disabled"));
        switch (opType) {
            case CREATE: {
                lines.add(tab + "Full snapshot frequency: " + VisorSnapshots.fromCron((String)schedule.getFullSnapshotFrequency()));
                lines.add(tab + "Incremental snapshot frequency: " + VisorSnapshots.fromCron((String)schedule.getIncrementalSnapshotFrequency()));
                lines.add(tab + "Compression: " + schedule.getSnapshotCreateParams().snapshotCompressionOption());
                lines.add(tab + "Compression level: " + schedule.getSnapshotCreateParams().compressionLevel());
                lines.add(tab + "Write throttling threshold: " + schedule.getSnapshotCreateParams().writeThrottlingThreshold());
                int parallelism = schedule.getSnapshotCommonParameters().getSnapshotOperationParallelism();
                lines.add(tab + "Parallelism level: " + parallelism);
                Set cacheNames = schedule.getCacheNames();
                if (F.isEmpty((Collection)cacheNames)) {
                    lines.add(tab + "Caches: ALL");
                    break;
                }
                lines.add(tab + "Caches:");
                lines.add(tab + "  Count: " + cacheNames.size());
                if (!verbose) break;
                lines.add(tab + "  Names: " + this.sorted(cacheNames));
                break;
            }
            case DELETE: 
            case CHECK: {
                lines.add(tab + this.snapshotFiltersTextOutput(schedule));
                lines.add(tab + "Check frequency: " + schedule.getFullSnapshotFrequency());
                break;
            }
            case MOVE: {
                lines.add(tab + this.snapshotFiltersTextOutput(schedule));
                lines.add(tab + "Check frequency: " + schedule.getFullSnapshotFrequency());
                lines.add(tab + "Destination: " + schedule.getDestination());
                break;
            }
            default: {
                lines.add("Unsupported command: " + opType);
            }
        }
        return lines;
    }

    private Collection<String> prepareScheduleListTextOutput(List<VisorSnapshotSchedule> schedules, boolean verbose) {
        ArrayList<String> lines = new ArrayList<String>();
        if (F.isEmpty(schedules)) {
            lines.add("No schedules found");
        } else {
            lines.add("Schedules in cluster: " + schedules.size());
            lines.add("--------------------------------------------------------------------------------");
            int idx = 1;
            for (VisorSnapshotSchedule schedule : schedules) {
                this.prepareScheduleTextOutput(lines, schedule, 1, idx, verbose);
                lines.add("--------------------------------------------------------------------------------");
                ++idx;
            }
        }
        return lines;
    }

    private void printScheduleToOutputJson(ObjectNode json, VisorSnapshotSchedule schedule) {
        SnapshotOperationType opType = schedule.getOperationType();
        long ttl = schedule.getTtl();
        json.put("name", schedule.getName());
        json.put("command", opType.toString());
        json.put("state", schedule.isEnabled() ? "enabled" : "disabled");
        switch (opType) {
            case CREATE: {
                json.put("fullSnapshotFrequency", VisorSnapshots.fromCron((String)schedule.getFullSnapshotFrequency()));
                json.put("incrementalSnapshotFrequency", VisorSnapshots.fromCron((String)schedule.getIncrementalSnapshotFrequency()));
                json.put("compression", schedule.getSnapshotCreateParams().snapshotCompressionOption().name());
                json.put("compressionLevel", schedule.getSnapshotCreateParams().compressionLevel());
                json.put("writeThrottlingThreshold", schedule.getSnapshotCreateParams().writeThrottlingThreshold());
                int parallelism = schedule.getSnapshotCommonParameters().getSnapshotOperationParallelism();
                json.put("parallelismLevel", parallelism);
                Set cacheNames = schedule.getCacheNames();
                this.addJsonCaches(json, cacheNames);
                break;
            }
            case DELETE: {
                json.put("ttl", ttl);
                json.put("checkFrequency", schedule.getFullSnapshotFrequency());
                break;
            }
            case MOVE: {
                json.put("ttl", ttl);
                json.put("checkFrequency", schedule.getFullSnapshotFrequency());
                json.put("destination", schedule.getDestination());
                break;
            }
        }
    }

    private void printScheduleListToOutputJson(List<VisorSnapshotSchedule> schedules) throws IOException {
        ArrayNode json = MAPPER.createArrayNode();
        for (VisorSnapshotSchedule schedule : schedules) {
            ObjectNode scheduleJson = MAPPER.createObjectNode();
            this.printScheduleToOutputJson(scheduleJson, schedule);
            json.add((JsonNode)scheduleJson);
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printScheduleToOutput(VisorSnapshotSchedule schedule) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareScheduleTextOutput(new ArrayList<String>(), schedule, 0, -1, true));
                break;
            }
            case "JSON": {
                ObjectNode json = MAPPER.createObjectNode();
                this.printScheduleToOutputJson(json, schedule);
                this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
                break;
            }
        }
    }

    private void printScheduleListToOutput(List<VisorSnapshotSchedule> schedules) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareScheduleListTextOutput(schedules, true));
                break;
            }
            case "JSON": {
                this.printScheduleListToOutputJson(schedules);
                break;
            }
        }
    }

    private int listSchedules() throws Throwable {
        List schedules = (List)this.execute(VisorCollectSnapshotSchedulesTask.class, null);
        this.printToConsole(this.prepareScheduleListTextOutput(schedules, this.hasArg("-VERBOSE")));
        this.printScheduleListToOutput(schedules);
        return 0;
    }

    private Collection<String> prepareStateChangeTextOutput(VisorSnapshotSchedule arg) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Name: " + arg.getName());
        lines.add("Enabled: " + arg.isEnabled());
        return lines;
    }

    private void printStateChangeToOutputJson(VisorSnapshotSchedule arg) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("name", arg.getName());
        json.put("enabled", arg.isEnabled());
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printStateChangeToOutput(VisorSnapshotSchedule arg) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareStateChangeTextOutput(arg));
                break;
            }
            case "JSON": {
                this.printStateChangeToOutputJson(arg);
                break;
            }
        }
    }

    private int changeEnabledState(VisorSnapshotSchedule arg) throws Throwable {
        this.execute(VisorToggleSnapshotScheduleEnabledStateTask.class, arg);
        this.printToConsole(this.prepareStateChangeTextOutput(arg));
        this.printStateChangeToOutput(arg);
        return 0;
    }

    private String frequency(String argName, String msg, String dflt) {
        String freq = this.stringArg(argName, dflt);
        if (F.isEmpty((String)freq) && !this.hasArg(ARG_EXEC_AFTER)) {
            throw new IllegalArgumentException("Schedule for " + msg + " was not specified");
        }
        if (!SchedulingPattern.validate((String)VisorSnapshots.toCron((String)freq))) {
            throw new IllegalArgumentException("Invalid cron expression: " + freq);
        }
        return freq;
    }

    private Collection<String> prepareDeleteTextOutput(VisorSnapshotSchedule arg) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Name: " + arg.getName());
        lines.add("Deleted: true");
        return lines;
    }

    private void printDeleteToOutputJson(VisorSnapshotSchedule arg) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("name", arg.getName());
        json.put("deleted", true);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printDeleteToOutput(VisorSnapshotSchedule arg) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareDeleteTextOutput(arg));
                break;
            }
            case "JSON": {
                this.printDeleteToOutputJson(arg);
                break;
            }
        }
    }

    private int delete(VisorSnapshotSchedule arg) throws Throwable {
        this.execute(VisorDeleteSnapshotScheduleTask.class, arg);
        this.printToConsole(this.prepareDeleteTextOutput(arg));
        this.printDeleteToOutput(arg);
        return 0;
    }

    private GridTuple3<Long, Integer, Integer> snapshotFilters() {
        boolean moreThanOneFilterSpecified;
        long ttl = this.hasArg(ARG_TTL) ? this.ttl() : -1L;
        int forOldest = this.intArg(ARG_FOR_OLDEST, -1);
        int forLatest = this.intArg(ARG_FOR_LATEST, -1);
        boolean bl = moreThanOneFilterSpecified = Stream.of(ttl, forOldest, forLatest).filter(a -> a != -1L).count() > 1L;
        if (moreThanOneFilterSpecified) {
            throw new IllegalArgumentException("Only one argument for snapshot filtering should be specified (-TTL, -FOR-OLDEST, -FOR-LATEST)");
        }
        if (Stream.of(ttl, forOldest, forLatest).noneMatch(a -> a != -1L)) {
            ttl = 259200000L;
        }
        return new GridTuple3((Object)ttl, (Object)forOldest, (Object)forLatest);
    }

    private void checkFrequencyAndChainingConflicts() {
        if ((this.hasArg(ARG_FREQUENCY) || this.hasArg(ARG_FULL_FREQUENCY) || this.hasArg(ARG_INCREMENTAL_FREQUENCY)) && this.hasArg(ARG_EXEC_AFTER)) {
            throw new IllegalArgumentException("You can specify either one of frequency parameters (" + this.alternation(ARG_FREQUENCY, ARG_FULL_FREQUENCY, ARG_INCREMENTAL_FREQUENCY) + ") or " + ARG_EXEC_AFTER + " parameter.");
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        VisorSnapshotSchedule arg = new VisorSnapshotSchedule();
        if (this.hasArg(ARG_LIST)) {
            return this.listSchedules();
        }
        String name = this.stringArg(ARG_NAME, "");
        if (F.isEmpty((String)name)) {
            throw new IllegalArgumentException("Schedule name was not specified");
        }
        this.checkFrequencyAndChainingConflicts();
        arg.setName(name);
        if (this.hasArg(ARG_ENABLE)) {
            arg.setEnabled(true);
            return this.changeEnabledState(arg);
        }
        if (this.hasArg(ARG_DISABLE)) {
            arg.setEnabled(false);
            return this.changeEnabledState(arg);
        }
        if (this.hasArg(ARG_DELETE)) {
            return this.delete(arg);
        }
        arg.execAfter(this.stringArg(ARG_EXEC_AFTER, null));
        String cmd = this.stringArg("-COMMAND", "");
        if (F.isEmpty((String)cmd)) {
            throw new IllegalArgumentException("Command was not specified");
        }
        if (SnapshotOperationType.CREATE.name().equalsIgnoreCase(cmd)) {
            arg.setOperationType(SnapshotOperationType.CREATE);
            arg.setFullSnapshotFrequency(this.frequency(ARG_FULL_FREQUENCY, "full snapshot", ""));
            if (this.hasArg(ARG_INCREMENTAL_FREQUENCY)) {
                arg.setIncrementalSnapshotFrequency(this.frequency(ARG_INCREMENTAL_FREQUENCY, "incremental snapshot", ""));
            }
            CompressionOption compressionOption = CompressionOption.valueOf((String)this.stringArg("-ARCHIVE", CompressionOption.NONE.name()));
            int compressionLevel = this.intArg("-COMPRESSION_LEVEL", -1);
            int writeThrottling = this.intArg("-WRITE_THROTTLING", 0);
            if (writeThrottling < 0) {
                throw new IllegalArgumentException("Write throttling threshold should be non-negative number: " + writeThrottling);
            }
            arg.setSnapshotCreateParams(new SnapshotCreateParams(compressionOption, compressionLevel, writeThrottling));
            int parallelism = this.intArg("-PARALLELISM", 2);
            arg.setSnapshotCommonParameters(new SnapshotCommonParameters(parallelism));
            arg.setCacheNames(this.setArg("-CACHES"));
        } else if (SnapshotOperationType.DELETE.name().equalsIgnoreCase(cmd) || SnapshotOperationType.MOVE.name().equalsIgnoreCase(cmd) || SnapshotOperationType.CHECK.name().equalsIgnoreCase(cmd)) {
            SnapshotOperationType opType = SnapshotOperationType.DELETE.name().equalsIgnoreCase(cmd) ? SnapshotOperationType.DELETE : (SnapshotOperationType.MOVE.name().equalsIgnoreCase(cmd) ? SnapshotOperationType.MOVE : SnapshotOperationType.CHECK);
            arg.setOperationType(opType);
            GridTuple3<Long, Integer, Integer> snapshotFilters = this.snapshotFilters();
            arg.setTtl((Long)snapshotFilters.get1());
            arg.forOldest(((Integer)snapshotFilters.get2()).intValue());
            arg.forLatest(((Integer)snapshotFilters.get3()).intValue());
            if (!this.hasArg(ARG_EXEC_AFTER)) {
                arg.setFullSnapshotFrequency(this.frequency(ARG_FREQUENCY, opType.name().toLowerCase() + " obsolete snapshots", "hourly"));
            }
            if (opType == SnapshotOperationType.MOVE) {
                String dest = this.stringArg("-DEST", "");
                if (dest.isEmpty()) {
                    throw new IllegalArgumentException("Destination folder was not specified");
                }
                arg.setDestination(dest);
                arg.setKeyAlias(this.stringArg("-KEY_ALIAS", null));
            }
            if (opType == SnapshotOperationType.DELETE) {
                int keepCount = this.intArg(ARG_KEEP_COUNT, 1);
                arg.keepCount(keepCount);
            }
        } else {
            throw new IllegalArgumentException("Unsupported command was specified: " + cmd);
        }
        arg.setEnabled(true);
        this.execute(VisorScheduleSnapshotOperationTask.class, arg);
        this.printToConsole(this.prepareScheduleTextOutput(new ArrayList<String>(), arg, 0, -1, this.hasArg("-VERBOSE")));
        this.printScheduleToOutput(arg);
        return 0;
    }
}

