/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.gridgain.database.utility.commands.CommandDirect;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class CommandMetadata
extends CommandDirect {
    private static final JdkMarshaller jdkMarshaller = new JdkMarshaller();
    private static final String ARG_ACTION = "-ACTION";
    private static final String ARG_FILE = "-FILE";
    private static final String ARG_DEST = "-DEST";
    private static final String ARG_TEMPLATE = "-TEMPLATE";
    private static final String HELP_USAGE_ACTION_PRINT = "-action=print";
    private static final String HELP_USAGE_ACTION_MERGE = "-action=merge";
    private static final String HELP_USAGE_FILE = "-file=METADATA_FILE";
    private static final String HELP_USAGE_DEST = "-dest=DEST_FILE";
    private static final String HELP_USAGE_TEMPLATE = "[-template=snapshot-meta.bin]";
    private static final String HELP_EXAMPLE_ACTION_PRINT = "-action=print";
    private static final String HELP_EXAMPLE_ACTION_MERGE = "-action=merge";
    private static final String HELP_EXAMPLE_FILE = "-file=METADATA_FILE";
    private static final String HELP_EXAMPLE_DEST = "-dest=dest.file";
    private static final String HELP_EXAMPLE_TEMPLATE = "-template=snapshot-meta.bin";
    private static final String HELP_ARG_ACTION = "-action=print|merge - snapshot metadata operation type.";
    private static final String HELP_ARG_FILE = "-file=METADATA_FILE - metadata file path to process.";
    private static final String HELP_ARG_DEST = "-dest=dest.file - path to file with merged metadata.";
    private static final String HELP_ARG_TEMPLATE = "-template=snapshot-meta.bin - a part of metadata file name for filter.";

    public CommandMetadata() {
        this.supportedArgs.add("-OUTPUT");
        this.supportedArgs.add("-FORMAT");
        this.supportedArgs.add(ARG_ACTION);
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add(ARG_FILE);
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-VERBOSE");
        this.supportedArgs.add(ARG_DEST);
        this.supportedArgs.add(ARG_TEMPLATE);
    }

    @Override
    public String name() {
        return "METADATA";
    }

    @Override
    public int errorBase() {
        return 14000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print metadata for snapshot with specified ID.");
        this.addHelpUsage("-action=print", "-src=SNAPSHOT_FOLDER", "-id=SNAPSHOT_ID", "[-verbose]", HELP_USAGE_TEMPLATE);
        this.addHelp("This command will print metadata for specified file.");
        this.addHelpUsage("-action=print", "-file=METADATA_FILE", "[-verbose]");
        this.addHelp("This command will merge snapshot metadata from different nodes into a single file.");
        this.addHelpUsage("-action=merge", "-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...]", "-id=SNAPSHOT_ID", HELP_USAGE_DEST, HELP_USAGE_TEMPLATE);
        this.addHelpExample("-action=print", "-src=SNAPSHOT_FOLDER1", "-id=1234567", "-verbose", HELP_EXAMPLE_TEMPLATE);
        this.addHelpExample("-action=print", "-file=METADATA_FILE", "-verbose");
        this.addHelpExample("-action=merge", "-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...]", "-id=1234567", HELP_EXAMPLE_DEST, HELP_EXAMPLE_TEMPLATE);
        this.addHelpArguments();
        this.addHelpIndent(HELP_ARG_ACTION).NL();
        this.addHelpIndent("-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...] - paths to folders with snapshots.").NL();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent(HELP_ARG_FILE).NL();
        this.addHelpIndent("-verbose - enable print information about partitions to console.").NL();
        this.addHelpIndent(HELP_ARG_DEST).NL();
        this.addHelpIndent(HELP_ARG_TEMPLATE).NL();
        this.addHelpCommonArgs(true);
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorOutput();
    }

    private Collection<String> prepareMergeTextOutput(List<File> metadataFiles) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("Metadata files (%s):", metadataFiles.size()));
        int idx = 1;
        for (File f : metadataFiles) {
            lines.add(String.format("%s - %s", idx, f.getAbsolutePath()));
            ++idx;
        }
        lines.add(String.format("Destination file: %s", this.stringArg(ARG_DEST, "n/a")));
        return lines;
    }

    private void printMergeToOutputJson(List<File> metadataFiles) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        ObjectNode filesNode = json.putObject("metadataFiles");
        filesNode.put("count", metadataFiles.size());
        ArrayNode filesArr = filesNode.putArray("files");
        for (File f : metadataFiles) {
            filesArr.add(f.getAbsolutePath());
        }
        json.put("dest", this.stringArg(ARG_DEST, "n/a"));
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printMergeToOutput(List<File> metadataFiles) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareMergeTextOutput(metadataFiles));
                break;
            }
            case "JSON": {
                this.printMergeToOutputJson(metadataFiles);
                break;
            }
        }
    }

    private Collection<String> prepareMetadataTextOutput(SnapshotMetadataV2 meta, boolean verbose) {
        boolean isEncryptedSnapshot;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("ID = " + meta.id());
        lines.add("Initiator node ID = " + meta.initiatorNodeId());
        lines.add("Page size = " + meta.pageSize());
        lines.add("Full snapshot = " + meta.fullSnapshot());
        lines.add("Compression option = " + meta.compressionOption());
        lines.add("Compression level = " + this.snapshotCompressionLevel(meta.compressionOption(), meta.compressionLevel()));
        boolean bl = isEncryptedSnapshot = meta.encryptionOptions() != null;
        if (isEncryptedSnapshot) {
            lines.add("Master key name = " + meta.encryptionOptions().getMasterKeyName());
        }
        AffinityTopologyVersion ver = meta.topologyVersion();
        lines.add("Topology version = " + ver.topologyVersion());
        lines.add("Minor topology version = " + ver.minorTopologyVersion());
        lines.add("Message = " + meta.message());
        lines.add("Cache metadata:");
        Map metadata = meta.cacheMetadata();
        lines.add("    Size = " + metadata.size());
        lines.add("    Data: ");
        for (Map.Entry e : metadata.entrySet()) {
            CacheSnapshotMetadata val = (CacheSnapshotMetadata)e.getValue();
            lines.add("        " + e.getKey());
            lines.add("            Group ID = " + val.groupId());
            lines.add("            Cache or group name = " + val.cacheOrGroupName());
            lines.add("            Partition counters:");
            Map sizePerNode = val.partitionSizesPerNode();
            lines.add("                Size = " + sizePerNode.size());
            if (!verbose) continue;
            lines.add("                Data:");
            for (Map.Entry e0 : sizePerNode.entrySet()) {
                lines.add("                    " + e0.getKey() + ":");
                for (Map.Entry e1 : ((Map)e0.getValue()).entrySet()) {
                    lines.add("                        " + (String)e1.getKey() + "=" + e1.getValue());
                }
            }
        }
        return lines;
    }

    private void printMetadataToOutputJson(SnapshotMetadataV2 meta) throws IOException {
        boolean isEncryptedSnapshot;
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", meta.id());
        json.put("initiatorNodeId", meta.initiatorNodeId().toString());
        json.put("pageSize", meta.pageSize());
        json.put("fullSnapshot", meta.fullSnapshot());
        json.put("compressionOption", meta.compressionOption() != null ? meta.compressionOption().name() : CompressionOption.NONE.name());
        json.put("compressionLevel", this.snapshotCompressionLevel(meta.compressionOption(), meta.compressionLevel()));
        boolean bl = isEncryptedSnapshot = meta.encryptionOptions() != null;
        if (isEncryptedSnapshot) {
            json.put("masterKeyName", meta.encryptionOptions().getMasterKeyName());
        }
        ObjectNode topVer = json.putObject("topVer");
        AffinityTopologyVersion ver = meta.topologyVersion();
        topVer.put("topVer", ver.topologyVersion());
        topVer.put("minorTopVer", ver.minorTopologyVersion());
        json.put("msg", meta.message());
        ObjectNode cacheMetas = json.putObject("cacheMetas");
        Map metadata = meta.cacheMetadata();
        cacheMetas.put("size", metadata.size());
        ObjectNode data = cacheMetas.putObject("data");
        for (Map.Entry e : metadata.entrySet()) {
            ObjectNode item = data.putObject(((Integer)e.getKey()).toString());
            CacheSnapshotMetadata val = (CacheSnapshotMetadata)e.getValue();
            item.put("grpId", val.groupId());
            item.put("cacheOrGrpName", val.cacheOrGroupName());
            ObjectNode partCntrs = item.putObject("partCntrs");
            partCntrs.put("size", val.partitionSizesPerNode().size());
            ObjectNode data2 = partCntrs.putObject("data");
            for (Map.Entry e0 : val.partitionSizesPerNode().entrySet()) {
                ObjectNode data3 = data2.putObject(((Integer)e0.getKey()).toString());
                for (Map.Entry e1 : ((Map)e0.getValue()).entrySet()) {
                    data3.put((String)e1.getKey(), (Integer)e1.getValue());
                }
            }
        }
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    public String snapshotCompressionLevel(CompressionOption compressionOption, int level) {
        CompressionOption option;
        CompressionOption compressionOption2 = option = compressionOption == null ? CompressionOption.NONE : compressionOption;
        if (option == CompressionOption.ZIP) {
            return level == -1 ? String.valueOf(1) : String.valueOf(level);
        }
        return "NONE";
    }

    private void printMetadataToOutput(SnapshotMetadataV2 metadata) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareMetadataTextOutput(metadata, true));
                break;
            }
            case "JSON": {
                this.printMetadataToOutputJson(metadata);
                break;
            }
        }
    }

    private static List<File> findMetadata(File path, final String template) {
        ArrayList<File> res = new ArrayList<File>();
        if (path.isDirectory()) {
            File[] metadata = path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().contains(template);
                }
            });
            if (metadata == null) {
                return res;
            }
            Collections.addAll(res, metadata);
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (!f.isDirectory()) continue;
                    res.addAll(CommandMetadata.findMetadata(f, template));
                }
            }
        } else if (path.getName().contains(template)) {
            res.add(path);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SnapshotMetadataV2 unmarshal(File metaData) throws IgniteCheckedException {
        try (InputStream stream = SnapshotUtils.stream((SnapshotPath)new FsSnapshotPath(metaData));){
            Object metadata = jdkMarshaller.unmarshal(stream, U.gridClassLoader());
            if (metadata instanceof SnapshotMetadataV2) {
                SnapshotMetadataV2 snapshotMetadataV2 = (SnapshotMetadataV2)metadata;
                return snapshotMetadataV2;
            }
            if (metadata instanceof SnapshotMetadata) {
                SnapshotMetadataV2 snapshotMetadataV2 = new SnapshotMetadataV2((SnapshotMetadata)metadata);
                return snapshotMetadataV2;
            }
            throw new IllegalArgumentException("Unsupported class - " + metadata.getClass().getName());
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        List<File> metaFiles;
        boolean printFileMode;
        String act = this.stringArg(ARG_ACTION, null);
        boolean printAct = "print".equalsIgnoreCase(act);
        boolean mergeAct = "merge".equalsIgnoreCase(act);
        if (!printAct && !mergeAct) {
            log.error("Valid -action argument should be specified.");
            return 3;
        }
        String src = this.stringArg("-SRC", null);
        String file = this.stringArg(ARG_FILE, null);
        boolean bl = printFileMode = printAct && !F.isEmpty((String)file);
        if (F.isEmpty((String)src) && !printFileMode) {
            log.error("Path to snapshot folder is not specified.");
            return 3;
        }
        long id = this.longArg("-ID", Long.MAX_VALUE);
        if (id == Long.MAX_VALUE && !printFileMode) {
            log.error("Snapshot ID is not specified.");
            return 3;
        }
        String dest = this.stringArg(ARG_DEST, null);
        if (mergeAct && F.isEmpty((String)dest)) {
            log.error("-dest argument should be specified for merge variant of metadata command.");
            return 3;
        }
        String template = this.stringArg(ARG_TEMPLATE, "snapshot-meta.bin");
        if (printFileMode) {
            metaFiles = Collections.singletonList(new File(file));
        } else {
            ArrayList<String> snapFolders = new ArrayList<String>();
            Collections.addAll(snapFolders, src.split(","));
            if (Objects.equals(act, "print") && snapFolders.size() > 1) {
                log.error("Only one source folder is available for print variant of metadata command.");
                return 3;
            }
            metaFiles = CommandMetadata.findMetadataFiles(snapFolders, id, template);
        }
        if (metaFiles != null) {
            SnapshotMetadataV2 metadata = null;
            if (printAct) {
                metadata = this.unmarshal(metaFiles.get(0));
                this.printToConsole(this.prepareMetadataTextOutput(metadata, this.hasArg("-VERBOSE")));
                this.printMetadataToOutput(metadata);
            } else {
                int cnt = 1;
                int total = metaFiles.size();
                for (File f : metaFiles) {
                    if (metadata == null) {
                        metadata = this.unmarshal(f);
                    } else {
                        metadata.merge(this.unmarshal(f));
                        log.info("Merged [{}/{}] - {}", (Object)cnt, (Object)total, (Object)f.getName());
                    }
                    ++cnt;
                }
                File saveTo = new File(dest);
                if (saveTo.isDirectory()) {
                    saveTo = new File(dest + "merged-" + template + "-" + U.currentTimeMillis());
                }
                FileOutputStream out = new FileOutputStream(saveTo);
                jdkMarshaller.marshal((Object)metadata, (OutputStream)out);
                log.info("Merged metadata saved: {}", (Object)saveTo.getAbsolutePath());
                this.printToConsole(this.prepareMergeTextOutput(metaFiles));
                this.printMergeToOutput(metaFiles);
            }
        }
        return 0;
    }

    @Nullable
    public static List<File> findMetadataFiles(List<String> snapFolders, final long id, String template) {
        ArrayList snapDirs = new ArrayList();
        for (String snapFolder : snapFolders) {
            File snapDir = new File(snapFolder);
            Object[] snaps = snapDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() && f.getName().contains(Long.toString(id));
                }
            });
            if (F.isEmpty((Object[])snaps)) continue;
            Collections.addAll(snapDirs, snaps);
        }
        if (snapDirs.isEmpty()) {
            log.warn("Snapshot with ID {} not found.", (Object)id);
            return null;
        }
        ArrayList<File> metaFiles = new ArrayList<File>();
        for (File snapDir : snapDirs) {
            List<File> snapMetaFiles = CommandMetadata.findMetadata(snapDir, template);
            metaFiles.addAll(snapMetaFiles);
        }
        if (F.isEmpty(metaFiles)) {
            log.warn("Metadata files are not found.");
            return null;
        }
        return metaFiles;
    }
}

