/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.database.utility.Utils;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.visor.database.snapshot.VisorListSnapshotsTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;

public class CommandList
extends CommandRemote {
    private static final String UNKNOWN = "<UNKNOWN>";

    public CommandList() {
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    public String name() {
        return "LIST";
    }

    @Override
    public int errorBase() {
        return 2000;
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will print list with information about snapshots in cluster.");
        this.addHelpUsage("[-src=path1[,path2,...,pathN]]", "[-verbose]");
        this.addHelpExample();
        this.addHelpExample("-verbose");
        this.addHelpExample("-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-host=192.168.1.10");
        this.addHelpExample("-host=192.168.1.10", "-src=/snapshots/2016/12,/snapshots/2017/01");
        this.addHelpExample("-host=192.168.1.10", "-src=/snapshots/2016/12,/snapshots/2017/01", "-key_alias=my_sftp");
        this.addHelpExample("-host=192.168.1.10", "-output=my_file.txt");
        this.addHelpExample("-output=my_file.txt", "-format=json");
        this.addHelpArguments();
        this.addHelpIndent("-src=path1[,path2,...,pathN] - list of optional folders to search for snapshot files.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent("-verbose - this argument enable verbose mode, for example, cache names.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(910, "snapshot utility failed to find directory.");
        this.addHelpErrorOutput();
    }

    private Set<String> snapshotFolders(VisorSnapshotInfo snapshot) {
        Set<String> folders = SnapshotUtils.getSnapshotFolders((Map)snapshot.attributes());
        return folders.isEmpty() ? Collections.singleton(UNKNOWN) : folders;
    }

    private Collection<String> prepareTextOutput(List<VisorSnapshotInfo> snapshots, boolean verbose) {
        ArrayList<String> lines = new ArrayList<String>();
        if (F.isEmpty(snapshots)) {
            lines.add("No snapshots found");
        } else {
            HashMap<String, List> map = new HashMap<String, List>();
            int full = 0;
            for (VisorSnapshotInfo visorSnapshotInfo : snapshots) {
                for (String dstPath : this.snapshotFolders(visorSnapshotInfo)) {
                    map.computeIfAbsent(dstPath, x -> new ArrayList()).add(visorSnapshotInfo);
                }
                if (!visorSnapshotInfo.isFullSnapshot()) continue;
                ++full;
            }
            for (Map.Entry entry : map.entrySet()) {
                lines.add("Path - " + (String)entry.getKey());
                lines.add("List of snapshots:");
                ((List)entry.getValue()).forEach(snap -> lines.add(this.createTextSnapshotView((VisorSnapshotInfo)snap, verbose)));
                lines.add("--------------------------------------------------------------------------------");
            }
            this.addTextPitrIntervals(lines, snapshots);
            int sz = snapshots.size();
            lines.add("Number of full snapshots: " + full);
            lines.add("Number of incremental snapshots: " + (sz - full));
            lines.add("Total number of snapshots: " + sz);
        }
        return lines;
    }

    private String createTextSnapshotView(VisorSnapshotInfo snap, boolean verbose) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put("ID", snap.getSnapshotId());
        fields.put("CREATED", Utils.snapshotCreationDate(snap.getSnapshotId()));
        fields.put("TYPE", Utils.snapshotType(snap.isFullSnapshot()));
        fields.put("SIZE", U.humanReadableByteCount((long)snap.getSize()));
        fields.put("WAL SIZE", snap.getWalSize() > 0L ? U.humanReadableByteCount((long)snap.getWalSize()) : null);
        fields.put("CLUSTER SIZE", snap.getClusterSize());
        fields.put("BASELINE TOPOLOGY SIZE", this.baselineTopology(snap));
        fields.put("CACHES COUNT", snap.getCacheNames().size());
        fields.put("COMPRESSION OPTION", this.snapshotCompressionOption(snap));
        fields.put("COMPRESSION LEVEL", this.snapshotCompressionLevel(snap));
        fields.put("MASTER KEY NAME", F.isEmpty((String)snap.getMasterKeyName()) ? null : snap.getMasterKeyName());
        fields.put("PRODUCT VERSIONS", snap.getClusterNodesVersions());
        fields.put("CACHES", verbose ? this.sorted(snap.getCacheNames()) : null);
        return fields.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + '=' + e.getValue()).collect(Collectors.joining(", "));
    }

    private void printToOutputJson(List<VisorSnapshotInfo> snapshots) throws IOException {
        ObjectNode rootNode = MAPPER.createObjectNode();
        ArrayNode json = rootNode.putArray("snapshots");
        snapshots.stream().map(this::createJsonSnapshotView).forEach(arg_0 -> ((ArrayNode)json).add(arg_0));
        this.addJsonPitrIntervals(rootNode, snapshots);
        int sz = snapshots.size();
        long full = snapshots.stream().filter(VisorSnapshotInfo::isFullSnapshot).count();
        rootNode.put("fullSnapshotsCount", full);
        rootNode.put("incrementalSnapshotsCount", (long)sz - full);
        rootNode.put("count", sz);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode));
    }

    private JsonNode createJsonSnapshotView(VisorSnapshotInfo snapshot) {
        ObjectNode res = MAPPER.createObjectNode();
        res.put("id", snapshot.getSnapshotId());
        res.put("created", Utils.snapshotCreationDate(snapshot.getSnapshotId()));
        res.put("type", Utils.snapshotType(snapshot.isFullSnapshot()));
        res.put("size", U.humanReadableByteCount((long)snapshot.getSize()));
        if (snapshot.getWalSize() > 0L) {
            res.put("walSize", U.humanReadableByteCount((long)snapshot.getWalSize()));
        }
        List versions = snapshot.getClusterNodesVersions().stream().map(Object::toString).collect(Collectors.toList());
        ArrayNode jsonVersions = (ArrayNode)MAPPER.valueToTree(versions);
        res.putArray("productVersions").addAll(jsonVersions);
        ArrayNode snapshotFolders = (ArrayNode)MAPPER.valueToTree(this.snapshotFolders(snapshot));
        res.putArray("snapshotFolder").addAll(snapshotFolders);
        res.put("compressionOption", this.snapshotCompressionOption(snapshot));
        res.put("compressionLevel", this.snapshotCompressionLevel(snapshot));
        if (!F.isEmpty((String)snapshot.getMasterKeyName())) {
            res.put("masterKeyName", snapshot.getMasterKeyName());
        }
        ObjectNode jsonTop = res.putObject("topology");
        jsonTop.put("size", snapshot.getClusterSize());
        jsonTop.put("baseline", this.baselineTopologyInt(snapshot));
        this.addJsonCaches(res, snapshot.getCacheNames());
        return res;
    }

    private void printToOutput(List<VisorSnapshotInfo> snapshots) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(snapshots, true));
                break;
            }
            case "JSON": {
                this.printToOutputJson(snapshots);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        List snapshots = (List)this.execute(VisorListSnapshotsTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(-1L).withPaths(this.listArg("-SRC")).withKeyAlias(this.stringArg("-KEY_ALIAS", null)).withMessage(this.message()).build());
        this.printToOutput(snapshots);
        this.printToConsole(this.prepareTextOutput(snapshots, this.hasArg("-VERBOSE")));
        return 0;
    }

    static List<T2<Long, Long>> pitrIntervals(Collection<VisorSnapshotInfo> snapshotInfos) {
        if (snapshotInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VisorSnapshotInfo> snapshots = new ArrayList<VisorSnapshotInfo>(snapshotInfos);
        snapshots.sort(Comparator.comparing(VisorSnapshotInfo::getSnapshotId));
        ArrayList<T2<Long, Long>> res = new ArrayList<T2<Long, Long>>();
        long start = 0L;
        for (int i = 0; i < snapshots.size(); ++i) {
            long end;
            VisorSnapshotInfo info = (VisorSnapshotInfo)snapshots.get(i);
            assert (info != null);
            assert (info.getSnapshotId() > 0L);
            if (info.getWalSize() > 0L) {
                long l = start = start == 0L ? info.getSnapshotId() : start;
            }
            if (info.getWalSize() > 0L && i != snapshotInfos.size() - 1) continue;
            long l = end = i == snapshotInfos.size() - 1 ? U.currentTimeMillis() : info.getSnapshotId();
            if (start <= 0L) continue;
            res.add((T2<Long, Long>)new T2((Object)start, (Object)end));
            start = 0L;
        }
        return res;
    }

    private void addTextPitrIntervals(Collection<String> lines, Collection<VisorSnapshotInfo> snapshotInfos) {
        List<T2<Long, Long>> pitrIntervals = CommandList.pitrIntervals(snapshotInfos);
        if (!pitrIntervals.isEmpty()) {
            lines.add("Time intervals available for Point-in-Time Recovery:");
            for (T2<Long, Long> interval : pitrIntervals) {
                lines.add(Utils.snapshotCreationDate((Long)interval.get1()) + " - " + Utils.snapshotCreationDate((Long)interval.get2()));
            }
        }
    }

    private void addJsonPitrIntervals(ObjectNode node, Collection<VisorSnapshotInfo> snapshotInfos) {
        List<T2<Long, Long>> pitrIntervals = CommandList.pitrIntervals(snapshotInfos);
        if (!pitrIntervals.isEmpty()) {
            ArrayNode intervalsJson = node.putArray("pitrIntervals");
            for (T2<Long, Long> interval : pitrIntervals) {
                intervalsJson.addObject().put("start", (Long)interval.get1()).put("end", (Long)interval.get2());
            }
        }
    }
}

