/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import java.io.IOException;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.database.utility.commands.Command;

abstract class CommandDirect
extends Command {
    protected static final String HELP_USAGE_SRC_SINGLE = "-src=SNAPSHOT_FOLDER";
    protected static final String HELP_USAGE_SRC_MULTI = "-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...]";
    protected static final String HELP_EXAMPLE_SRC_SINGLE = "-src=SNAPSHOT_FOLDER1";
    protected static final String HELP_EXAMPLE_SRC_MULTI = "-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...]";
    protected static final String HELP_ARG_SRC_SINGLE = "-src=SNAPSHOT_FOLDER - path to folder with snapshot.";
    protected static final String HELP_ARG_SRC_MULTI = "-src=SNAPSHOT_FOLDER1[,SNAPSHOT_FOLDER2,...] - paths to folders with snapshots.";

    CommandDirect() {
    }

    protected void addHelpUsage(String ... usages) {
        this.addHelp("");
        StringBuilder line = new StringBuilder(300);
        line.append("Usage: ").append(this.name());
        if (!F.isEmpty((Object[])usages)) {
            for (String usage : usages) {
                line.append(' ').append(usage);
            }
        }
        this.addHelp(line.toString());
        this.addHelpIndent("[-output=" + this.defaultOutputFileName() + "] [-format=text|json]").NL();
    }

    protected void addHelpCommonArgs(boolean addFormatHelp) {
        this.addHelpIndent("-output=" + this.defaultOutputFileName() + " - file to output command result in machine-readable format,");
        this.addHelpIndent("  by default " + this.defaultOutputFileName() + " will be used.");
        this.NL();
        if (addFormatHelp) {
            this.addHelpIndentLn("-format=text|json - write command output in specified format: text or JSON.");
        }
    }

    protected String optionlArg(String arg) {
        return '[' + arg + ']';
    }

    protected abstract int executeCmd() throws Throwable;

    @Override
    protected int execute0() {
        try {
            return this.executeCmd();
        }
        catch (IllegalArgumentException e) {
            int errCode = this.error(120, this.exceptionMessage(e, "Invalid or missing arguments for " + this.name() + " command"), e);
            log.info("Please read documentation for {} command:", (Object)this.name());
            this.printHelp();
            return errCode;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (this.containsIgnoreCase(msg, "Failed to get information from snapshots catalog")) {
                return this.error(900, msg, e);
            }
            return this.error(800, msg, e);
        }
        catch (Throwable e) {
            return this.error(e);
        }
    }
}

