/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCheckSnapshotTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotIssue;

public class CommandCheck
extends CommandRemote {
    private static final String HELP_ARG_CHECK_FORCE = "-force - check to restore specific caches(from 'caches' list) and all other caches from their groups.";

    public CommandCheck() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-SRC");
        this.supportedArgs.add("-KEY_ALIAS");
        this.supportedArgs.add("-CACHES");
        this.supportedArgs.add("-EXCLUDED_CACHES");
        this.supportedArgs.add("-FORCE");
        this.supportedArgs.add("-NOPROGRESS");
        this.supportedArgs.add("-PROGRESS");
        this.supportedArgs.add("-COMMENT");
        this.supportedArgs.add("-PARALLELISM");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will check whether specified snapshot is not broken and logically consistent.");
        this.addHelpUsage("-id=SNAPSHOT_ID", "[-src=path1[,path2,...,pathN]]", "[-caches=cache1,cache2,...,cacheN]", "[-force]", "[-verbose]");
        this.addHelpExample();
        this.addHelpExample("-id=1234567");
        this.addHelpExample("-id=1234567", "-verbose");
        this.addHelpExample("-id=1234567", "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample("-id=1234567", "-src=/snapshots/2016/12,/snapshots/2017/01");
        this.addHelpExample("-id=1234567", "-src=/snapshots/2016/12,/snapshots/2017/01", "-key_alias=my_sftp");
        this.addHelpExample("-id=1234567", "-caches=cache1,cache2", "-force");
        this.addHelpExample("-id=1234567", "-host=192.168.1.10");
        this.addHelpExample("-id=1234567", "-output=my_file.txt");
        this.addHelpExample("-id=1234567", "-parallelism=4");
        this.addHelpArguments();
        this.addHelpIndent("-id=SNAPSHOT_ID - snapshot identifier to use.").NL();
        this.addHelpIndent("-src=path1[,path2,...,pathN] - list of optional folders to search for snapshot files.").NL();
        this.addHelpIndent("-key_alias=alias - alias for JKS key for working with SFTP server.").NL();
        this.addHelpIndent("-caches=cache1,...,cacheN,group1,...,groupK - list of cache or group names to process.").NL();
        this.addHelpIndent("-excluded_caches=cache1,...,cacheN,group1,...groupK  - list of cache or group names excluded from processing.").NL();
        this.addHelpIndent("-noprogress - do not print progress bar.").NL();
        this.addHelpIndent("-progress=DELAY - delay (sec) for progress bar update, default is 5 sec.").NL();
        this.addHelpIndent(HELP_ARG_CHECK_FORCE).NL();
        this.addHelpIndent("-parallelism=N - determines parallel execution (threads) of snapshot operation, 1 to N").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(500, "snapshot utility failed to find snapshot with specified ID.");
        this.addHelpError(510, "snapshot is broken.");
        this.addHelpError(600, "snapshot utility failed to find cache with specified name.");
        this.addHelpError(700, "groups to restore of specified caches have more caches than specified. Use '-force' flag to restore this caches.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "CHECK";
    }

    @Override
    public int errorBase() {
        return 6000;
    }

    protected Collection<String> prepareTextOutput(long id, Map<String, Collection<VisorSnapshotIssue>> issues) {
        ArrayList<String> lines = new ArrayList<String>();
        if (F.isEmpty(issues)) {
            lines.add("Snapshot ID " + id + " is valid");
            return lines;
        }
        int errCode = this.errorCode(510);
        lines.addAll(this.prepareTextErrorOutput((T2<Integer, String>)new T2((Object)errCode, (Object)this.errorMessage(errCode))));
        int size = 0;
        for (Collection<VisorSnapshotIssue> collection : issues.values()) {
            size += collection.size();
        }
        lines.add("Snapshot ID " + id + " is broken. Found " + size + " issues:");
        for (Map.Entry entry : issues.entrySet()) {
            Collection cacheIssues = (Collection)entry.getValue();
            lines.add("  Cache: " + (String)entry.getKey() + ". Found " + cacheIssues.size() + " issues:");
            for (VisorSnapshotIssue issue : cacheIssues) {
                lines.add("    Partition ID: " + issue.getPartitionId() + ". Issue: " + issue.getIssue());
            }
        }
        return lines;
    }

    protected ObjectNode prepareJsonOutput(long id, Map<String, Collection<VisorSnapshotIssue>> issues) {
        ObjectNode json;
        if (issues.isEmpty()) {
            json = MAPPER.createObjectNode();
        } else {
            int errCode = this.errorCode(510);
            json = this.prepareJsonErrorOutput((T2<Integer, String>)new T2((Object)errCode, (Object)this.errorMessage(errCode)));
        }
        json.put("id", id);
        int size = 0;
        for (Collection<VisorSnapshotIssue> i : issues.values()) {
            size += i.size();
        }
        json.put("issuesTotal", size);
        ArrayNode caches = json.putArray("caches");
        for (Map.Entry<String, Collection<VisorSnapshotIssue>> entry : issues.entrySet()) {
            Collection<VisorSnapshotIssue> cacheIssues = entry.getValue();
            ObjectNode cache = caches.addObject();
            cache.put("cache", entry.getKey());
            cache.put("issuesSize", cacheIssues.size());
            ArrayNode issuesJson = cache.putArray("issues");
            for (VisorSnapshotIssue issue : cacheIssues) {
                ObjectNode issueJson = MAPPER.createObjectNode();
                issueJson.put("partitionId", issue.getPartitionId());
                issueJson.put("issue", issue.getIssue());
                issuesJson.add((JsonNode)issueJson);
            }
        }
        return json;
    }

    protected void printToOutput(long id, Map<String, Collection<VisorSnapshotIssue>> issues) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(id, issues));
                break;
            }
            case "JSON": {
                ObjectNode json = this.prepareJsonOutput(id, issues);
                this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
                break;
            }
        }
    }

    protected Map<String, Collection<VisorSnapshotIssue>> check(long id, Collection<String> sources, String keyAlias, Collection<String> cacheNames, Collection<String> excludedCacheNames, boolean force, boolean skipCrc, int parallelism) throws Throwable {
        List issues = (List)this.execute(VisorCheckSnapshotTask.class, new VisorSnapshotInfo.Builder().withSnapshotId(id).withForce(force).withSkipCrc(skipCrc).withPaths(sources).withKeyAlias(keyAlias).withCacheNames(cacheNames).withExcludedCacheNames(excludedCacheNames).withMessage(this.message()).withSnapshotCommonParameters(new SnapshotCommonParameters(parallelism)).build());
        HashMap<String, Collection<VisorSnapshotIssue>> cachesIssues = new HashMap<String, Collection<VisorSnapshotIssue>>();
        for (VisorSnapshotIssue issue : issues) {
            String cache = issue.getCacheName();
            ArrayList<VisorSnapshotIssue> cacheIssues = (ArrayList<VisorSnapshotIssue>)cachesIssues.get(cache);
            if (cacheIssues == null) {
                cacheIssues = new ArrayList<VisorSnapshotIssue>();
                cachesIssues.put(cache, cacheIssues);
            }
            cacheIssues.add(issue);
        }
        return cachesIssues;
    }

    @Override
    protected boolean customErrorOutput(int status) {
        return status == this.errorCode(510);
    }

    @Override
    protected int executeCmd() throws Throwable {
        long id = this.longArg("-ID", -1L);
        int parallelism = this.intArg("-PARALLELISM", 1);
        if (id < 0L) {
            throw new IllegalArgumentException("Snapshot ID was not specified");
        }
        Map<String, Collection<VisorSnapshotIssue>> issues = this.check(id, this.listArg("-SRC"), this.stringArg("-KEY_ALIAS", null), this.listArg("-CACHES"), this.listArg("-EXCLUDED_CACHES"), this.hasArg("-FORCE"), false, parallelism);
        this.printToConsole(this.prepareTextOutput(id, issues));
        this.printToOutput(id, issues);
        if (issues.isEmpty()) {
            return 0;
        }
        return this.errorCode(510);
    }
}

