/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.database.utility.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.database.utility.commands.CommandRemote;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCancelSnapshotOperationTask;
import org.gridgain.grid.internal.visor.database.snapshot.VisorCancelSnapshotOperationTaskArg;

public class CommandCancel
extends CommandRemote {
    private static final String HELP_USAGE_OPERATION_ID = "-id=operationId";
    private static final String HELP_EXAMPLE_OPERATION_ID = "-id=1df9ace9b51-537536a4-e47d-4446-b0e4-2b9ea1c2aff9";
    private static final String HELP_ARG_ID = "-id=operationId - snapshot operation unique ID.";

    public CommandCancel() {
        this.supportedArgs.add("-ID");
        this.supportedArgs.add("-FORCE");
        this.supportedArgs.add("-COMMENT");
        this.supportedArgs.add("-VERBOSE");
    }

    @Override
    protected void initHelp() {
        this.addHelp("This command will cancel specified snapshot operation.");
        this.addHelpUsage(HELP_USAGE_OPERATION_ID, "[-force]", "[-verbose]");
        this.addHelpExample();
        this.addHelpExample(HELP_EXAMPLE_OPERATION_ID);
        this.addHelpExample(HELP_EXAMPLE_OPERATION_ID, "-verbose");
        this.addHelpExample(HELP_EXAMPLE_OPERATION_ID, "-ssl_enabled -ssl_protocol=SSLv23 -ssl_algorithm=SunX509 -ssl_truststore_type=jks -ssl_truststore_path=/path/to/truststore.jks -ssl_truststore_password=<PASSWORD> -ssl_key_store_type=pkcs12 -ssl_key_store_path=/path/to/keystore.pkcs12 -ssl_key_store_password=<PASSWORD>");
        this.addHelpExample(HELP_EXAMPLE_OPERATION_ID, "-force");
        this.addHelpExample(HELP_EXAMPLE_OPERATION_ID, "-host=192.168.1.10", "-output=my_file.txt");
        this.addHelpArguments();
        this.addHelpIndent(HELP_ARG_ID).NL();
        this.addHelpIndent("-force - tries to cancel an ongoing snapshot operation.");
        this.addHelpIndent("  After forced cancellation, temporary files may remain and data in storage may be inconsistent.").NL();
        this.addHelpCommonArgs();
        this.addHelpError();
        this.addHelpErrorArgs();
        this.addHelpErrorCommon();
        this.addHelpError(960, "the operation for specified ID not found.");
        this.addHelpErrorOutput();
    }

    @Override
    public String name() {
        return "CANCEL";
    }

    @Override
    public int errorBase() {
        return 11000;
    }

    private Collection<String> prepareTextOutput(String opId) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Cancellation status:");
        lines.add("  ID: " + opId);
        lines.add("  Cancelled: true");
        return lines;
    }

    private void printToOutputJson(String opId) throws IOException {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", opId);
        json.put("cancelled", true);
        this.writeToOutput(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
    }

    private void printToOutput(String opId) throws IOException {
        switch (this.outputFormat()) {
            case "TEXT": {
                this.writeToOutput(this.prepareTextOutput(opId));
                break;
            }
            case "JSON": {
                this.printToOutputJson(opId);
                break;
            }
        }
    }

    @Override
    protected int executeCmd() throws Throwable {
        String opId = this.stringArg("-ID", "");
        try {
            IgniteUuid.fromString((String)opId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Operation ID was not specified", e);
        }
        Boolean canceled = (Boolean)this.execute(VisorCancelSnapshotOperationTask.class, new VisorCancelSnapshotOperationTaskArg(opId, this.message(), this.hasArg("-FORCE")));
        if (!canceled.booleanValue()) {
            return this.error(960, "The snapshot operation not found for ID: " + opId, null);
        }
        this.printToConsole("Snapshot operation canceled!");
        this.printToOutput(opId);
        return 0;
    }
}

